<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Medilink;
$nav_menu_args = Helper::nav_menu_args();
// Logo
$rdtheme_dark_logo  = empty( RDTheme::$options['logo']['url'] ) ? Helper::get_img( 'logo-dark.png' ) : RDTheme::$options['logo']['url'];
$rdtheme_light_logo = empty( RDTheme::$options['logo_light']['url'] ) ? Helper::get_img( 'logo-light.png' ) : RDTheme::$options['logo_light']['url'];
$rdtheme_logo_width = (int) RDTheme::$options['logo_width'];
$rdtheme_menu_width = 9 - $rdtheme_logo_width;
$rdtheme_logo_class = "col-sm-{$rdtheme_logo_width} col-xs-12";
$rdtheme_menu_class = "col-sm-{$rdtheme_menu_width} col-xs-12";
?>
<div class="masthead-container full-width-left-compress new-header-2">
	<div class="container-fluid">
		<div class="row no-gutters d-flex align-items-center">
			<div class="<?php echo esc_attr( $rdtheme_logo_class );?>">
				<div class="site-branding site-logo">
					<a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><img src="<?php echo esc_url( $rdtheme_dark_logo );?>" alt="<?php esc_attr( bloginfo( 'name' ) ) ;?>"></a>
					<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><img src="<?php echo esc_url( $rdtheme_light_logo );?>" alt="<?php esc_attr( bloginfo( 'name' ) ) ;?>"></a>
				</div>
			</div>
			<div class="<?php echo esc_attr( $rdtheme_menu_class );?>">		
				<div id="site-navigation" class="main-navigation">
					<?php wp_nav_menu( $nav_menu_args );?>
				</div>
			</div>
			<div class="col-lg-3 col-md-2 d-none d-lg-block">
				<?php if ( RDTheme::$options['header_btn'] ): ?>
					<ul class="header-action-items">
					    <li>
					        <a href="<?php echo esc_url( RDTheme::$options['header_buttonUrl'] );?>" title="Appointment" class="btn-fill color-yellow btn-header"><?php echo esc_html( RDTheme::$options['header_buttontext'] );?></a>
					    </li>
					</ul>
			  <?php endif; ?>
			</div>
		</div>		
	</div>
</div>