<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Medilink;

// Layout class
if ( RDTheme::$layout == 'full-width' ) {
	$layout_class = 'col-sm-12 col-xs-12';
	$col_class    = 'col-lg-4 col-md-6 col-sm-6 col-xs-12';
}
else{
	$layout_class = 'col-sm-8 col-md-8 col-xs-12';
	$col_class    = 'col-lg-6 col-md-6 col-sm-12 col-xs-12';
}

// Template
$template_bg_sty='';
$gutters='';
$container_class='container';
switch ( RDTheme::$options['departments_arc_style'] ) {
	case 'style2':
		$template = 'departments-2';
		$template_bg_sty = 'bg-light-accent100';		
		break;
	case 'style3':
		$template = 'departments-3';
		$template_bg_sty = 'bg-light-accent100';	
		break;	
	default:
		$template = 'departments-1';
		$template_bg_sty = 'bg-light-accent100';	

		break;
}
?>
<?php get_header(); ?>
<div id="primary" class="content-area <?php echo esc_attr( $template_bg_sty );?>">
	<div class="<?php echo esc_attr( $container_class );?>">
		<div class="row">
			<?php
			if ( RDTheme::$layout == 'left-sidebar' ) {
				get_sidebar();
			}
			?>
			<div class="<?php echo esc_attr( $layout_class );?>">
				<main id="main" class="site-main rt-departments-archive">
					<?php if ( have_posts() ) :?>
						<div class="row auto-clear <?php echo esc_attr( $gutters );?>">
							<?php while ( have_posts() ) : the_post(); ?>
								<div class="<?php echo esc_attr( $col_class );?>">
									<?php get_template_part( 'template-parts/content', $template ); ?>
								</div>
							<?php endwhile; ?>
						</div>
						<?php Helper::pagination();?>
					<?php else:?>
						<?php get_template_part( 'template-parts/content', 'none' );?>
					<?php endif;?>
				</main>
			</div>
			<?php
			if ( RDTheme::$layout == 'right-sidebar' ) {
				get_sidebar();
			}
			?>
		</div>
	</div>
</div>
<?php get_footer(); ?>