<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Medilink_Core;

use radiustheme\Medilink\RDTheme;
use \RT_Posts;

if ( ! defined( 'ABSPATH' ) ) exit;

if ( !class_exists( 'RT_Posts' ) ) {
	return;
}
$prefix = MEDILINK_CORE_CPT;
$eventalk_post_types = array(
	"{$prefix}_doctor"        => array(
		'title'        => esc_html__( 'Doctors', 'medilink-core' ),
		'plural_title' => esc_html__( 'Doctors', 'medilink-core' ),
		'menu_icon'    => 'dashicons-businessman',
		'rewrite'      => RDTheme::$options['doctors_slug'],
        'supports'     => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' ),
		),

	"{$prefix}_departments"        => array(
		'title'        => esc_html__( 'Departments', 'medilink-core' ),
		'plural_title' => esc_html__( 'Departments', 'medilink-core' ),
		'menu_icon'    => 'dashicons-clipboard',
		'supports'     => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' ),
		'rewrite'      => RDTheme::$options['departments_slug'],
		),	
		"{$prefix}_gallrey"   => array(
			'title'           => esc_html__( 'Gallery', 'medilink-core' ),
			'plural_title'    => esc_html__( 'Gallery', 'medilink-core' ),
			'menu_icon'       => 'dashicons-format-gallery',
			'rewrite'         => RDTheme::$options['gallery_slug'],
			'supports'        => array( 'title', 'thumbnail', 'editor','excerpt', 'page-attributes' )
		),	
		"{$prefix}_services"   => array(
			'title'           => esc_html__( 'Services', 'eventalk-core' ),
			'plural_title'    => esc_html__( 'Services', 'eventalk-core' ),
			'menu_icon'       => 'dashicons-sos',
			'rewrite'         => RDTheme::$options['services_slug'],
			'supports'        => array( 'title', 'thumbnail', 'editor','excerpt', 'page-attributes' )
		),
	);

$eventalk_taxonomies = array(
	"{$prefix}_doctor_category" => array(
		'title'        => esc_html__( 'Doctor Category', 'medilink-core' ),
		'plural_title' => esc_html__( 'Categories', 'medilink-core' ),
		'post_types'   => "{$prefix}_doctor",
		),
	"{$prefix}_departments_category" => array(
		'title'        => esc_html__( 'Departments Category', 'medilink-core' ),
		'plural_title' => esc_html__( 'Categories', 'medilink-core' ),
		'post_types'   => "{$prefix}_departments",
		),
		"{$prefix}_gallrey_category" => array(
			'title'        => esc_html__( 'Gallery Category', 'medilink-core' ),
			'plural_title' => esc_html__( 'Gallery Categories', 'medilink-core' ),
			'post_types'   => "{$prefix}_gallrey",
			'rewrite'      => array( 'slug' => RDTheme::$options['gallery_cat_slug'] ),
		),
		"{$prefix}_services_category" => array(
			'title'        => esc_html__( 'Services Category', 'medilink-core' ),
			'plural_title' => esc_html__( 'Categories', 'medilink-core' ),
			'post_types'   => "{$prefix}_services",
			'rewrite'      => array( 'slug' => RDTheme::$options['services_cat_slug'] ),
		),
		
	);

$EVENTALK_Posts = RT_Posts::getInstance();
$EVENTALK_Posts->add_post_types( $eventalk_post_types );
$EVENTALK_Posts->add_taxonomies( $eventalk_taxonomies );