<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Medilink_Core;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class CTA extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Call to Action', 'medilink-core' );
		$this->rt_base = 'rt-cta';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$fields = array(			
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => __( 'General', 'medilink-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout',
				'label'   => esc_html__( 'Layout', 'medilink-core' ),
				'options' => array(
					'layout1' => esc_html__( 'Layout 1', 'medilink-core' ),
					'layout2' => esc_html__( 'Layout 2', 'medilink-core' ),				
					'layout3' => esc_html__( 'Layout 3', 'medilink-core' ),				
					'layout4' => esc_html__( 'Layout 4', 'medilink-core' ),				
				),
				'default' => 'layout1',
			),			
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'subtitle',
				'label'   => __( 'Sub Title', 'medilink-core' ),
				'default' => 'Lorem Ipsum has been standard daand scrambled',
				'condition'   => array( 'layout' => array( 'layout4') ),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => __( 'Title', 'medilink-core' ),
				'default' => 'Lorem Ipsum has been standard daand scrambled',
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'    => 'image',
				'label'   => esc_html__( 'Image', 'medilink-core' ),
				'description' => esc_html__( 'Image size should be 1920x820 px', 'medilink-core' ),
				'condition'   => array( 'layout' => array( 'layout2') ),	
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'    => 'callphone',
				'label'   => esc_html__( 'Phone No', 'medilink-core' ),
				'default' => '+123 44092 888',
			    'condition'   => array( 'layout' => array( 'layout2') ),	
			),

			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'theme',
				'label'   => __( 'Background Theme', 'medilink-core' ),
				'options' => array(
					'transparent' 	=> __( 'Transparent', 'medilink-core' ),
					'light' 		=> __( 'Light', 'medilink-core' ),
					'dark'  		=> __( 'Dark', 'medilink-core' ),
					'primary' 		=> __( 'Primary', 'medilink-core' ),
					'grey'  		=> __( 'Grey', 'medilink-core' ),
				),
				'default' => 'primary',		
				'condition'   => array( 'layout' => array( 'layout1') ),			
			),
			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'themecolor',
				'label'   => __( 'Theme Color', 'medilink-core' ),
				'options' => array(					
					'color-light' 		=> __( 'Light', 'medilink-core' ),
					'color-dark'  		=> __( 'Dark', 'medilink-core' ),
					'color-primary' 		=> __( 'Primary', 'medilink-core' ),
					
				),
				'default' => 'color-dark',	
				'condition'   => array( 'theme' => array( 'transparent', 'grey', 'light'),'layout' => array( 'layout1') ),			
			),

			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'buttontext',
				'label'   => __( 'Button Text', 'medilink-core' ),
				'default' => 'Make an Appointment',
			),
			array(
				'type'    => Controls_Manager::URL,
				'id'      => 'buttonurl',
				'label'   => __( 'Button URL', 'medilink-core' ),
				'placeholder' => 'https://your-link.com',
			),
			array(
				'mode' => 'section_end',
			),			
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		switch ( $data['layout'] ) {
			case 'layout2':
				$template = 'cta-2';
			break;	
			case 'layout3':
				$template = 'cta-3';
			break;	
			case 'layout4':
				$template = 'cta-4';
			break;			
			default:
				$template = 'cta-1';
		break;
		}
		return $this->rt_template( $template, $data );
	}
}