<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Medilink_Core;
use Elementor\Controls_Manager;
if ( ! defined( 'ABSPATH' ) ) exit;
class Counter extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Counter', 'mediplus-core' );
		$this->rt_base = 'rt-counter';
		parent::__construct( $data, $args );
	}
	private function rt_load_scripts(){
		wp_enqueue_script( 'waypoints' );
		wp_enqueue_script( 'jquery-counterup' );
	}
	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'mediplus-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout',
				'label'   => esc_html__( 'Layout', 'medilink-core' ),
				'options' => array(
					'layout1' => esc_html__( 'Layout 1', 'medilink-core' ),
					'layout2' => esc_html__( 'Layout 2', 'medilink-core' ),					
				),
				'default' => 'layout1',
			),
			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'icontype',
				'label'   => esc_html__( 'Icon Type', 'mediplus-core' ),
				'options' => array(
					'icon'  => esc_html__( 'Icon', 'mediplus-core' ),
					'image' => esc_html__( 'Custom Image', 'mediplus-core' ),
				),
				'default' => 'icon',	
			),
			array(
				'type'    => Controls_Manager::ICON,
				'id'      => 'icon',
				'label'   => esc_html__( 'Icon', 'mediplus-core' ),
				'default' => 'fa fa-handshake-o',				
				'condition'   => array( 'icontype' => array( 'icon' )),
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'image',
				'label'   => esc_html__( 'Image', 'mediplus-core' ),
				'condition'   => array( 'icontype' => array( 'image' ) ),
				'description' => esc_html__( 'Recommended image Background', 'mediplus-core' ),
				'condition'   => array( 'icontype' => array( 'image' )),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number',
				'label'   => esc_html__( 'Counter Number', 'mediplus-core' ),
				'default' => 5000,
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'suffix',
				'label'   => esc_html__( 'Counter Suffix', 'mediplus-core' ),
				'description' => esc_html__( 'Put any text or symbol after Counter Number eg. +', 'mediplus-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'mediplus-core' ),
				'default' => esc_html__( 'Satisfied Customers', 'mediplus-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'speed',
				'label'   => esc_html__( 'Animation Speed', 'mediplus-core' ),
				'default' => 5000,
				'description' => esc_html__( 'The total duration of the count animation in milisecond eg. 5000', 'mediplus-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'steps',
				'label'   => esc_html__( 'Animation Steps', 'mediplus-core' ),
				'default' => 10,
				'description' => esc_html__( 'Counter steps eg. 10', 'mediplus-core' ),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		$this->rt_load_scripts();
		switch ( $data['layout'] ) {
		case 'layout2':
			$template = 'counter-2';
		break;		
		default:
			$template = 'counter-1';
		break;
		}
		return $this->rt_template( $template, $data );
	}
}