<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Mediplus_Core;

use \WP_Query;
use radiustheme\Medilink\RDTheme;
use radiustheme\Medilink\Helper;
$prefix      = MEDILINK_CORE_THEME;
$cpt         = MEDILINK_CORE_CPT;
$thumb_size  = "{$prefix}-size5";

$args = array(
	'post_type'        => "{$cpt}_doctor",
	'posts_per_page'   => -1,
	'suppress_filters' => false,
	'orderby'          => $data['orderby'],
);

switch ( $data['orderby'] ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}

$posts = get_posts( $args );
$uniqueid = time() . rand( 1, 99 );
$doctors 		= array();
$cats    		= array();
$schedules      = array();
foreach ( $posts as $post ) {
	$cats_comma       = array();
	$img              = get_the_post_thumbnail_url( $post, $thumb_size );
	$terms            = get_the_terms( $post, "{$cpt}_doctor_category" );
	$designation      = get_post_meta($post->ID, "{$cpt}_designation", true );
	$schedules   	  = get_post_meta( $post->ID, "{$cpt}_doctors_schedule", true );
	$terms            = $terms ? $terms : array();
	$terms_html       = '';
	$terms_comma_html = '';
	if ( !$terms ) {
		continue;
	}
	foreach ( $terms as $term ) {
		$terms_html  .= " {$uniqueid}-{$term->slug}";
		$cats_comma[] = $term->name;
		if ( !isset( $cats[$term->slug] ) ) {
			$cats[$term->slug] = $term->name;
		}
	}
	$content= null; 
	$content = Helper::get_current_post_content();
	$content = wp_trim_words( $content, $data['count'] );
	$content = "<p>$content</p>";

	  

	$doctors[] = array(
		'img'        		=> $img,
		'designation'		=> $designation,
		'title'      		=> $post->post_title,
		'url'        		=> get_the_permalink( $post ),
		'cats'       		=> $terms_html,
		'cats_comma' 		=> implode(", ", $cats_comma ),
		'schedules' 		=> $schedules,
		'content' 			=> $content ,
	);
}
$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-xs-{$data['col_xs']}";
?>
<div class="rt-el-gallrey-1 rt-isotope-wrapper">		
	<div class="rt-isotope-tab isotope-classes-tab isotop-btn "> 
		<a href="#" data-filter="*" class="current"><?php esc_html_e( 'All', 'mediplus-core' );?></a>
		<?php foreach ( $cats as $key => $value): ?>
			<?php $cat_filter = "{$uniqueid}-{$key}";?>
			<a href="#" data-filter=".<?php echo esc_attr( $cat_filter );?>"><?php echo esc_html( $value );?></a>
		<?php endforeach; ?>
	</div>	
	<div class="row rt-isotope-content">
		<?php foreach ( $doctors as $doctor ): ?>
			<div class="<?php echo esc_attr( $col_class . $doctor['cats'] );?>">
				<div class="team-box-layout2">
                        <?php
						if ( $doctor['img']  ){ ?>									    
                    		<div class="item-img">        
                    		<img src="<?php echo esc_url( $doctor['img'] );?>" alt="<?php echo esc_html( $doctor['title'] );?>">   
                            <ul class="item-icon">
                                <li>
                                    <a href="<?php echo esc_url( $doctor['url'] );?>">
                                        <i class="fas fa-plus"></i>
                                    </a>
                                </li>
                            </ul>
                    		</div>
                        <?php } ?>
                        <div class="item-content">
                            <h3 class="item-title">
                              <a href="<?php echo esc_url( $doctor['url'] );?>"><?php echo esc_html( $doctor['title'] );?></a>
                            </h3>
                            <?php if ( !empty( $data['designation_display'] ) ): ?>
                            	<p><?php echo esc_html($doctor['designation']); ?></p>
 							<?php endif; ?>
                        </div>
						<div class="item-schedule text-center">
							<?php echo $doctor['content']; ?>							          
							<a href="<?php echo esc_url( $doctor['url'] );?>" class="item-btn"><?php echo wp_kses_post( $data['buttontext'] );?></a>
						</div>				  		                     
                </div>
			</div>
		<?php endforeach;?>
	</div>             
</div>


