<?php
/**
 * The template for displaying all single posts and attachments
 */

$theme_options = beautyagency_get_theme_mods();

get_header( 'page' ); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main">

			<div class="post-container <?php echo beautyagency_sidebar_class( "container" ); ?>">
				<div class="row site__row">
					<div class="<?php echo beautyagency_sidebar_class( "content" ); ?>">

						<?php
						// Start the loop.
						while ( have_posts() ) : the_post();

							/*
							 * Include the post format-specific template for the content. If you want to
							 * use this in a child theme, then include a file called called content-___.php
							 * (where ___ is the post format) and that will be used instead.
							 */
							get_template_part( 'partials/content', get_post_format() );

							// Author bio.
							if ( beautyagency_get_customizer_option( 'blog_post_author_bio' ) == 'author_bio_on' ) {
								get_template_part( 'author-bio' );
							}

							// If comments are open or we have at least one comment, load up the comment template.
							if ( comments_open() || get_comments_number() ) :
								comments_template();
							endif;

							// End the loop.
						endwhile;
						?>
					</div>
					<?php if ( beautyagency_sidebar_visible() ) : ?>
						<?php get_sidebar(); ?>
					<?php endif; ?>
				</div>
			</div>

		</main><!-- .site-main -->
	</div><!-- .content-area -->

<?php get_footer(); ?>