<?php
/**
 * The template for displaying search results pages.
 */

get_header( 'page' ); ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main">

		<div class="post-container <?php echo beautyagency_sidebar_class( "container" ); ?>">
			<div class="row site__row">
				<div class="<?php echo beautyagency_sidebar_class( "content" ); ?>">
					<?php if ( have_posts() ) : ?>

						<?php
						// Start the loop.
						while ( have_posts() ) : the_post(); ?>

							<?php
							get_template_part( 'partials/content', get_post_format() );

							// End the loop.
						endwhile;

						// Previous/next page navigation.
						the_posts_pagination( array(
							'prev_text'          => esc_html__( 'PREV', 'beautyagency' ),
							'next_text'          => esc_html__( 'NEXT', 'beautyagency' ),
							'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'beautyagency' ) . ' </span>',
						) );

					// If no content, include the "No posts found" template.
					else :
						get_template_part( 'partials/content', 'none' );

					endif;
					?>
				</div>
				<?php if ( beautyagency_sidebar_visible() ) : ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>
			</div>
		</div>
	</main><!-- .site-main -->
</div><!-- .content-area -->

<?php get_footer(); ?>
