<?php
/**
 * The default template for displaying image inside loop
 *
 * Used for index/archive/search.
 */
$theme_options = beautyagency_get_theme_mods();

$video_position = beautyagency_get_customizer_option( 'single_post_video' );

// Blog view
$blog_view = '';
if ( beautyagency_is_blog_view_excerpt() && ! is_single() && is_home() ) {
	$blog_view = 'blog-view--excerpt';
} else {
	$blog_view = 'blog-view--content';
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $blog_view ); ?>>
	<?php
	// Sticky Label
	$classes = get_post_class();
	if ( in_array( 'sticky', $classes ) && is_sticky() && ! is_single() ) {
		do_action( 'beautyagency_sticky_label' );
	}

	?>
	<div class="entry-content">
		<?php
		$media = beautyagency_parse_media( get_the_content() );
		if ( empty( $media ) ) {
			// Post thumbnail.
			echo '<div class="post__media">';
			if ( has_post_thumbnail() && ! is_single() ) {
				beautyagency_post_time_block();
			}
			beautyagency_post_thumbnail();
			echo '</div>';
		} else {
			// Post video.
			echo '<div class="post__media">';
			if ( ! is_single() ) {
				beautyagency_post_time_block();
			}
			if ( is_single() && ( $video_position == 'wide' ) ) {
				// no video
			} else {
				echo beautyagency_parse_media( get_the_content() );
			}
			echo '</div>';
		}
		?>
		<div class="post__inner">
			<?php
			$categories_list = get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'beautyagency' ) );
			if ( $categories_list && beautyagency_categorized_blog() ) {
				printf( '<div class="cat-links"><span class="screen-reader-text">%1$s </span>%2$s</div>',
					esc_html_x( 'Categories', 'Used before category names.', 'beautyagency' ),
					$categories_list
				);
			}
			?>

			<?php
			beautyagency_post_meta();

			// Post Headers
			do_action( "beautyagency_after_thumbnail" );

			// Post Controls
			beautyagency_post_controls();
			?>

			<div class="post-content">
				<?php
				if ( beautyagency_is_blog_view_excerpt() && ! is_single() ) {
					if ( empty( $media ) ) {
						echo "<p>" . beautyagency_truncate_words( strip_tags( get_the_content() ), apply_filters( 'beautyagency_excerpt_length', false ) ) . "</p>";
					} else {
						echo "<p>" . beautyagency_truncate_words( strip_tags( beautyagency_remove_first_line_media( get_the_content() ) ), apply_filters( 'beautyagency_excerpt_length', false ) ) . "</p>";
					}
				} else {
					/* translators: %s: Name of current post */
					the_content( sprintf(
						esc_html__( 'START READING %s', 'beautyagency' ),
						the_title( '<span class="screen-reader-text">', '</span>', false )
					) );

					wp_link_pages( array(
						'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'beautyagency' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'beautyagency' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					) );
					?>
				<?php }
				if ( ! is_home() ) {
					beautyagency_post_tags();
				}
				?>
				<?php if ( is_user_logged_in() ) { ?>
				<footer class="entry-footer">
					<div class="clearboth">&nbsp;</div>
					<?php edit_post_link( esc_html__( 'Edit', 'beautyagency' ), '<span class="edit-link">', '</span>' ); ?>
				</footer>
				<?php } ?><!-- .entry-footer -->
			</div>

		</div><!-- .post__inner -->
	</div><!-- .entry-content -->
</article><!-- #post-## -->