<?php
/**
 * The default template for displaying status content inside loop
 *
 * Used for index/archive/search.
 */
$theme_options  = beautyagency_get_theme_mods();
$thumbnail_args = array(
	'background' => true,
);
// Blog view
$blog_view = '';
if ( beautyagency_is_blog_view_excerpt() && ! is_single() && is_home() ) {
	$blog_view = 'blog-view--excerpt';
} else {
	$blog_view = 'blog-view--content';
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $blog_view ); ?>>
	<div class="entry-content" style="<?php beautyagency_post_thumbnail( $thumbnail_args ); ?>">
		<span class="overlay"></span>
		<div class="post__inner">

			<div class="author-avatar">
				<?php
				/**
				 * Filter the author bio avatar size.
				 *
				 * @param int $size The avatar height and width size in pixels.
				 */
				$author_bio_avatar_size = apply_filters( 'beautyagency_author_bio_avatar_size', 122 );

				echo get_avatar( get_the_author_meta( 'user_email' ), $author_bio_avatar_size );
				?>
			</div><!-- .author-avatar -->

			<?php
			//beautyagency_post_time();
			beautyagency_post_meta();

			// Post Headers
			do_action( "beautyagency_after_thumbnail" );
			?>
			<div class="post-content">
				<?php
				echo beautyagency_excerpt_chat( get_the_content(), 140, false, false, false );
				?>
			</div>

		</div><!-- .post__inner -->
	</div><!-- .entry-content -->
</article><!-- #post-## -->