<?php
/**
 * The template used for displaying page content
 */
// Blog view
$blog_view = '';
if ( beautyagency_is_blog_view_excerpt() && ! is_single() && is_home() ) {
	$blog_view = 'blog-view--excerpt';
} else {
	$blog_view = 'blog-view--content';
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $blog_view ); ?>>
	<div class="entry-content">
		<?php
		the_title( '<h1 class="page-title">', '</h1>' );
		the_content();
		wp_link_pages( array(
			'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'beautyagency' ) . '</span>',
			'after'       => '</div>',
			'link_before' => '<span>',
			'link_after'  => '</span>',
			'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'beautyagency' ) . ' </span>%',
			'separator'   => '<span class="screen-reader-text">, </span>',
		) );
		?>
	</div><!-- .entry-content -->
	<?php if ( is_user_logged_in() ) { ?>
	<footer class="entry-footer">
		<div class="clearboth">&nbsp;</div>
		<?php edit_post_link( esc_html__( 'Edit', 'beautyagency' ), '<span class="edit-link">', '</span>' ); ?>
	</footer>
	<?php } ?><!-- .entry-footer -->
</article><!-- #post-## -->