<?php
/**
 * The default template for displaying link content inside loop
 *
 * Used for index/archive/search.
 */
$theme_options  = beautyagency_get_theme_mods();
$thumbnail_args = array(
	'background' => true,
);
// Blog view
$blog_view = '';
if ( beautyagency_is_blog_view_excerpt() && ! is_single() && is_home() ) {
	$blog_view = 'blog-view--excerpt';
} else {
	$blog_view = 'blog-view--content';
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $blog_view ); ?>>
	<div class="entry-content" style="<?php beautyagency_post_thumbnail( $thumbnail_args ); ?>">
		<div class="post__inner">

			<?php
			$categories_list = get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'beautyagency' ) );
			if ( $categories_list && beautyagency_categorized_blog() ) {
				printf( '<div class="cat-links"><span class="screen-reader-text">%1$s </span>%2$s</div>',
					esc_html_x( 'Categories', 'Used before category names.', 'beautyagency' ),
					$categories_list
				);
			}
			//beautyagency_post_time();
			beautyagency_post_meta();
			?>
			<h2 class="entry-title"><?php the_content(); ?></h2>
			<?php
			// Post Controls
			beautyagency_post_controls();
			?>
			<div class="post-content"></div>

		</div><!-- .post__inner -->
	</div><!-- .entry-content -->
</article><!-- #post-## -->