<?php
/**
 * The default template for displaying aside content inside loop
 *
 * Used for index/archive/search.
 */
$theme_options = beautyagency_get_theme_mods();
// Blog view
$blog_view = '';
if ( beautyagency_is_blog_view_excerpt() && ! is_single() && is_home() ) {
	$blog_view = 'blog-view--excerpt';
} else {
	$blog_view = 'blog-view--content';
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $blog_view ); ?>>
	<?php
	// Sticky Label
	$classes = get_post_class();
	if ( in_array( 'sticky', $classes ) && is_sticky() && ! is_single() ) {
		do_action( 'beautyagency_sticky_label' );
	}
	$thumbnail_args = array(
		'background' => true,
	);
	?>
	<div class="entry-content" style="<?php beautyagency_post_thumbnail( $thumbnail_args ); ?>">
		<div class="post__inner">
			<?php
			if ( is_single() ) {
				// Post Categories
				beautyagency_post_categories();
				// Post Meta
				beautyagency_post_meta();
			}
			// Post Headers
			do_action( "beautyagency_after_thumbnail" );
			// Post Controls
			beautyagency_post_controls();
			?>
			<div class="post-content">
				<?php the_content(); ?>
				<?php
				if ( ! is_home() ) {
					beautyagency_post_tags();
				}
				?>
				<div class="clearboth">&nbsp;</div>
			</div>

		</div><!-- .post__inner -->
	</div><!-- .entry-content -->
</article><!-- #post-## -->