<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 */
if ( is_front_page() || beautyagency_is_frontpage() ) {
	get_header();
} else {
	get_header( 'page' );
}
?>
<div id="primary" class="content-area">
	<main id="main" class="site-main">

		<div class="<?php if ( beautyagency_check_use_unyson() && ! beautyagency_is_page_show_sidebar() ) {
			echo 'container-fluid';
		} ?> post-container">
			<div class="row site__row">
				<div class="<?php echo beautyagency_sidebar_class( "content" ); ?>">

					<?php
					//  Add before loop position.
					if ( is_front_page() ) {
						do_action( 'beautyagency_before_loop' );
					}
					// Start the loop.
					while ( have_posts() ) : the_post();

						// Include the page content template.
						get_template_part( 'partials/content', 'page' );

						// If comments are open or we have at least one comment, load up the comment template.
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;

						// End the loop.
					endwhile;
					// Add after loop position.
					if ( is_front_page() ) {
						do_action( 'beautyagency_after_loop' );
					}
					?>

				</div>
				<?php if ( beautyagency_sidebar_visible() && beautyagency_is_page_show_sidebar() ) : ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>
			</div>
		</div>

	</main><!-- .site-main -->
</div><!-- .content-area -->

<?php get_footer(); ?>
