<?php
/**
 * The template for displaying models profiles
 */
remove_filter( 'the_content', 'ccm_the_content_filter', 25 );
get_header( 'page' );
?>
<div id="primary" class="content-area">
	<main id="main" class="site-main">

		<div class="post-container">
			<div class="row site__row">
				<div class="<?php echo beautyagency_sidebar_class( "content" ); ?>">

					<?php
					//  Add before loop position.
					if ( is_front_page() ) {
						do_action( 'beautyagency_before_loop' );
					}
					// Start the loop.
					while ( have_posts() ) : the_post();

						$blog_view = '';
						if ( beautyagency_is_blog_view_excerpt() && ! is_single() && is_home() ) {
							$blog_view = 'blog-view--excerpt';
						} else {
							$blog_view = 'blog-view--content';
						}

						?>

						<article id="post-<?php the_ID(); ?>" <?php post_class( $blog_view ); ?>>
							<div class="entry-content row">
								<?php
								echo '<div class="col-sm-12 col-md-5 pull-right model-profile-right-side">';
								// Post thumbnail.
								echo '<div class="post__media">';
								the_post_thumbnail('ccm-model-thumbnail-2' );
								echo '</div>';
								echo '<div class="model-profile-right-side-inner">';
								if ( in_the_loop() && ccm_is_single_profile() && ccm_is_profile() && ! post_password_required() ) {

									$before            = '';
									$after             = '';
									$address           = ccm_get_profile_meta( get_the_ID(), 'address' );
									$address_formatted = ccm_get_profile_address( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );
									$phone             = ccm_get_profile_meta( get_the_ID(), 'phone' );
									$phone_formatted   = ccm_get_profile_phone( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );
									$email             = ccm_get_profile_meta( get_the_ID(), 'email' );
									$email_formatted   = ccm_get_profile_phone( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );

									$height           = ccm_get_profile_meta( get_the_ID(), 'height' );
									$height_formatted = ccm_get_profile_height( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );
									$bust             = ccm_get_profile_meta( get_the_ID(), 'bust' );
									$bust_formatted   = ccm_get_profile_bust( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );
									$waist            = ccm_get_profile_meta( get_the_ID(), 'waist' );
									$waist_formatted  = ccm_get_profile_waist( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );
									$hips             = ccm_get_profile_meta( get_the_ID(), 'hips' );
									$hips_formatted   = ccm_get_profile_hips( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );
									$shoe             = ccm_get_profile_meta( get_the_ID(), 'shoe' );
									$shoe_formatted   = ccm_get_profile_shoe( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );
									$eyes             = ccm_get_profile_meta( get_the_ID(), 'eyes' );
									$eyes_formatted   = ccm_get_profile_eyes( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );

									$facebook             = ccm_get_profile_meta( get_the_ID(), 'facebook' );
									$facebook_formatted   = ccm_get_profile_facebook( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );
									$twitter              = ccm_get_profile_meta( get_the_ID(), 'twitter' );
									$twitter_formatted    = ccm_get_profile_twitter( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );
									$googleplus           = ccm_get_profile_meta( get_the_ID(), 'googleplus' );
									$googleplus_formatted = ccm_get_profile_googleplus( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );
									$linkedin             = ccm_get_profile_meta( get_the_ID(), 'linkedin' );
									$linkedin_formatted   = ccm_get_profile_linkedin( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );
									$pinterest            = ccm_get_profile_meta( get_the_ID(), 'pinterest' );
									$pinterest_formatted  = ccm_get_profile_pinterest( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );
									$instagram            = ccm_get_profile_meta( get_the_ID(), 'instagram' );
									$instagram_formatted  = ccm_get_profile_instagram( array(
										'text'   => '%s',
										'before' => $before,
										'after'  => $after
									) );
									$output               = '';

									// Social Profiles
									if ( ! empty( $facebook ) ) {
										$output .= '<div class="model-facebook">';
										$output .= '<span class="screen-reader-text">' . esc_html__( 'Facebook', 'beautyagency' ) . '</span>' . $facebook_formatted;
										$output .= '</div>';
									}

									if ( ! empty( $twitter ) ) {
										$output .= '<div class="model-twitter">';
										$output .= '<span class="screen-reader-text">' . esc_html__( 'Twitter', 'beautyagency' ) . '</span>' . $twitter_formatted;
										$output .= '</div>';
									}

									if ( ! empty( $googleplus ) ) {
										$output .= '<div class="model-googleplus">';
										$output .= '<span class="screen-reader-text">' . esc_html__( 'Google+', 'beautyagency' ) . '</span>' . $googleplus_formatted;
										$output .= '</div>';
									}

									if ( ! empty( $linkedin ) ) {
										$output .= '<div class="model-linkedin">';
										$output .= '<span class="screen-reader-text">' . esc_html__( 'LinkedIn', 'beautyagency' ) . '</span>' . $linkedin_formatted;
										$output .= '</div>';
									}

									if ( ! empty( $pinterest ) ) {
										$output .= '<div class="model-pinterest">';
										$output .= '<span class="screen-reader-text">' . esc_html__( 'Pinterest', 'beautyagency' ) . '</span>' . $pinterest_formatted;
										$output .= '</div>';
									}

									if ( ! empty( $instagram ) ) {
										$output .= '<div class="model-instagram">';
										$output .= '<span class="screen-reader-text">' . esc_html__( 'Instagram', 'beautyagency' ) . '</span>' . $instagram_formatted;
										$output .= '</div>';
									}
									echo '<div class="model-profile-social">';
									echo wp_kses($output, beautyagency_kses_init());
									echo '</div>';

									$output = '';

									// Model Parameters
									if ( ! empty( $height ) ) {
										$output .= '<div class="model-height">';
										$output .= '<span>' . esc_html__( 'Height', 'beautyagency' ) . '</span><br/>' . $height;
										$output .= '</div>';
									}

									if ( ! empty( $bust ) ) {
										$output .= '<div class="model-bust">';
										$output .= '<span>' . esc_html__( 'Bust', 'beautyagency' ) . '</span><br/>' . $bust;
										$output .= '</div>';
									}

									if ( ! empty( $waist ) ) {
										$output .= '<div class="model-waist">';
										$output .= '<span>' . esc_html__( 'Waist', 'beautyagency' ) . '</span><br/>' . $waist;
										$output .= '</div>';
									}

									if ( ! empty( $hips ) ) {
										$output .= '<div class="model-hips">';
										$output .= '<span>' . esc_html__( 'Hips', 'beautyagency' ) . '</span><br/>' . $hips;
										$output .= '</div>';
									}

									if ( ! empty( $shoe ) ) {
										$output .= '<div class="model-shoe">';
										$output .= '<span>' . esc_html__( 'Shoe', 'beautyagency' ) . '</span><br/>' . $shoe;
										$output .= '</div>';
									}

									if ( ! empty( $eyes ) ) {
										$output .= '<div class="model-eyes">';
										$output .= '<span>' . esc_html__( 'Eyes', 'beautyagency' ) . '</span><br/>' . $eyes;
										$output .= '</div>';
									}

									// Output Models Parameters
									if ( ! beautyagency_get_customizer_option('hide_models_parameters_globally') ) {
										echo '<div class="model-profile-parameters">';
										echo wp_kses($output, beautyagency_kses_init());
										echo '</div>';
									}

									$output = '';

									// Model Contact Information
									if ( ! empty( $address ) ) {
										$output .= '<div class="model-address">';
										$output .= '<span>' . esc_html__( 'Address: ', 'beautyagency' ) . '</span><br/>' . $address;
										$output .= '</div>';
									}

									if ( ! empty( $phone ) ) {
										$output .= '<div class="model-phone">';
										$output .= '<span>' . esc_html__( 'Phone: ', 'beautyagency' ) . '</span><br/>' . $phone;
										$output .= '</div>';
									}

									if ( ! empty( $email ) ) {
										$output .= '<div class="model-email">';
										$output .= '<span>' . esc_html__( 'Email: ', 'beautyagency' ) . '</span><br/>' . $email;
										$output .= '</div>';
									}
									echo '<div class="model-profile-contacts">';
									echo wp_kses($output, beautyagency_kses_init());
									echo '</div>';

									$output = '';
								}
								echo '</div></div>';
								echo '<div class="col-sm-12 col-md-7 pull-left model-profile-content">';
								// Model Name
								echo '<div class="page-title-block">';
								the_title( '<h1 class="page-title">', '</h1>' );
								echo '</div>';

								// About Model Content
								the_content();

								if ( in_the_loop() && ccm_is_single_profile() && ccm_is_profile() && ! post_password_required() ) {
									// Model Profile Gallery
									$images = ccm_get_multi_images_src();
									foreach ( $images as $image ) {
										$output .= '<div class="model-gallery-item">';
										$output .= '<a href="' . esc_url($image[1][0]) . '" data-gal="prettyPhoto[gallery]">';
										$output .= '<span class="overlay"></span>';
										$output .= '<img src="' . $image[0][0] . '" alt="">';
										$output .= '</a>';
										$output .= '</div>';
									}
									echo '<div class="model-profile-gallery">';
									echo wp_kses( $output, beautyagency_kses_init() );
									echo '</div>';

									$output = '';

									//Model Profile Contact Form
									echo '<h5>' . esc_html__( 'Contact Model', 'beautyagency' ) . '</h5>';
									$output .= ccm_get_profile_contact_form();
									echo '<div class="model-profile-contact-form">';
									echo wp_kses( $output, beautyagency_kses_init() );
									echo '</div>';
								}
								?>
								<?php
								wp_link_pages( array(
									'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'beautyagency' ) . '</span>',
									'after'       => '</div>',
									'link_before' => '<span>',
									'link_after'  => '</span>',
									'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'beautyagency' ) . ' </span>%',
									'separator'   => '<span class="screen-reader-text">, </span>',
								) );
								?>
								<?php if ( is_user_logged_in() ) { ?>
								<footer class="entry-footer">
									<div class="clearboth">&nbsp;</div>
									<?php edit_post_link( esc_html__( 'Edit', 'beautyagency' ), '<span class="edit-link">', '</span>' ); ?>
								</footer>
								<?php } ?><!-- .entry-footer -->
							</div><!-- .entry-content -->
						</article><!-- #post-## -->
						<?php
						// If comments are open or we have at least one comment, load up the comment template.
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;

						// End the loop.
					endwhile;
					// Add after loop position.
					if ( is_front_page() ) {
						do_action( 'beautyagency_after_loop' );
					}
					?>

				</div>
			</div>
		</div>

	</main><!-- .site-main -->
</div><!-- .content-area -->

<?php get_footer(); ?>
