<?php
/**
 * The template for displaying models category
 */
remove_filter( 'the_content', 'ccm_the_content_filter', 25 );
get_header( 'page' );
$order   = isset( $_GET['order'] ) ? $_GET['order'] : 'ASC';
$orderby = isset( $_GET['orderby'] ) ? $_GET['orderby'] : 'date';
$title   = get_the_title();

//Get Models Category Layout
$get_models_category_layout = ccm_get_models_layout();
?>

	<div id="primary" class="content-area <?php echo esc_attr($get_models_category_layout); ?>">
		<main id="main" class="site-main">
			<?php if ( have_posts() ) : ?>
			<div class="container-fluid post-container">
				<div class="row site__row">
					<div class="models-category-content">
							<div class="models-category-header">
								<?php
								// Model category Filters
								$categories = get_categories( array(
									'type'     => 'models_profile',
									'orderby'  => 'name',
									'taxonomy' => 'models_category'
								) );
								if ( ! empty( $categories ) ) {
									$output = '<div class="model-categories"><ul>';
									$output .= '<li><a href="' . esc_url( home_url( '/models/' ) ) . '">' . esc_html__( 'All', 'beautyagency' ) . '</a></li>';
									foreach ( $categories as $category ) {
										$output .= '<li><a href="' . esc_url( get_term_link( $category ) ) . '">' . esc_html( $category->name ) . '</a></li>';
									}

									$output .= '</ul></div>';
								}
								echo wp_kses( $output, beautyagency_kses_init() );
								$output = '';
								?>
								<div class="models-filter">
										<form method="get">
											<select name="order" onchange='this.form.submit()'>
												<option value="height" <?php if ( $orderby == 'height' ) {
													echo 'selected="selected"';
												} ?>>Height
												</option>
												<option value="bust" <?php if ( $orderby == 'bust' ) {
													echo 'selected="selected"';
												} ?>>Bust
												</option>
												<option value="waist" <?php if ( $orderby == 'waist' ) {
													echo 'selected="selected"';
												} ?>>Waist
												</option>
												<option value="hips" <?php if ( $orderby == 'hips' ) {
													echo 'selected="selected"';
												} ?>>Hips
												</option>
												<option value="shoe" <?php if ( $orderby == 'shoe' ) {
													echo 'selected="selected"';
												} ?>>Shoe
												</option>
												<option value="name" <?php if ( $orderby == 'name' ) {
													echo 'selected="selected"';
												} ?>>Name
												</option>
											</select>
										</form>
								</div>
							</div>
						<div class="models-category-content-inner">
							<?php
							// check post number
							$i = 0;
							if ( is_front_page() && is_home() ) {
								do_action( 'beautyagency_before_loop' );
							}

							$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : ( get_query_var( 'page' ) ? get_query_var( 'page' ) : 1 );
							global $wp_query;
							$atts = array();
							if ( $orderby == 'height' ) {
								$atts['orderby']  = 'meta_value_num';
								$atts['meta_key'] = 'height'; //height post meta
							} elseif ( $orderby == 'bust' ) {
								$atts['orderby']  = 'meta_value_num';
								$atts['meta_key'] = 'bust'; //bust post meta
							} elseif ( $orderby == 'waist' ) {
								$atts['orderby']  = 'meta_value_num';
								$atts['meta_key'] = 'waist'; //waist post meta
							} elseif ( $orderby == 'hips' ) {
								$atts['orderby']  = 'meta_value_num';
								$atts['meta_key'] = 'hips'; //hips post meta
							} elseif ( $orderby == 'shoe' ) {
								$atts['orderby']  = 'meta_value_num';
								$atts['meta_key'] = 'shoe'; //shoe post meta
							} elseif ( $orderby == 'name' ) {
								$atts['orderby'] = 'title'; //name
							} else {
								$atts['orderby'] = 'date';
							}
							$atts['posts_per_page'] = ccm_get_models_per_page();
							$atts                   = array_merge( $wp_query->query_vars, $atts );

							$wp_query = new WP_Query( $atts );
							// Start the Loop.
							while ( have_posts() ) : the_post();

								echo '<div class="post__wrap post__wrap--';
								if ( has_post_thumbnail() ) {
									echo ' with-media';
								} else {
									echo ' without-media';
								}
								echo '">';

								$thumbnail_args = array(
									'thumbnail_size'  => 'ccm-model-thumbnail-2',
									'thumbnail_class' => 'ccm-model-thumbnail-2',
									'background'      => true,
									'print'           => false
								);

								$height = ccm_get_profile_meta( get_the_ID(), 'height' );
								$bust   = ccm_get_profile_meta( get_the_ID(), 'bust' );
								$waist  = ccm_get_profile_meta( get_the_ID(), 'waist' );
								$hips   = ccm_get_profile_meta( get_the_ID(), 'hips' );
								$shoe   = ccm_get_profile_meta( get_the_ID(), 'shoe' );
								$eyes   = ccm_get_profile_meta( get_the_ID(), 'eyes' );


								// Post thumbnail.
								$output .= '<div class="post__media" style="' . beautyagency_post_thumbnail( $thumbnail_args ) . '"><div class="overlay"></div>';

								// Model Details
								if ( $get_models_category_layout == 'style_1' ) {
									$output .= '<div class="model-details-block">';
									$output .= '<h3 class="page-title">' . get_the_title() . '</h3>';

									// Model Parameters
									$output .= '<div class="model-parameters-block">';
									if ( ! empty( $height ) ) {
										$output .= '<div class="model-height">';
										$output .= '<span>' . esc_html__( 'Height', 'beautyagency' ) . '</span><br/>' . $height;
										$output .= '</div>';
									}

									if ( ! empty( $bust ) ) {
										$output .= '<div class="model-bust">';
										$output .= '<span>' . esc_html__( 'Bust', 'beautyagency' ) . '</span><br/>' . $bust;
										$output .= '</div>';
									}

									if ( ! empty( $waist ) ) {
										$output .= '<div class="model-waist">';
										$output .= '<span>' . esc_html__( 'Waist', 'beautyagency' ) . '</span><br/>' . $waist;
										$output .= '</div>';
									}

									if ( ! empty( $hips ) ) {
										$output .= '<div class="model-hips">';
										$output .= '<span>' . esc_html__( 'Hips', 'beautyagency' ) . '</span><br/>' . $hips;
										$output .= '</div>';
									}

									if ( ! empty( $shoe ) ) {
										$output .= '<div class="model-shoe">';
										$output .= '<span>' . esc_html__( 'Shoe', 'beautyagency' ) . '</span><br/>' . $shoe;
										$output .= '</div>';
									}
									$output .= '</div>';
									$output .= '</div>';
								}
								if ( $get_models_category_layout == 'style_2' ) {
									$output .= '<div class="controls_block">';
									$output .= '<a href="' . esc_url( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ) ) . '" data-gal="prettyPhoto[gallery]"><span class="show-gallery"></span></a>';
									$output .= '<a href="' . get_the_permalink() . '"><span class="show-profile"></span></a>';
									$output .= '</div>';
								}

								$output .= '</div>';

								if ( $get_models_category_layout == 'style_2' ) {
									$output .= '<h3 class="page-title">' . get_the_title() . '</h3>';
								}
								echo '<a href="' . esc_url( get_permalink( get_the_ID() ) ) . '">' . $output . '</a>';

								$output = '';

								$i ++;
								echo '</div>';

								// End the loop.
							endwhile;

							// Previous/next page navigation.
							the_posts_pagination( array(
								'prev_text'          => '<i class="fa fa-angle-left" aria-hidden="true"></i>',
								'next_text'          => '<i class="fa fa-angle-right" aria-hidden="true"></i>',
								'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'beautyagency' ) . ' </span>',
							) );

							// If no content, include the "No posts found" template.
							else :
								get_template_part( 'partials/content', 'none' );

							endif;
							?>
						</div>
					</div>
				</div>
			</div>
		</main><!-- .site-main -->
	</div><!-- .content-area -->

<?php get_footer(); ?>