(function($){
    "use strict";

    var $allVideos = jQuery(".post__media_wide .container iframe, .post__media iframe, .post__media object, .post__media embed");
    // [src^='//player.vimeo.com'], iframe[src^='//www.youtube.com']

    function beautyagency_get_all_videos() {
        $allVideos.each(function () {
            jQuery(this).attr('data-aspectratio', this.height / this.width).removeAttr('height').removeAttr('width');
        });
    }

    function beautyagency_resize_all_videos() {
        $allVideos.each(function () {
            var $el = jQuery(this);
            var newWidth = jQuery(this).parent().width();
            $el.width(newWidth).height((newWidth * $el.attr('data-aspectratio')).toFixed());
        });
    }

    jQuery(document).ready(function($) {

        $('#loader').fadeOut(); // will first fade out the loading animation
        $('#preloader').delay(350).fadeOut('slow'); // will fade out the white DIV that covers the website.
        $('body').delay(350).css({
            'overflow': 'visible'
        });

        document.documentElement.className='js';

        //Set Main slider script
        var sliders = jQuery('[class*=main-slider]');
        sliders.bxSlider({
            useCSS: false,
            nextText: 'next',
            prevText: 'prev',
            pager: false,
            auto: true, // d: false
            mode: 'fade',
            wrapperClass: 'bx-wrapper-main'
        });

        //hidding menu elements that do not fit in menu width
        window.menuHideExtraElements = function() {
            var wrapperWidth = jQuery('#main-nav').width();
            var summaryWidth = 0;
            var $liElements = jQuery('#main-nav > li');
            $liElements.each(function(index) {
                summaryWidth += jQuery(this).outerWidth(true);
                if(summaryWidth > wrapperWidth) {
                    $liElements.removeClass('md-hidden');
                    var $newLi = jQuery('<li id="more-li"><a><i class="fa fa-bars"></i></a><ul class="sub-menu"></ul></li>');
                    jQuery($liElements[index-1]).before($newLi);
                    var $extraLiElements = $liElements.filter(':gt('+(index-2)+')');
                    $extraLiElements.clone().appendTo($newLi.find('ul'));
                    $extraLiElements.addClass('md-hidden');
                    return false;
                }
            });
        }
        menuHideExtraElements();
        jQuery(window).on('resize', function() {
            jQuery('#more-li').remove();
            menuHideExtraElements();
        });


        // Fit video frames to document width
        beautyagency_get_all_videos();
        beautyagency_resize_all_videos();


        // PrettyPhoto
        $("a[data-gal^='prettyPhoto']").prettyPhoto({
            theme: 'dark_square',
            animation_speed:'normal',
            slideshow:3000,
            autoplay_slideshow: false,
            social_tools: false,
            hook: 'data-gal'
        });

        // Navigation in responsive layouts
        var $menu = $('.main-nav > ul'),
            optionsList = '<option value="" selected> = Main Navigation = </option>';

        if( $menu.length ) {
            $menu.find('li').each(function () {
                var $this = $(this),
                    $anchor = $this.children('a'),
                    depth = $this.parents('ul').length - 1,
                    indent = '';

                if (depth) {
                    while (depth > 0) {
                        indent += ' ::: ';
                        depth--;
                    }
                }

                optionsList += '<option value="' + $anchor.attr('href') + '">' + indent + ' ' + $anchor.text() + '</option>';
            }).end().parent().parent().parent().parent().parent().find('.nav-button').append('<select class="mobile-menu">' + optionsList + '</select><div class="mobile-menu-title"><i class="fa fa-bars" aria-hidden="true"></i></div>');
        } else {
            $('.nav-button').append("Please create menu");
        }

        $('.mobile-menu').on('change', function () {
            window.location = $(this).val();
        });

        // Sticky Top Menu
        if(jQuery(document).width() > 768) {
            if ($().sticky) {
                $('.header-sticky').sticky();
            }
            // correct for smooth scroll
            jQuery('.header-wrapper.header_style1 .sticky-wrapper').append('<div class="header-divider-deputy"></div>');
        }


        // Menu search
        $('.header-button__search').on('click', function () {
            $('body').toggleClass('search-box--opened');
            $('.search-box__icon').toggleClass('active');
            $('#search-box__input').toggleClass('fadein');
        });
        $(document).mouseup(function (e) {
            var container = $('.top-bar-right');
            if (!container.is(e.target) // if the target of the click isn't the container...
                && container.has(e.target).length === 0) // ... nor a descendant of the container
            {
                //container.hide();
                $('body').removeClass('search-box--opened');
                $('.search-box__icon').removeClass('active');
                $('#search-box__input').removeClass('fadein');
            }
        });

        // Scroll totop button
        var toTop = $('#to-top');
        $(window).scroll(function () {
            if ($(this).scrollTop() > 1) {
                toTop.css({bottom: '11px'});
            } else {
                toTop.css({bottom: '-100px'});
            }
        });
        toTop.click(function () {
            $('html, body').animate({scrollTop: '0px'}, 800);
            return false;
        });

        // Post controls
        $('.pctrl-social-btn').click(function () {
            $(this).closest('.post-controls').toggleClass('active');
        });

        // Bootstrap select
        if( /Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent) ) {
            $('.widget select').selectpicker('mobile');
        }
        else {
            $('.widget select').selectpicker({
                container: 'body',
                width: '100%',
                size: 8
            });
        }

        // Post format video thumbnail hide on click
        $('.post__thumbnail').on('click', function(){
            $(this).hide();
        });

        // Login Popup
        login_popup();

    });

    //Set preloader script
    $(window).load(function() { // makes sure the whole site is loaded

    });

    jQuery(window).load(function () {

        // Sticky Sidebar
        var stickyParentRow = $(".post-container > .row > .col-sm-8"),
            stickySidebar = $(".sidebar-sticky");

        function detachSidebar() {
            if( 992 > $(window).width() ) {
                stickySidebar.trigger("sticky_kit:detach");
            }
        }

        if( stickyParentRow.length ) {
            stickySidebar.stick_in_parent({
                offset_top: 0,
                parent: ".content-area",
                spacer: false
            }).on("sticky_kit:bottom", function () {
                $(this).parent().css("position", "static")
            }).on("sticky_kit:unbottom", function () {
                $(this).parent().css("position", "relative")
            });
            detachSidebar();
        }

        //Placeholder cleaning
        var $ph = $('input[type="search"], input[type="text"], input[type="url"], input[type="number"], input[type="email"], textarea');
        $ph.each(function() {
            var value = $(this).val();
            $(this).focus(function() {
                if ($(this).val() === value) {
                    $(this).val('');
                }
            });
            $(this).blur(function() {
                if ($(this).val() === '') {
                    $(this).val(value);
                }
            });
        });

        var rtl = false;

        if (jQuery('body').hasClass('rtl')) {
            rtl = true;
        }

        $('.owl-gallery').owlCarousel({
            rtl:rtl,
            margin:0,
            items:1,
            loop:true,
            nav:true,
            autoHeight : true,
            navText: [
                "<i class='rt-icon icon-chevron-thin-left'></i>",
                "<i class='rt-icon icon-chevron-thin-right'></i>"
            ],
            responsiveClass:true,
            responsiveBaseElement:".footer",
            responsive:{
                0:{
                    dots:false
                },
                955:{
                    dots:true
                }
            }
        });
    });

    jQuery(window).resize(function () {

        // Fit video frames to document width
        beautyagency_resize_all_videos();

    });
    $(window).on('load resize', function() {

        // Fit image size to container size.
        $('.image-fit').each( function () {
            var refH = $(this).height();
            var refW = $(this).width();
            var refRatio = refW/refH;

            var imgH = $(this).children("img").height();
            var imgW = $(this).children("img").width();

            if ( (imgW/imgH) > refRatio ) {
                $(this).addClass("portrait");
                $(this).removeClass("landscape");
            } else {
                $(this).addClass("landscape");
                $(this).removeClass("portrait");
            }
        });
    });

    // hide placeholders on focus
    $(function () {
        $('input,textarea').focus(function () {
            $(this).data('placeholder', $(this).attr('placeholder'))
                .attr('placeholder', '');
        }).blur(function () {
            $(this).attr('placeholder', $(this).data('placeholder'));
        });
    });

})(jQuery);

function login_popup() {
    // Login popup
    if (jQuery('.login-popup__toggle').length) {
        jQuery('.login-popup__toggle').on('click', function(){
            var loginPopup = jQuery(this).siblings('.login-popup__popup');
            loginPopup.toggleClass('login-popup__popup--opened');
            loginPopup.find('#user_login').attr('placeholder', 'Username');
            loginPopup.find('#user_pass').attr('placeholder', 'Password');
        });
        jQuery('.login-popup__popup #rememberme').after('<span>').after('<span>');
    }
}

