/**
 * Live-update changed settings in real time in the Customizer preview.
 */

( function( $ ) {
	var $style = $( '#beautyagency-color-scheme-css' ),
		api = wp.customize;

	if ( ! $style.length ) {
		$style = $( 'head' ).append( '<style type="text/css" id="beautyagency-color-scheme-css" />' )
		                    .find( '#beautyagency-color-scheme-css' );
	}

	// Site title.
	api( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.blogname a' ).text( to );
		} );
	} );

	// Site tagline.
	api( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.blogdescr a' ).text( to );
		} );
	} );

	// Color Scheme CSS.
	api.bind( 'preview-ready', function() {
		api.preview.bind( 'update-color-scheme-css', function( css ) {
			$style.html( css );
		} );
	} );

    // Hide/Show Social Icons.
    api( 'hide_social_icons', function( value ) {
        value.bind( function( to ) {
            if( to ){
                $( '.footer-social' ).hide();
            } else {
                $( '.footer-social' ).show();
            }
        } );
    } );

    // Hide/Show Menu Search.
    api( 'hide_menu_search', function( value ) {
        value.bind( function( to ) {
            if( to ){
                $( '.search-box' ).hide();
            } else {
                $( '.search-box' ).show();
            }

        } );
    } );

    // Contact Title.
    api( 'contact_block_title', function( value ) {
        value.bind( function( to ) {
            $( '.contact-title' ).text( to );
        } );
    } );

    // Contact Tagline.
    api( 'contact_block_tagline', function( value ) {
        value.bind( function( to ) {
            $( '.contact-tagline' ).text( to );
        } );
    } );

    // Contact Address.
    api( 'contact_block_address', function( value ) {
        value.bind( function( to ) {
            $( '.contact-address' ).text( to );
        } );
    } );

    // Contact Phone.
    api( 'contact_block_phone', function( value ) {
        value.bind( function( to ) {
            $( '.contact-phone' ).text( to );
        } );
    } );

    // Contact Email.
    api( 'contact_block_email', function( value ) {
        value.bind( function( to ) {
            $( '.contact-email' ).text( to );
        } );
    } );

    // Hide/Show Contact Block.
    api( 'hide_contact_block', function( value ) {
        value.bind( function( to ) {
            if( to ){
                $( '.contacts-block' ).hide();
            } else {
                $( '.contacts-block' ).show();
            }

        } );
    } );

    // Footer text.
    api( 'footer_text', function( value ) {
        value.bind( function( to ) {
            $( '.footer_text' ).html( to );
        } );
    } );

    // Hide/Show Footer text.
    api( 'hide_footer_text', function( value ) {
        value.bind( function( to ) {
            if( to ){
                $( '.footer_text' ).hide();
            } else {
                $( '.footer_text' ).show();
            }

        } );
    } );

    // Copyright.
    api( 'copyright', function( value ) {
        value.bind( function( to ) {
            $( '.copyright' ).html( to );
        } );
    } );

    // Alternative Copyright.
    api( 'copyright-2', function( value ) {
        value.bind( function( to ) {
            $( '.copyright-2' ).html( to );
        } );
    } );

    // Hide/Show Copyright.
    api( 'hide_copyright', function( value ) {
        value.bind( function( to ) {
            if( to ){
                $( '.copyright' ).hide();
            } else {
                $( '.copyright' ).show();
            }

        } );
        value.bind( function( to ) {
            if( to ){
                $( '.copyright-2' ).hide();
            } else {
                $( '.copyright-2' ).show();
            }

        } );
    } );

    // Social share icons

    // Hide/Show Facebook
    api( 'facebook', function( value ) {
        value.bind( function( to ) {
            if( to ){
                $( '.share-facebook' ).show();
            } else {
                $( '.share-facebook' ).hide();
            }
        } );
    } );

    // Hide/Show Twitter
    api( 'twitter', function( value ) {
        value.bind( function( to ) {
            if( to ){
                $( '.share-twitter' ).show();
            } else {
                $( '.share-twitter' ).hide();
            }
        } );
    } );

    // Hide/Show Linkedin
    api( 'linkedin', function( value ) {
        value.bind( function( to ) {
            if( to ){
                $( '.share-linkedin' ).show();
            } else {
                $( '.share-linkedin' ).hide();
            }
        } );
    } );

    // Hide/Show Google Plus
    api( 'google-plus', function( value ) {
        value.bind( function( to ) {
            if( to ){
                $( '.share-google-plus' ).show();
            } else {
                $( '.share-google-plus' ).hide();
            }
        } );
    } );



    // 404 Page Title.
    api( 'page_title_404', function( value ) {
        value.bind( function( to ) {
            value.bind( function( to ) {
                $( '.page_title_404' ).text( to );
            } );

        } );
    } );

    // 404 Page Message.
    api( 'page_message_404', function( value ) {
        value.bind( function( to ) {
            value.bind( function( to ) {
                $( '.page_message_404' ).text( to );
            } );

        } );
    } );

    // Hide/Show Home Link.
    api( 'hide_homepage_link', function( value ) {
        value.bind( function( to ) {
            if( to ){
                $( '.homepage_link' ).hide();
            } else {
                $( '.homepage_link' ).show();
            }

        } );
    } );

} )( jQuery );
