<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * e.g., it puts together the home page when no home.php file exists.
 *
 * Learn more: {@link https://codex.wordpress.org/Template_Hierarchy}
 */
$theme_options = beautyagency_get_theme_mods();
if ( is_front_page() || beautyagency_is_frontpage() ) {
	get_header();
} else {
	get_header( 'page' );
}
?>

<div id="primary" class="content-area">
	<main id="main" class="site-main">

		<?php if ( have_posts() ) : ?>

		<?php if ( is_home() && ! is_front_page() ) : ?>
			<header>
				<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
			</header>
		<?php endif; ?>

		<?php do_action( 'beautyagency_content_header', $theme_options ); ?>

		<div class="post-container <?php echo beautyagency_sidebar_class( "container" ); ?>">
			<div class="row site__row">

				<div class="<?php echo beautyagency_sidebar_class( "content" ); ?>">
					<?php

					// check post number
					$i = 0;
					if ( is_front_page() ) {
						do_action( 'beautyagency_before_loop' );
					}

					// Start the loop.
					while ( have_posts() ) : the_post();

						$post_size = ( $i % 3 ) == 0 ? "small" : "small";
						echo '<div class="post__wrap post__wrap--';
						echo esc_attr( $post_size );
						if ( has_post_thumbnail() ) {
							echo ' with-media';
						} else {
							echo ' without-media';
						}
						echo '">';

						/*
						 * Include the Post-Format-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
						 */
						get_template_part( 'partials/content', get_post_format() );

						$i ++;
						echo '</div>';

						// End the loop.
					endwhile;

					// Previous/next page navigation.
					the_posts_pagination( array(
						'prev_text'          => esc_html__( 'PREV', 'beautyagency' ),
						'next_text'          => esc_html__( 'NEXT', 'beautyagency' ),
						'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'beautyagency' ) . ' </span>',
					) );

					// If no content, include the "No posts found" template.
					else :
						get_template_part( 'partials/content', 'none' );

					endif;

					if ( is_front_page()  ) {
						do_action( 'beautyagency_after_loop' );
					}
					?>
				</div>
				<?php if ( beautyagency_sidebar_visible() ) : ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>
			</div>
		</div>

	</main><!-- .site-main -->

</div><!-- .content-area -->

<?php get_footer(); ?>
