<?php

/**
 * Recent_Posts_Carousel widget class.0
 */
class BEAUTYAGENCY_Widget_Recent_Posts_Carousel extends WP_Widget {

	public function __construct() {
		$widget_ops = array(
			'classname'   => 'widget_recent_entries_carousel',
			'description' => esc_html__( "Your site&#8217;s most recent Posts organized in Slider.", 'beautyagency' )
		);
		parent::__construct( 'recent-posts-carousel', esc_html__( 'Recent Posts Carousel', 'beautyagency' ), $widget_ops );
		$this->alt_option_name = 'widget_recent_entries_carousel';
	}

	public function widget( $args, $instance ) {
		$unique_id = uniqid();

		ob_start();

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';

		/** This filter is documented in wp-includes/default-widgets.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
		if ( ! $number ) {
			$number = 5;
		}
		$category        = isset( $instance['category'] ) ? $instance['category'] : '';
		$show_excerpt    = isset( $instance['show_excerpt'] ) ? $instance['show_excerpt'] : false;
		$show_share      = isset( $instance['show_share'] ) ? $instance['show_share'] : false;
		$show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : false;
		$show_author = isset( $instance['show_author'] ) ? $instance['show_author'] : false;
		$show_category   = isset( $instance['show_category'] ) ? $instance['show_category'] : false;
		$show_navigation = isset( $instance['show_navigation'] ) ? $instance['show_navigation'] : false;
		$autoplay        = isset( $instance['autoplay'] ) ? $instance['autoplay'] : false;

		$style = isset( $instance['style'] ) ? absint( $instance['style'] ) : 1;
		if ( $style == 1 ) {
			$style = 1;
		} else {
			$style = 2;
		}


		$thumbnail_args = array(
			'thumbnail_size'  => 'beautyagency-post-carousel',
			'thumbnail_class' => 'beautyagency-post-carousel',
			'use_default'     => true,
			'is_widget'       => true,
			'no_url'          => true,
		);

		/**
		 * Filter the arguments for the Recent Posts widget.
		 *
		 * @since 3.4.0
		 *
		 * @see WP_Query::get_posts()
		 *
		 * @param array $args An array of arguments used to retrieve the recent posts.
		 */
		$r = new WP_Query( apply_filters( 'widget_posts_args', array(
			'posts_per_page'      => $number,
			'no_found_rows'       => true,
			'post_status'         => 'publish',
			'category_name'       => $category,
			'ignore_sticky_posts' => true
		) ) );

		if ( $r->have_posts() ) :
			?>
			<?php echo wp_kses_post( $args['before_widget'] ); ?>
			<?php if ( $title ) {
			echo wp_kses_post( $args['before_title'] . $title . $args['after_title'] );
		} ?>
			<div
				class="owl-recent-post-carousel owl-recent-post-carousel<?php echo esc_attr( $unique_id ) ?> <?php echo 'style-' . esc_attr( $style ); ?> owl-carousel rp-carousel"
				data-show_navigation="<?php echo esc_attr( $show_navigation ) ? 'true' : 'false' ?>"
				data-autoplay="<?php echo esc_attr( $autoplay ) ? 'true' : 'false' ?>"
				data-uniqid="<?php echo esc_attr( $unique_id ); ?>">
				<?php while ( $r->have_posts() ) : $r->the_post(); ?>
					<?php $post_format_icon = get_post_format(); ?>
					<div class="item <?php echo esc_attr($post_format_icon); ?>">
						<div class="rp-carousel__image">
							<div
								class="overlay"></div><?php beautyagency_post_thumbnail( $thumbnail_args ) ?>
						</div>
						<div class="rp-carousel__content">
							<h2 class="rp-carousel__title"><a
									href="<?php  the_permalink(); ?>"><?php get_the_title() ? the_title() : the_ID(); ?></a>
							</h2>
							<?php /* Post Category */
							if ( $show_category ) : ?>
								<div
									class="rp-carousel__category"><?php echo beautyagency_get_first_category( get_the_ID() ); ?></div>
							<?php endif; ?>
							<?php if ( $show_excerpt ) : ?>
								<div
									class="rp-carousel__excerpt"><?php echo substr( get_the_excerpt(), 0, 120 ); ?></div>
							<?php endif; ?>
							<?php /* Post Date */
							if ( $show_author) : ?>
								<span class="rp-carousel__author"><?php echo get_the_author(); ?></span>
							<?php endif; ?>
							<?php if ( $show_author && $show_date ) { echo '|'; } ?>
							<?php /* Post Date */
							if ( $show_date ) : ?>
								<span class="rp-carousel__date"><?php echo get_the_date('d F Y'); ?></span>
							<?php endif; ?>
							<?php /* Post Share Buttons */
							if ( $show_share ) : ?>
								<ul class="share-icons">
									<!-- twitter -->
									<li>
										<a href="https://twitter.com/share?text=<?php echo urlencode( get_the_title() ); ?>&amp;url=<?php echo esc_url( get_permalink() ); ?>"
										   onclick="window.open(this.href, 'twitter-share', 'width=550,height=235');return false;"><i
												class="fa fa-twitter"></i></a>
									</li>
									<!-- facebook -->
									<li>
										<a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url( get_permalink() ); ?>"
										   onclick="window.open(this.href, 'facebook-share','width=580,height=296');return false;"><i
												class="fa fa-facebook"></i></a>
									</li>
									<!-- google plus -->
									<li>
										<a href="https://plus.google.com/share?url=<?php echo esc_url( get_permalink() ); ?>"
										   onclick="window.open(this.href, 'google-plus-share', 'width=490,height=530');return false;"><i
												class="fa fa-google-plus"></i></a>
									</li>
									<!-- pinterest -->
									<li>
										<a href="javascript:void((function()%7Bvar%20e=document.createElement('script');e.setAttribute('type','text/javascript');e.setAttribute('charset','UTF-8');e.setAttribute('src','http://assets.pinterest.com/js/pinmarklet.js?r='+Math.random()*99999999);document.body.appendChild(e)%7D)());"><i
												class="fa fa-pinterest"></i></a>
									</li>
									<!-- linkedin -->
									<li>
										<a href="https://www.linkedin.com/shareArticle?mini=true%26url=<?php echo esc_url( get_permalink() ); ?>%26source="
										   onclick="window.open(this.href, 'linkedin-share', 'width=490,height=530');return false;"><i
												class="fa fa-linkedin"></i></a>
									</li>
								</ul>
							<?php endif; ?>
						</div>
					</div><!-- .item -->
				<?php endwhile; ?>
			</div>
			<?php echo wp_kses_post( $args['after_widget'] ); ?>
			<?php
			// Reset the global $the_post as this query will have stomped on it
			wp_reset_postdata();

		endif;
		ob_end_flush();
	}

	public function update( $new_instance, $old_instance ) {
		$instance                    = $old_instance;
		$instance['title']           = strip_tags( $new_instance['title'] );
		$instance['number']          = (int) $new_instance['number'];
		$instance['category']        = $new_instance['category'];
		$instance['show_date'] = isset( $new_instance['show_date'] ) ? (bool) $new_instance['show_date'] : false;
		$instance['show_author'] = isset( $new_instance['show_author'] ) ? (bool) $new_instance['show_author'] : false;
		$instance['style']           = (int) $new_instance['style'];
		$instance['show_excerpt']    = isset( $new_instance['show_excerpt'] ) ? (bool) $new_instance['show_excerpt'] : false;
		$instance['show_share']      = isset( $new_instance['show_share'] ) ? (bool) $new_instance['show_share'] : false;
		$instance['show_category']   = isset( $new_instance['show_category'] ) ? (bool) $new_instance['show_category'] : false;
		$instance['show_navigation'] = isset( $new_instance['show_navigation'] ) ? (bool) $new_instance['show_navigation'] : false;
		$instance['autoplay']        = isset( $new_instance['autoplay'] ) ? (bool) $new_instance['autoplay'] : false;

		if ( isset( $alloptions['widget_recent_entries_carousel'] ) ) {
			delete_option( 'widget_recent_entries_carousel' );
		}

		return $instance;
	}

	public function form( $instance ) {
		$title           = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$number          = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
		$category        = isset( $instance['category'] ) ? $instance['category'] : '';
		$show_excerpt    = isset( $instance['show_excerpt'] ) ? (bool) $instance['show_excerpt'] : false;
		$show_share      = isset( $instance['show_share'] ) ? (bool) $instance['show_share'] : false;
		$show_category   = isset( $instance['show_category'] ) ? (bool) $instance['show_category'] : false;
		$style           = isset( $instance['style'] ) ? absint( $instance['style'] ) : 1;
		$show_date = isset( $instance['show_date'] ) ? (bool) $instance['show_date'] : false;
		$show_author   = isset( $instance['show_author'] ) ? (bool) $instance['show_author'] : false;
		$show_navigation = isset( $instance['show_navigation'] ) ? (bool) $instance['show_navigation'] : false;
		$autoplay        = isset( $instance['autoplay'] ) ? (bool) $instance['autoplay'] : false;

		?>
		<p><label
				for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php echo wp_kses( __( 'Title<br><i>carousel title</i>', 'beautyagency' ), beautyagency_kses_init(), $allowed_html_array = array(
					'br' => array(),
					'i'  => array()
				) ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
			       name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text"
			       value="<?php echo esc_attr( $title ); ?>"/></p>

		<p><label
				for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php echo wp_kses( __( 'Number of posts<br><i>to show</i>', 'beautyagency' ), beautyagency_kses_init(), $allowed_html_array = array(
					'br' => array(),
					'i'  => array()
				) ); ?></label>
			<input id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"
			       name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="number"
			       value="<?php echo absint( $number ); ?>" size="3"/></p>
		<p>
			<label
				for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>"><?php echo wp_kses( __( 'Category<br><i>posts category</i>', 'beautyagency' ), beautyagency_kses_init(), $allowed_html_array = array(
					'br' => array(),
					'i'  => array()
				) ); ?></label>
			<?php wp_dropdown_categories( array(
				'show_option_all' => esc_html__( 'All Categories', 'beautyagency' ),
				'hide_empty'      => 0,
				'selected'        => $category,
				'name'            => $this->get_field_name( 'category' ),
				'id'              => $this->get_field_id( 'category' ),
				'value_field'     => 'slug'
			) ); ?>
		</p>
		<p>
			<strong><?php esc_html_e( 'Layout:', 'beautyagency' ); ?></strong><br/>
			<label for="<?php echo esc_attr( $this->get_field_id( 'center' ) ); ?>"
			       class="rp-carousel-radio-label">
				<input class="rp-carousel-radio" type="radio" <?php checked( $style == 1 ); ?>
				       id="<?php echo esc_attr( $this->get_field_id( 'center' ) ); ?>"
				       name="<?php echo esc_attr( $this->get_field_name( 'style' ) ); ?>" value="1"/>
				<img
					src="<?php echo esc_url(get_template_directory_uri()) . '/inc/widgets/widget-recent-posts-carousel/img/widget-recent-posts-carousel-1.gif'; ?>"
					alt="<?php echo esc_html__( 'Center', 'beautyagency' ); ?>">
			</label>
			<label for="<?php echo esc_attr( $this->get_field_id( 'left' ) ); ?>"
			       class="rp-carousel-radio-label">
				<input class="rp-carousel-radio" type="radio" <?php checked( $style == 2 ); ?>
				       id="<?php echo esc_attr( $this->get_field_id( 'left' ) ); ?>"
				       name="<?php echo esc_attr( $this->get_field_name( 'style' ) ); ?>" value="2"/>
				<img
					src="<?php echo esc_url(get_template_directory_uri()) . '/inc/widgets/widget-recent-posts-carousel/img/widget-recent-posts-carousel-2.gif'; ?>"
					alt="<?php echo esc_html__( 'Left', 'beautyagency' ); ?>">
			</label>
		</p>
		<p><input class="checkbox" type="checkbox" <?php checked($show_author); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_author' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_author' ) ); ?>" />
			<label for="<?php echo esc_attr( $this->get_field_id( 'show_author' ) ); ?>"><?php esc_html_e( 'Display post author?', 'beautyagency' ); ?></label></p>

		<p><input class="checkbox" type="checkbox" <?php checked( $show_date ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_date' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_date' ) ); ?>" />
			<label for="<?php echo esc_attr( $this->get_field_id( 'show_date' ) ); ?>"><?php esc_html_e( 'Display post date?', 'beautyagency' ); ?></label></p>

		<p><input class="checkbox" type="checkbox" <?php checked( $show_excerpt ); ?>
		          id="<?php echo esc_attr( $this->get_field_id( 'show_excerpt' ) ); ?>"
		          name="<?php echo esc_attr( $this->get_field_name( 'show_excerpt' ) ); ?>"/>
			<label
				for="<?php echo esc_attr( $this->get_field_id( 'show_excerpt' ) ); ?>"><?php esc_html_e( 'Display post excerpt?', 'beautyagency' ); ?></label>
		</p>
		<p><input class="checkbox" type="checkbox" <?php checked( $show_share ); ?>
		          id="<?php echo esc_attr( $this->get_field_id( 'show_share' ) ); ?>"
		          name="<?php echo esc_attr( $this->get_field_name( 'show_share' ) ); ?>"/>
			<label
				for="<?php echo esc_attr( $this->get_field_id( 'show_share' ) ); ?>"><?php esc_html_e( 'Display post share?', 'beautyagency' ); ?></label>
		</p>

		<p><input class="checkbox" type="checkbox" <?php checked( $show_category ); ?>
		          id="<?php echo esc_attr( $this->get_field_id( 'show_category' ) ); ?>"
		          name="<?php echo esc_attr( $this->get_field_name( 'show_category' ) ); ?>"/>
			<label
				for="<?php echo esc_attr( $this->get_field_id( 'show_category' ) ); ?>"><?php esc_html_e( 'Display post category?', 'beautyagency' ); ?></label>
		</p>

		<p><input class="checkbox" type="checkbox" <?php checked( $show_navigation ); ?>
		          id="<?php echo esc_attr( $this->get_field_id( 'show_navigation' ) ); ?>"
		          name="<?php echo esc_attr( $this->get_field_name( 'show_navigation' ) ); ?>"/>
			<label
				for="<?php echo esc_attr( $this->get_field_id( 'show_navigation' ) ); ?>"><?php esc_html_e( 'Show navigation?', 'beautyagency' ); ?></label>
		</p>

		<p><input class="checkbox" type="checkbox" <?php checked( $autoplay ); ?>
		          id="<?php echo esc_attr( $this->get_field_id( 'autoplay' ) ); ?>"
		          name="<?php echo esc_attr( $this->get_field_name( 'autoplay' ) ); ?>"/>
			<label
				for="<?php echo esc_attr( $this->get_field_id( 'autoplay' ) ); ?>"><?php esc_html_e( 'Auto play', 'beautyagency' ); ?></label>
		</p>

		<?php
	}
}

if ( ! function_exists( 'beautyagency_recent_posts_carousel_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function beautyagency_recent_posts_carousel_setup() {
		add_image_size( 'beautyagency-post-carousel', 350, 250, true );
	}
endif; // beautyagency_top_news_setup
add_action( 'after_setup_theme', 'beautyagency_recent_posts_carousel_setup', 20 );

if ( ! function_exists( 'beautyagency_register_widget_recent_posts_carousel' ) ) :
	function beautyagency_register_widget_recent_posts_carousel() {
		register_widget( 'BEAUTYAGENCY_Widget_Recent_Posts_Carousel' );
	}
endif;
add_action( 'widgets_init', 'beautyagency_register_widget_recent_posts_carousel' );

if ( ! function_exists( 'beautyagency_recent_posts_carousel_scripts' ) ) :
	function beautyagency_recent_posts_carousel_scripts() {
		// Load widget stylesheet.
		wp_enqueue_style( 'beautyagency-recent-posts-carousel-widget', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-recent-posts-carousel/widget-recent-posts-carousel.css' );
		if ( is_rtl() ) {
			wp_enqueue_style( 'beautyagency-recent-posts-carousel-widget-rtl', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-recent-posts-carousel/widget-recent-posts-carousel-rtl.css' );
		}
		// Load script for carousel.
		wp_enqueue_script( 'beautyagency-recent-posts-carousel-widget-js', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-recent-posts-carousel/widget-recent-posts-carousel.js', array( 'jquery' ), "all", true );
	}
endif;
add_action( 'wp_enqueue_scripts', 'beautyagency_recent_posts_carousel_scripts' );

if ( ! function_exists( 'beautyagency_recent_posts_carousel_admin_scripts' ) ) :
	function beautyagency_recent_posts_carousel_admin_scripts() {
		// Load widget admin stylesheet.
		wp_enqueue_style( 'beautyagency-recent-posts-carousel-widget-admin', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-recent-posts-carousel/widget-recent-posts-carousel-admin.css' );
	}
endif;
add_action( 'admin_print_styles', 'beautyagency_recent_posts_carousel_admin_scripts' );