<?php
/**
 * Models Grid widget class.0
 */
if ( function_exists('ccm_register_post_types' ) ) {
	class BEAUTYAGENCY_Widget_Models_Grid extends WP_Widget {

		public function __construct() {
			$widget_ops = array(
				'classname'   => 'widget_models_entries',
				'description' => esc_html__( "Your site&#8217;s most models grid.", 'beautyagency' )
			);
			parent::__construct( 'beautyagency-models-grid', esc_html__( 'Models Grid', 'beautyagency' ), $widget_ops );
			$this->alt_option_name = 'widget_models_entries';
		}


		public function widget( $args, $instance ) {
			$current_sidebar =	beautyagency_get_current_sidebar($this->id);

			$sidebar_widget_hide = array(
				'sidebar-1',
				'footer-widget-1',
				'footer-widget-2',
				'footer-widget-3',
				'footer-widget-4'
			);

			if(in_array($current_sidebar, $sidebar_widget_hide)) {
				$css_class = 'col-xs-12';
			} else {
				$css_class = '';
			}


			ob_start();

			$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';

			/** This filter is documented in wp-includes/default-widgets.php */
			$title    = apply_filters( 'widget_title', $title, $instance, $this->id_base );
			$category = isset( $instance['category'] ) ? $instance['category'] : '';

			$layout          = isset( $instance['layout'] ) ? absint( $instance['layout'] ) : 1;
			$show_details    = isset( $instance['show_details'] ) ? $instance['show_details'] : 1;
			$show_all_button = isset( $instance['show_all_button'] ) ? $instance['show_all_button'] : 1;

			$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 10;
			if ( ! $number ) {
				$number = 10;
			}


			/**
			 * Filter the arguments for the Models Grid widget.
			 *
			 * @since 3.4.0
			 *
			 * @see WP_Query::get_posts()
			 *
			 * @param array $args An array of arguments used to retrieve the models grid.
			 */
			$r = new WP_Query( array(
				'post_type' => 'models_profile',
				'tax_query' => array(
					array(
						'taxonomy' => 'models_category',
						'field' => 'slug',
						'terms' => $category)
				),
				'posts_per_page'      => $number,
				'post_status'         => 'publish',
				'ignore_sticky_posts' => true
			)  );

			if ( $r->have_posts() ) :

				$thumbnail_args = array(
					'background'      => false,
					'print'           => true,
					'thumbnail_size'  => 'beautyagency-models-grid-1',
					'thumbnail_class' => 'beautyagency-models-grid-1',
					'use_default'     => true,
					'is_widget'       => true,
					'no_url'          => true,
				);

				if ( $layout == 2 ) {
					$thumbnail_args['thumbnail_size']  = 'beautyagency-models-grid-2';
					$thumbnail_args['thumbnail_class'] = 'beautyagency-models-grid-2';
				}

				?>
				<?php echo wp_kses_post( $args['before_widget'] ); ?>
				<?php if ( $title ) {
				echo wp_kses_post( $args['before_title'] . $title . $args['after_title'] );
			} ?>
				<?php /*if ($layout == 1) {*/ ?>
				<div <?php
				echo 'class="models-grid layout-' . $layout . ' "';
				?>><!--
				<?php while ( $r->have_posts() ) :
					$r->the_post(); ?>
                 -->
					<div class="models-grid-item <?php if ( $layout == 1 ) {
						echo esc_attr($css_class);
					} ?>">
						<div class="models-grid-item-inner">
							<div class="models-grid-item-media">
								<?php

								$pID = get_the_ID();

								switch ( $layout ) {
									default:
										echo '<a class="models-grid-media" href="' . esc_url( get_permalink( $pID ) ) . '"><span class="overlay"></span>';
										beautyagency_post_thumbnail( $thumbnail_args );
										echo '</a>';
										break;
									case 2 :
										echo '<a class="models-grid-media" href="' . esc_url( get_permalink( $pID ) ) . '"><span class="overlay"></span>';
										beautyagency_post_thumbnail( $thumbnail_args );
										echo '</a>';
										break;
								}
								?>
							</div>
							<div class="models-grid-content <?php if ( $show_details != 1 ) {
								echo 'no-details';
							} ?>">
								<a href="<?php echo esc_url( get_permalink( $pID ) ); ?>"><span
										class="models-item-title"><?php get_the_title() ? the_title() : the_ID(); ?></span></a>
								<?php
								$pretty_args                   = $thumbnail_args;
								$pretty_args['thumbnail_size'] = 'full';
								$pretty_args['print']          = false;

								$height = ccm_get_profile_meta( get_the_ID(), 'height' );
								$bust   = ccm_get_profile_meta( get_the_ID(), 'bust' );
								$waist  = ccm_get_profile_meta( get_the_ID(), 'waist' );
								$hips   = ccm_get_profile_meta( get_the_ID(), 'hips' );
								$shoe   = ccm_get_profile_meta( get_the_ID(), 'shoe' );
								$eyes   = ccm_get_profile_meta( get_the_ID(), 'eyes' );

								$output = '';
								// Model Details
								if ( $layout == 2 ) {
									if ( ! empty( $height ) ) {
										$output .= '<div class="model-height">';
										$output .= '<span>' . esc_html__( 'Height', 'beautyagency' ) . '</span>' . $height;
										$output .= '</div>';
									}

									if ( ! empty( $bust ) ) {
										$output .= '<div class="model-bust">';
										$output .= '<span>' . esc_html__( 'Bust', 'beautyagency' ) . '</span>' . $bust;
										$output .= '</div>';
									}

									if ( ! empty( $waist ) ) {
										$output .= '<div class="model-waist">';
										$output .= '<span>' . esc_html__( 'Waist', 'beautyagency' ) . '</span>' . $waist;
										$output .= '</div>';
									}

									if ( ! empty( $hips ) ) {
										$output .= '<div class="model-hips">';
										$output .= '<span>' . esc_html__( 'Hips', 'beautyagency' ) . '</span>' . $hips;
										$output .= '</div>';
									}

									if ( ! empty( $shoe ) ) {
										$output .= '<div class="model-shoe">';
										$output .= '<span>' . esc_html__( 'Shoe', 'beautyagency' ) . '</span>' . $shoe;
										$output .= '</div>';
									}
									if ( ! empty( $eyes ) ) {
										$output .= '<div class="model-eyes">';
										$output .= '<span>' . esc_html__( 'Eyes', 'beautyagency' ) . '</span>' . $eyes;
										$output .= '</div>';
									}
								}
								if ( $layout == 1 ) {
									$output .= '<a href="' . esc_url( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ) ) . '" data-gal="prettyPhoto[gallery]"><span class="show-gallery"></span></a>';
									$output .= '<a href="' . get_the_permalink()  . '"><span class="show-profile"></span></a>';
								}

								// Output Models Parameters
								if ( $show_details == 1 && ! beautyagency_get_customizer_option('hide_models_parameters_globally') ) {
									echo '<div class="models-grid-details-block">' . $output . '</div>';
								}
								?>
							</div><!-- .models-grid-content -->
						</div>
					</div><!--
					<?php endwhile; ?>
			--></div>
				<?php if ( $show_all_button ) : ?>
				<div class="models-item-view-all"><a
						href='<?php echo esc_url( home_url( '/' ) ) . esc_attr( ccm_get_models_rewrite_base() ); ?>'><?php esc_html_e( 'View All', 'beautyagency' ); ?></a>
				</div>
			<?php endif; ?>
				<?php /*} else {
                //
            }*/ ?>
				<?php echo wp_kses_post( $args['after_widget'] ); ?>
				<?php
				// Reset the global $the_post as this query will have stomped on it
				wp_reset_postdata();

			endif;

			ob_end_flush();
		}

		public function update( $new_instance, $old_instance ) {
			$instance                    = $old_instance;
			$instance['title']           = strip_tags( $new_instance['title'] );
			$instance['category']        = $new_instance['category'];
			$instance['number']          = (int) $new_instance['number'];
			$instance['layout']          = (int) $new_instance['layout'];
			$instance['show_details']    = isset( $new_instance['show_details'] ) ? (bool) $new_instance['show_details'] : false;
			$instance['show_all_button'] = isset( $new_instance['show_all_button'] ) ? (bool) $new_instance['show_all_button'] : false;

			if ( isset( $alloptions['widget_models_entries'] ) ) {
				delete_option( 'widget_models_entries' );
			}

			return $instance;
		}

		public function form( $instance ) {
			$title           = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
			$category        = isset( $instance['category'] ) ? $instance['category'] : '';
			$number          = isset( $instance['number'] ) ? absint( $instance['number'] ) : 10;
			$layout          = isset( $instance['layout'] ) ? absint( $instance['layout'] ) : 1;
			$show_details    = isset( $instance['show_details'] ) ? $instance['show_details'] : false;
			$show_all_button = isset( $instance['show_all_button'] ) ? $instance['show_all_button'] : false;
			?>

			<p><label
					for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title<br><i>block title</i>', 'beautyagency' ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
				       name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text"
				       value="<?php echo esc_attr( $title ); ?>"/></p>

			<p>
				<label
					for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>"><?php esc_html_e( 'Category:', 'beautyagency' ); ?></label>
				<?php wp_dropdown_categories( array(
					'hide_empty'      => 0,
					'selected'        => $category,
					'name'            => $this->get_field_name( 'category' ),
					'id'              => $this->get_field_id( 'category' ),
					'value_field'     => 'slug',
					'taxonomy'        => 'models_category'
				) ); ?>
			</p>

			<p><label
					for="<?php echo esc_attr( $this->get_field_id( 'number', 'beautyagency' ) ); ?>"><?php _e( 'Number of posts<br><i>to show</i>', 'beautyagency' ); ?></label>
				<input id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"
				       name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="number"
				       value="<?php echo absint( $number ); ?>" size="3"/></p>

			<p><input class="checkbox" type="checkbox" <?php checked( $show_all_button ); ?>
			          id="<?php echo esc_attr( $this->get_field_id( 'show_all_button' ) ); ?>"
			          name="<?php echo esc_attr( $this->get_field_name( 'show_all_button' ) ); ?>"/>
				<label
					for="<?php echo esc_attr( $this->get_field_id( 'show_all_button' ) ); ?>"><?php esc_attr_e( 'Display "View All" Button?', 'beautyagency' ); ?></label>
			</p>

			<p><input class="checkbox" type="checkbox" <?php checked( $show_details ); ?>
			          id="<?php echo esc_attr( $this->get_field_id( 'show_details' ) ); ?>"
			          name="<?php echo esc_attr( $this->get_field_name( 'show_details' ) ); ?>"/>
				<label
					for="<?php echo esc_attr( $this->get_field_id( 'show_details' ) ); ?>"><?php esc_attr_e( 'Display details block?', 'beautyagency' ); ?></label>
			</p>

			<p>
				<strong><?php esc_html_e( 'Layout:', 'beautyagency' ); ?></strong><br>
				<label for="<?php echo esc_attr( $this->get_field_id( 'grid-1' ) ); ?>" class="models-grid-radio-label">
					<input class="models-grid-radio" type="radio" <?php checked( $layout == 1 ); ?>
					       id="<?php echo esc_attr( $this->get_field_id( 'grid-1' ) ); ?>"
					       name="<?php echo esc_attr( $this->get_field_name( 'layout' ) ); ?>" value="1"/>
					<img
						src="<?php echo esc_url(get_template_directory_uri()) . '/inc/widgets/widget-models-grid/images/widget-models-grid-1.gif'; ?>"
						alt="<?php echo esc_html__( 'Grid 1', 'beautyagency' ); ?>">
				</label>
				<label for="<?php echo esc_attr( $this->get_field_id( 'grid-2' ) ); ?>" class="models-grid-radio-label">
					<input class="models-grid-radio" type="radio" <?php checked( $layout == 2 ); ?>
					       id="<?php echo esc_attr( $this->get_field_id( 'grid-2' ) ); ?>"
					       name="<?php echo esc_attr( $this->get_field_name( 'layout' ) ); ?>" value="2"/>
					<img
						src="<?php echo esc_url(get_template_directory_uri()) . '/inc/widgets/widget-models-grid/images/widget-models-grid-2.gif'; ?>"
						alt="<?php echo esc_html__( 'Grid 2', 'beautyagency' ); ?>">
				</label>
			</p>
			<?php
		}
	}

	if ( ! function_exists( 'beautyagency_models_grid_setup' ) ) :
		/**
		 * Sets up theme defaults and registers support for various WordPress features.
		 *
		 * Note that this function is hooked into the after_setup_theme hook, which
		 * runs before the init hook. The init hook is too late for some features, such
		 * as indicating support for post thumbnails.
		 */
		function beautyagency_models_grid_setup() {
			if ( ! has_image_size( 'beautyagency-models-grid-1' ) ) {
				add_image_size( 'beautyagency-models-grid-1', 450, 672, true );
			}
			if ( ! has_image_size( 'beautyagency-models-grid-2' ) ) {
				add_image_size( 'beautyagency-models-grid-2', 600, 900, true );
			}
		}
	endif; // beautyagency_models_grid_setup
	add_action( 'after_setup_theme', 'beautyagency_models_grid_setup', 20 );



	if ( ! function_exists( 'beautyagency_register_widget_models_grid' ) ) :
		function beautyagency_register_widget_models_grid() {
			register_widget( 'BEAUTYAGENCY_Widget_Models_Grid' );
		}
	endif;
	add_action( 'widgets_init', 'beautyagency_register_widget_models_grid' );

	if ( ! function_exists( 'beautyagency_models_grid_scripts' ) ) :
		function beautyagency_models_grid_scripts() {
			// Load widget stylesheet.
			wp_enqueue_style( 'beautyagency-models-grid-widget', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-models-grid/widget-models-grid.css' );
			if ( is_rtl() ) {
				wp_enqueue_style( 'beautyagency-models-grid-widget-rtl', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-models-grid/widget-models-grid-rtl.css' );
			}
		}
	endif;
	add_action( 'wp_enqueue_scripts', 'beautyagency_models_grid_scripts' );

	if ( ! function_exists( 'beautyagency_models_grid_admin_scripts' ) ) :
		function beautyagency_models_grid_admin_scripts() {
			// Load widget admin stylesheet.
			wp_enqueue_style( 'beautyagency-models-grid-widget-admin', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-models-grid/widget-models-grid-admin.css' );
		}
	endif;
	add_action( 'admin_print_styles', 'beautyagency_models_grid_admin_scripts' );
}