<?php
/**
 * Models Carousel widget class.0
 */
if ( function_exists('ccm_register_post_types' ) ) {
	class BEAUTYAGENCY_Widget_Models_Carousel extends WP_Widget {

		public function __construct() {
			$widget_ops = array(
				'classname'   => 'widget_models_entries_carousel',
				'description' => esc_html__( "Models organized in Slider.", 'beautyagency' )
			);
			parent::__construct( 'models-carousel', esc_html__( 'Models Carousel', 'beautyagency' ), $widget_ops );
			$this->alt_option_name = 'widget_models_entries_carousel';
		}

		public function widget( $args, $instance ) {
			$unique_id = uniqid();

			ob_start();

			$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';

			/** This filter is documented in wp-includes/default-widgets.php */
			$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

			$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
			if ( ! $number ) {
				$number = 5;
			}
			$category        = isset( $instance['category'] ) ? $instance['category'] : '';
			$show_navigation = isset( $instance['show_navigation'] ) ? $instance['show_navigation'] : false;

			if ( $show_navigation == true ) {
				$nav_class = 'nav-visible';
			} else {
				$nav_class = '';
			}

			$autoplay  = isset( $instance['autoplay'] ) ? $instance['autoplay'] : false;

			$style = isset( $instance['style'] ) ? absint( $instance['style'] ) : 1;
			if ( $style == 1 ) {
				$style = 1;
			} else {
				$style = 2;
			}


			$thumbnail_args = array(
				'thumbnail_size'  => 'beautyagency-model-carousel-1',
				'thumbnail_class' => 'beautyagency-model-carousel-1',
				'use_default'     => true,
				'is_widget'       => true,
				'no_url'          => true,
			);
			if ( $style == 2 ) {
				$thumbnail_args['thumbnail_size']  = 'beautyagency-model-carousel-2';
				$thumbnail_args['thumbnail_class'] = 'beautyagency-model-carousel-2';
			}

			/**
			 * Filter the arguments for the Models widget.
			 *
			 * @since 3.4.0
			 *
			 * @see WP_Query::get_posts()
			 *
			 * @param array $args An array of arguments used to retrieve the Models.
			 */
			$r = new WP_Query( array(
				'post_type'           => 'models_profile',
				'tax_query' => array(
					array(
						'taxonomy' => 'models_category',
						'field' => 'slug',
						'terms' => $category)
				),
				'posts_per_page'      => $number,
				'post_status'         => 'publish',
				'ignore_sticky_posts' => true
			)  );


			if ( $r->have_posts() ) :
				?>

				<?php echo wp_kses_post( $args['before_widget'] ); ?>
				<?php if ( $title ) {
				echo wp_kses_post( $args['before_title'] . $title . $args['after_title'] );
			} ?>
				<div class="owl-models-carousel-outer <?php echo 'style-' . esc_attr( $style ); ?> <?php echo esc_attr( $nav_class ); ?>">
					<div class="owl-models-carousel owl-models-carousel<?php echo esc_attr( $unique_id ) ?> owl-carousel mc-carousel" data-show_navigation="<?php echo  esc_attr($show_navigation)  ? 'true' : 'false' ?>"
						data-autoplay="<?php echo  esc_attr($autoplay) ? 'true' : 'false' ?>"
						data-uniqid="<?php echo esc_attr( $unique_id ); ?>">
						<?php while ( $r->have_posts() ) : $r->the_post(); ?>
							<div class="item">
								<div class="overlay"></div>
								<div class="mc-carousel__content">
									<h2 class="mc-carousel__title">
										<a href="<?php the_permalink(); ?>"><?php

											/**
											 * Models Post Title First Word
											 */
											if ( $style == 2 && ! is_admin() ) {
												$post         = get_post();
												$new_title    = isset( $post->post_title ) ? $post->post_title : '';
												$new_title    = explode( ' ', $new_title );
												$new_title[0] = '<span>' . $new_title[0] . '</span>';
												$new_title    = implode( ' ', $new_title );
												echo wp_kses($new_title, beautyagency_kses_init());
											} else {
												get_the_title() ? the_title() : the_ID();
											}
											?></a>
									</h2>
									<?php
									$pretty_args                   = $thumbnail_args;
									$pretty_args['thumbnail_size'] = 'full';
									$pretty_args['print']          = false;

									$height = ccm_get_profile_meta( get_the_ID(), 'height' );
									$bust   = ccm_get_profile_meta( get_the_ID(), 'bust' );
									$waist  = ccm_get_profile_meta( get_the_ID(), 'waist' );
									$hips   = ccm_get_profile_meta( get_the_ID(), 'hips' );
									$shoe   = ccm_get_profile_meta( get_the_ID(), 'shoe' );
									$eyes   = ccm_get_profile_meta( get_the_ID(), 'eyes' );

									$output = '';

									// Model Parameters
									if ( ! empty( $height ) ) {
										$output .= '<div class="model-height">';
										$output .= '<span>' . esc_html__( 'Height', 'beautyagency' ) . '</span>' . $height;
										$output .= '</div>';
									}

									if ( ! empty( $bust ) ) {
										$output .= '<div class="model-bust">';
										$output .= '<span>' . esc_html__( 'Bust', 'beautyagency' ) . '</span>' . $bust;
										$output .= '</div>';
									}

									if ( ! empty( $waist ) ) {
										$output .= '<div class="model-waist">';
										$output .= '<span>' . esc_html__( 'Waist', 'beautyagency' ) . '</span>' . $waist;
										$output .= '</div>';
									}

									if ( ! empty( $hips ) ) {
										$output .= '<div class="model-hips">';
										$output .= '<span>' . esc_html__( 'Hips', 'beautyagency' ) . '</span>' . $hips;
										$output .= '</div>';
									}

									if ( ! empty( $shoe ) ) {
										$output .= '<div class="model-shoe">';
										$output .= '<span>' . esc_html__( 'Shoe', 'beautyagency' ) . '</span>' . $shoe;
										$output .= '</div>';
									}
									if ( ! empty( $eyes ) ) {
										$output .= '<div class="model-eyes">';
										$output .= '<span>' . esc_html__( 'Eyes', 'beautyagency' ) . '</span>' . $eyes;
										$output .= '</div>';
									}

                                    // Don't Output Models Parameters
                                    if ( beautyagency_get_customizer_option('hide_models_parameters_globally') ) {
	                                    $output = '';
                                    }

									$output .= '<a href="' . esc_url( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ) ) . '" data-gal="prettyPhoto[gallery]"><span class="show-gallery"></span></a>';
									$output .= '<a href="' . get_the_permalink() . '"><span class="show-profile"></span></a>';

									echo '<div class="mc-carousel__parameters-block">' . $output . '</div>';
									?>
								</div>
								<div class="mc-carousel__image"><?php beautyagency_post_thumbnail( $thumbnail_args ) ?></div>
							</div><!-- .item -->
						<?php endwhile; ?>
					</div>
				</div>
				<?php echo wp_kses_post( $args['after_widget'] ); ?>
				<?php
				// Reset the global $the_post as this query will have stomped on it
				wp_reset_postdata();

			endif;

			ob_end_flush();
		}

		public function update( $new_instance, $old_instance ) {
			$instance                    = $old_instance;
			$instance['title']           = strip_tags( $new_instance['title'] );
			$instance['number']          = (int) $new_instance['number'];
			$instance['category']        = $new_instance['category'];
			$instance['style']           = (int) $new_instance['style'];
			$instance['show_category']   = isset( $new_instance['show_category'] ) ? (bool) $new_instance['show_category'] : false;
			$instance['show_navigation'] = isset( $new_instance['show_navigation'] ) ? (bool) $new_instance['show_navigation'] : false;
			$instance['autoplay']        = isset( $new_instance['autoplay'] ) ? (bool) $new_instance['autoplay'] : false;

			if ( isset( $alloptions['widget_models_entries_carousel'] ) ) {
				delete_option( 'widget_models_entries_carousel' );
			}

			return $instance;
		}

		public function form( $instance ) {
			$title           = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
			$number          = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
			$style           = isset( $instance['style'] ) ? absint( $instance['style'] ) : 1;
			$category        = isset( $instance['category'] ) ? $instance['category'] : '';
			$show_navigation = isset( $instance['show_navigation'] ) ? (bool) $instance['show_navigation'] : false;
			$autoplay        = isset( $instance['autoplay'] ) ? (bool) $instance['autoplay'] : false;

			?>
			<p><label
					for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php echo wp_kses( __( 'Title<br><i>carousel title</i>', 'beautyagency' ), beautyagency_kses_init(), $allowed_html_array = array(
						'br' => array(),
						'i'  => array()
					) ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
				       name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text"
				       value="<?php echo esc_attr( $title ); ?>"/></p>

			<p><label
					for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php echo wp_kses( __( 'Number of profiles<br><i>to show</i>', 'beautyagency' ), beautyagency_kses_init(), $allowed_html_array = array(
						'br' => array(),
						'i'  => array()
					) ); ?></label>
				<input id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"
				       name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="number"
				       value="<?php echo absint( $number ); ?>" size="3"/></p>

			<p>
				<label
					for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>"><?php echo wp_kses( __( 'Category<br><i>models category</i>', 'beautyagency' ), beautyagency_kses_init(), $allowed_html_array = array(
						'br' => array(),
						'i'  => array()
					) ); ?></label>
				<?php wp_dropdown_categories( array(
					'hide_empty'      => 0,
					'selected'        => $category,
					'name'            => $this->get_field_name( 'category' ),
					'id'              => $this->get_field_id( 'category' ),
					'value_field'     => 'slug',
					'taxonomy'        => 'models_category'
				) ); ?>
			</p>

			<p>
				<strong><?php esc_html_e( 'Layout:', 'beautyagency' ); ?></strong><br/>
				<label for="<?php echo esc_attr( $this->get_field_id( 'bottom' ) ); ?>"
				       class="models-carousel-radio-label">
					<input class="models-carousel-radio" type="radio" <?php checked( $style == 1 ); ?>
					       id="<?php echo esc_attr( $this->get_field_id( 'bottom' ) ); ?>"
					       name="<?php echo esc_attr( $this->get_field_name( 'style' ) ); ?>" value="1"/>
					<img
						src="<?php echo esc_url(get_template_directory_uri()) . '/inc/widgets/widget-models-carousel/images/widget-models-bottom.gif'; ?>"
						alt="<?php echo esc_html__( 'Bottom', 'beautyagency' ); ?>">
				</label>
				<label for="<?php echo esc_attr( $this->get_field_id( 'left' ) ); ?>"
				       class="models-carousel-radio-label">
					<input class="models-carousel-radio" type="radio" <?php checked( $style == 2 ); ?>
					       id="<?php echo esc_attr( $this->get_field_id( 'left' ) ); ?>"
					       name="<?php echo esc_attr( $this->get_field_name( 'style' ) ); ?>" value="2"/>
					<img
						src="<?php echo esc_url(get_template_directory_uri()) . '/inc/widgets/widget-models-carousel/images/widget-models-left.gif'; ?>"
						alt="<?php echo esc_html__( 'Left', 'beautyagency' ); ?>">
				</label>
			</p>

			<p><input class="checkbox" type="checkbox" <?php checked( $show_navigation ); ?>
			          id="<?php echo esc_attr( $this->get_field_id( 'show_navigation' ) ); ?>"
			          name="<?php echo esc_attr( $this->get_field_name( 'show_navigation' ) ); ?>"/>
				<label
					for="<?php echo esc_attr( $this->get_field_id( 'show_navigation' ) ); ?>"><?php esc_html_e( 'Show navigation?', 'beautyagency' ); ?></label>
			</p>

			<p><input class="checkbox" type="checkbox" <?php checked( $autoplay ); ?>
			          id="<?php echo esc_attr( $this->get_field_id( 'autoplay' ) ); ?>"
			          name="<?php echo esc_attr( $this->get_field_name( 'autoplay' ) ); ?>"/>
				<label
					for="<?php echo esc_attr( $this->get_field_id( 'autoplay' ) ); ?>"><?php esc_html_e( 'Auto play', 'beautyagency' ); ?></label>
			</p>

			<?php
		}
	}

	if ( ! function_exists( 'beautyagency_models_carousel_setup' ) ) :
		/**
		 * Sets up theme defaults and registers support for various WordPress features.
		 *
		 * Note that this function is hooked into the after_setup_theme hook, which
		 * runs before the init hook. The init hook is too late for some features, such
		 * as indicating support for post thumbnails.
		 */
		function beautyagency_models_carousel_setup() {
			if ( ! has_image_size( 'beautyagency-model-carousel-1' ) ) {
				add_image_size( 'beautyagency-model-carousel-1', 450, 672, true );
			}
			if ( ! has_image_size( 'beautyagency-model-carousel-2' ) ) {
				add_image_size( 'beautyagency-model-carousel-2', 600, 900, true );
			}
		}
	endif; // beautyagency_top_news_setup
	add_action( 'after_setup_theme', 'beautyagency_models_carousel_setup', 20 );


	if ( ! function_exists( 'beautyagency_register_widget_models_carousel' ) ) :
		function beautyagency_register_widget_models_carousel() {
			register_widget( 'BEAUTYAGENCY_Widget_Models_Carousel' );
		}
	endif;
	add_action( 'widgets_init', 'beautyagency_register_widget_models_carousel' );

	if ( ! function_exists( 'beautyagency_models_carousel_scripts' ) ) :
		function beautyagency_models_carousel_scripts() {
			// Load widget stylesheet.
			wp_enqueue_style( 'beautyagency-models-carousel-widget', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-models-carousel/widget-models-carousel.css' );
			if ( is_rtl() ) {
				wp_enqueue_style( 'beautyagency-models-widget-rtl', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-models-carousel/widget-models-carousel-rtl.css' );
			}
			// Load script for carousel.
			wp_enqueue_script( 'beautyagency-models-carousel-widget-js', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-models-carousel/widget-models-carousel.js', array( 'jquery' ), "all", true );
		}
	endif;
	add_action( 'wp_enqueue_scripts', 'beautyagency_models_carousel_scripts' );

	if ( ! function_exists( 'beautyagency_models_carousel_admin_scripts' ) ) :
		function beautyagency_models_carousel_admin_scripts() {
			// Load widget admin stylesheet.
			wp_enqueue_style( 'beautyagency-models-carousel-widget-admin', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-models-carousel/widget-models-carousel-admin.css' );
		}
	endif;
	add_action( 'admin_print_styles', 'beautyagency_models_carousel_admin_scripts' );
}