<?php
/**
 * Beautiful Posts Banner widget class
 *
 * @since 3.0.0
 */
class BEAUTYAGENCY_Banner_Strip_Widget extends WP_Widget {

    public function __construct() {
        $widget_ops = array( 'classname' => 'widget_banner_strip', 'description' => esc_html__('Add beautiful banners to your site.', 'beautyagency') );
        parent::__construct( 'banner-strip', esc_html__('Banner Strip', 'beautyagency'), $widget_ops );
        $this->alt_option_name = 'widget_banner_strip';
    }

    /**
     * @param array $args
     * @param array $instance
     */
    public function widget( $args, $instance ) {
        global $post;
        /** This filter is documented in wp-includes/default-widgets.php */
        $instance['title'] = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
        $url_1 = ( ! empty( $instance['url_1'] ) ) ? $instance['url_1'] : '';
        $image_1 = ( ! empty( $instance['image_1'] ) ) ? $instance['image_1'] : '';
        $url_2 = ( ! empty( $instance['url_2'] ) ) ? $instance['url_2'] : '';
        $image_2 = ( ! empty( $instance['image_2'] ) ) ? $instance['image_2'] : '';
        $url_3 = ( ! empty( $instance['url_3'] ) ) ? $instance['url_3'] : '';
        $image_3 = ( ! empty( $instance['image_3'] ) ) ? $instance['image_3'] : '';

        if( !$url_1 && !$url_2 && !$url_3 )
            {return;}

        $posts_array = array();
        $images_array = array();
        if( $url_1 && $image_1 ) {
            $posts_array[] = $url_1;
            $images_array[] = $image_1;
        }
        if( $url_2 && $image_2 ) {
            $posts_array[] = $url_2;
            $images_array[] = $image_2;
        }
        if( $url_3 && $image_3 ) {
            $posts_array[] = $url_3;
            $images_array[] = $image_3;
        }
        $posts_num = count( $posts_array );

        echo wp_kses_post($args['before_widget']);

        if ( !empty($instance['title']) )
            {echo wp_kses_post($args['before_title'] . $instance['title'] . $args['after_title']);}
        ?>
        <div class="banner-strip__row row">
        <?php for( $i = 0; $i < $posts_num; $i++ ){
            switch( $posts_num ){
                case 3:
                    ?>
                    <div class="banner-strip__3 col-md-4">
                    <?php
                    break;
                case 2:
                    ?>
                    <div class="banner-strip__2 col-md-6">
                    <?php
                    break;
                default:
                    ?>
                    <div class="banner-strip__1 col-md-12"><?php
                    break;
            }?>
                <div class="banner-strip">
                    <div class="banner-strip__content">
                        <a href="<?php echo esc_url( $posts_array[$i] ); ?>"><span class="overlay"></span><img src="<?php echo esc_url( $images_array[$i] ); ?>" alt="#"></a>
                    </div>
                </div>
            </div><?php
        }
        ?>
        </div>
        <?php
        echo wp_kses_post($args['after_widget']);
    }

    /**
     * @param array $new_instance
     * @param array $old_instance
     *
*@return array
     */
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['url_1'] = $new_instance['url_1'];
        $instance['image_1'] = $new_instance['image_1'];
        $instance['url_2'] = $new_instance['url_2'];
        $instance['image_2'] = $new_instance['image_2'];
        $instance['url_3'] = $new_instance['url_3'];
        $instance['image_3'] = $new_instance['image_3'];
        return $instance;
    }

    /**
     * @param array $instance
     */
    public function form( $instance ) {
        $title = isset( $instance['title'] ) ? $instance['title'] : '';
        $url_1 = isset( $instance['url_1'] ) ? $instance['url_1'] : '';
        $image_1 = isset( $instance['image_1'] ) ? $instance['image_1'] : '';
        $url_2 = isset( $instance['url_2'] ) ? $instance['url_2'] : '';
        $image_2 = isset( $instance['image_2'] ) ? $instance['image_2'] : '';
        $url_3 = isset( $instance['url_3'] ) ? $instance['url_3'] : '';
        $image_3 = isset( $instance['image_3'] ) ? $instance['image_3'] : '';

        ?>
        <div class="nav-menu-widget-form-controls">
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:', 'beautyagency' ) ?></label>
                <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo esc_attr( $title ); ?>"/>
            </p>

            <p><label for="<?php echo esc_attr( $this->get_field_id( 'url_1' ) ); ?>"><?php esc_html_e( '1st Post URL:', 'beautyagency' ); ?></label>
                <input id="<?php echo esc_attr( $this->get_field_id( 'url_1' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'url_1' ) ); ?>" type="url" value="<?php echo esc_url( $url_1 ); ?>" size="36" /></p>

			<p>
                <label for="<?php echo esc_attr($this->get_field_name( 'image_1' )); ?>"><?php esc_html_e( '1st Image URL:', 'beautyagency' ); ?></label>
                <input class="upload_image_input" name="<?php echo esc_attr($this->get_field_name( 'image_1' )); ?>" id="<?php echo esc_attr($this->get_field_id( 'image_1' )); ?>" type="text" size="24"  value="<?php echo esc_url( $image_1 ); ?>" />
                <input class="upload_image_button button" type="button" value="Set Image" /></p>

            <p><label for="<?php echo esc_attr( $this->get_field_id( 'url_2' ) ); ?>"><?php esc_html_e( '2nd Post URL:', 'beautyagency' ); ?></label>
                <input id="<?php echo esc_attr( $this->get_field_id( 'url_2' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'url_2' ) ); ?>" type="url" value="<?php echo esc_url( $url_2 ); ?>" size="36" /></p>

			<p>
                <label for="<?php echo esc_attr($this->get_field_name( 'image_2' )); ?>"><?php esc_html_e( '2nd Image URL:', 'beautyagency' ); ?></label>
                <input class="upload_image_input" name="<?php echo esc_attr($this->get_field_name( 'image_2' )); ?>" id="<?php echo esc_attr($this->get_field_id( 'image_2' )); ?>" type="text" size="24"  value="<?php echo esc_url( $image_2 ); ?>" />
                <input class="upload_image_button button" type="button" value="Set Image" /></p>

            <p><label for="<?php echo esc_attr( $this->get_field_id( 'url_3' ) ); ?>"><?php esc_html_e( '3rd Post URL:', 'beautyagency' ); ?></label>
                <input id="<?php echo esc_attr( $this->get_field_id( 'url_3' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'url_3' ) ); ?>" type="url" value="<?php echo esc_url( $url_3 ); ?>" size="36" /></p>

			<p>
                <label for="<?php echo esc_attr($this->get_field_name( 'image_3' )); ?>"><?php esc_html_e( '3rd Image URL:', 'beautyagency' ); ?></label>
                <input class="upload_image_input" name="<?php echo esc_attr($this->get_field_name( 'image_3' )); ?>" id="<?php echo esc_attr($this->get_field_id( 'image_3' )); ?>" type="text" size="24"  value="<?php echo esc_url( $image_3 ); ?>" />
                <input class="upload_image_button button" type="button" value="Set Image" /></p>

        </div>
        <?php
    }
}

if (!function_exists( 'beautyagency_register_widget_banner_strip')) :
    function beautyagency_register_widget_banner_strip() {
        register_widget('BEAUTYAGENCY_Banner_Strip_Widget');
    }
endif;
add_action('widgets_init', 'beautyagency_register_widget_banner_strip');

if (!function_exists('beautyagency_banner_strip_scripts')) :
    function beautyagency_banner_strip_scripts() {
        // Load widget stylesheet.
        wp_enqueue_style('beautyagency-banner-strip-widget', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-banner-strip/widget-banner-strip.css');
    }
endif;
add_action('wp_enqueue_scripts', 'beautyagency_banner_strip_scripts');

if (!function_exists('beautyagency_banner_strip_admin_scripts')) :
    function beautyagency_banner_strip_admin_scripts() {
        // Load widget admin stylesheet.
        wp_enqueue_style('beautyagency-banner-strip-widget-admin', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-banner-strip/widget-banner-strip-admin.css');
        wp_enqueue_style('thickbox');
        wp_enqueue_script('media-upload');
        wp_enqueue_script('thickbox');
        wp_enqueue_script('beautyagency-banner-strip-admin-widget', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-banner-strip/widget-banner-strip.js', array('jquery'));
    }
endif;
add_action('admin_print_styles', 'beautyagency_banner_strip_admin_scripts');