<?php
/**
 * Beautiful Posts Banner widget class
 *
 * @since 3.0.0
 */
class BEAUTYAGENCY_Banner_Posts_Widget extends WP_Widget {

    public function __construct() {
        $widget_ops = array( 'classname' => 'widget_banner_posts', 'description' => esc_html__('Add beautiful post banners to your site.', 'beautyagency') );
        parent::__construct( 'banner-posts', esc_html__('Banner Posts', 'beautyagency'), $widget_ops );
        $this->alt_option_name = 'widget_banner_posts';
    }

    /**
     * @param array $args
     * @param array $instance
     */
    public function widget( $args, $instance ) {
        global $post;
        /** This filter is documented in wp-includes/default-widgets.php */
        $instance['title'] = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
        $post_1 = ( ! empty( $instance['post_1'] ) ) ? absint( $instance['post_1'] ) : 0;
        $post_2 = ( ! empty( $instance['post_2'] ) ) ? absint( $instance['post_2'] ) : 0;
        $post_3 = ( ! empty( $instance['post_3'] ) ) ? absint( $instance['post_3'] ) : 0;
        $show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : false;
        $show_category = isset( $instance['show_category'] ) ? $instance['show_category'] : false;

        if( !$post_1 && !$post_2 && !$post_3 )
            {return;}

        $posts_array = array();
        if( $post_1 ) {
            $posts_array[] = $post_1;
        }
        if( $post_2 ) {
            $posts_array[] = $post_2;
        }
        if( $post_3 ) {
            $posts_array[] = $post_3;
        }
        $posts_num = count( $posts_array );
        $thumbnail_args = array(
            'background' => true,
            'print' => true,
            'thumbnail_size' => 'top-news-3-2',
            'thumbnail_class' => 'top-news-3-2',
            'use_default' => true,
            'is_widget' => true,
        );

        echo wp_kses_post($args['before_widget']);

        if ( !empty($instance['title']) )
            {echo wp_kses_post($args['before_title'] . $instance['title'] . $args['after_title']);}
        ?>
        <div class="row banner-post__row">
        <?php foreach( $posts_array as $pID ){
            $post_args = array(
            'p' => $pID, // id of a page, post, or custom type
            'post_type' => 'any');
            $post_obj = new WP_Query($post_args);
            $post_obj->the_post();
            switch( $posts_num ){
                case 3:
                    ?>
                    <div class="banner-post__3 col-md-4">
                    <?php
                    break;
                case 2:
                    ?>
                    <div class="banner-post__2 col-md-6">
                    <?php
                    break;
                default:
                    ?>
                    <div class="banner-post__1 col-md-offset-2 col-md-8"><?php
                    break;
            }?>
                <div class="banner-post" style="<?php beautyagency_post_thumbnail($thumbnail_args) ?>">
                <?php
                $category = beautyagency_get_first_category( $pID );

                ?>
                    <div class="banner-post__table">
                        <div class="banner-post__cell">
                            <div class="overlay"></div>
                            <a class="banner-post__link" href="<?php the_permalink(); ?>"></a>
                            <div class="banner-post__content">
                                <?php /* Post Category */
                                if ( $show_category ) : ?>
                                    <div class="banner-post__category"><?php echo wp_kses_post($category); ?></div>
                                <?php endif; ?>
                                <h2 class="banner-post__title"><a href="<?php the_permalink(); ?>"><?php get_the_title() ? the_title() : the_ID(); ?></a></h2>
                                <?php /* Post Date */
                                if ( $show_date ) : ?>
                                    <span class="banner-post__date"><?php echo get_the_date('d.m.Y'); ?></span>
                                <?php endif; ?>
                            </div>
                            <br class="clear">
                        </div>
                    </div>
                </div>
            </div><?php
        }
        wp_reset_postdata();
        ?>
        </div>
        <?php
        echo wp_kses_post($args['after_widget']);
    }

    /**
     * @param array $new_instance
     * @param array $old_instance
     *
*@return array
     */
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['post_1'] = (int) $new_instance['post_1'];
        $instance['post_2'] = (int) $new_instance['post_2'];
        $instance['post_3'] = (int) $new_instance['post_3'];
        $instance['show_date'] = isset( $new_instance['show_date'] ) ? (bool) $new_instance['show_date'] : false;
        $instance['show_category'] = isset( $new_instance['show_category'] ) ? (bool) $new_instance['show_category'] : false;
        return $instance;
    }

    /**
     * @param array $instance
     */
    public function form( $instance ) {
        $title = isset( $instance['title'] ) ? $instance['title'] : '';
        $post_1 = isset( $instance['post_1'] ) ? absint( $instance['post_1'] ) : 0;
        $post_2 = isset( $instance['post_2'] ) ? absint( $instance['post_2'] ) : 0;
        $post_3 = isset( $instance['post_3'] ) ? absint( $instance['post_3'] ) : 0;
        $show_date   = isset( $instance['show_date'] ) ? (bool) $instance['show_date'] : false;
        $show_category   = isset( $instance['show_category'] ) ? (bool) $instance['show_category'] : false;

        ?>
        <div class="nav-menu-widget-form-controls">
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:', 'beautyagency' ) ?></label>
                <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo esc_attr( $title ); ?>"/>
            </p>

            <p><label for="<?php echo esc_attr( $this->get_field_id( 'post_1' ) ); ?>"><?php esc_html_e( '1st Post ID', 'beautyagency' ); ?></label>
                <input id="<?php echo esc_attr( $this->get_field_id( 'post_1' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'post_1' ) ); ?>" type="number" value="<?php echo absint( $post_1 ); ?>" size="8" /></p>

            <p><label for="<?php echo esc_attr( $this->get_field_id( 'post_2' ) ); ?>"><?php esc_html_e( '2nd Post ID', 'beautyagency' ); ?></label>
                <input id="<?php echo esc_attr( $this->get_field_id( 'post_2' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'post_2' ) ); ?>" type="number" value="<?php echo absint( $post_2 ); ?>" size="8" /></p>

            <p><label for="<?php echo esc_attr( $this->get_field_id( 'post_3' ) ); ?>"><?php esc_html_e( '3rd Post ID', 'beautyagency' ); ?></label>
                <input id="<?php echo esc_attr( $this->get_field_id( 'post_3' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'post_3' ) ); ?>" type="number" value="<?php echo absint( $post_3 ); ?>" size="8" /></p>

            <p><input class="checkbox" type="checkbox" <?php checked( $show_category ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_category' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_category' ) ); ?>" />
			    <label for="<?php echo esc_attr( $this->get_field_id( 'show_category' ) ); ?>"><?php esc_html_e( 'Display post category?', 'beautyagency' ); ?></label></p>

            <p><input class="checkbox" type="checkbox" <?php checked( $show_date ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_date' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_date' ) ); ?>" />
			    <label for="<?php echo esc_attr( $this->get_field_id( 'show_date' ) ); ?>"><?php esc_html_e( 'Display post date?', 'beautyagency' ); ?></label></p>

        </div>
        <?php
    }
}

if (!function_exists( 'beautyagency_register_widget_banner_posts')) :
    function beautyagency_register_widget_banner_posts() {
        register_widget('BEAUTYAGENCY_Banner_Posts_Widget');
    }
endif;
add_action('widgets_init', 'beautyagency_register_widget_banner_posts');

if (!function_exists('beautyagency_banner_posts_scripts')) :
    function beautyagency_banner_posts_scripts() {
        // Load widget stylesheet.
        wp_enqueue_style('banner-posts-widget', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-banner-posts/widget-banner-posts.css');
    }
endif;
add_action('wp_enqueue_scripts', 'beautyagency_banner_posts_scripts');

if (!function_exists('beautyagency_banner_posts_admin_scripts')) :
    function beautyagency_banner_posts_admin_scripts() {
        // Load widget admin stylesheet.
        wp_enqueue_style('banner-posts-widget-admin', esc_url(get_template_directory_uri()) . '/inc/widgets/widget-banner-posts/widget-banner-posts-admin.css');
    }
endif;
add_action('admin_print_styles', 'beautyagency_banner_posts_admin_scripts');