<?php

/** Include the TGM_Plugin_Activation class. */
require_once get_template_directory() . '/inc/tgm-plugin-activation/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'my_theme_register_required_plugins' );

function my_theme_register_required_plugins()
{

	$plugins = array(
		array(
			'name'     				=> 'Contact Form 7',
			'slug'     				=> 'contact-form-7',
			'required'              => true,
		),
		array(
			'name'     				=> 'Unyson',
			'slug'     				=> 'unyson',
			'required'              => true,
		),
		array(
			'name'     				=> 'Widget CSS Classes',
			'slug'     				=> 'widget-css-classes',
			'required'              => true,
		),
		array(
			'name'     				=> 'Custom Content Models',
			'slug'     				=> 'custom-content-models',
			'source'   				  => get_template_directory() . '/inc/tgm-plugin-activation/plugins/custom-content-models.zip',
			'version' 				 => '1.0',
			'required' 				=> true
		),
		array(
			'name'     				=> 'MWTEmplates User Social',
			'slug'     				=> 'mwtemplates-user-social',
			'source'   				  => get_template_directory() . '/inc/tgm-plugin-activation/plugins/mwtemplates-user-social.zip',
			'version' 				 => '1.0',
			'required' 				=> true
		),
		array(
			'name'     				=> 'MailChimp for WordPress',
			'slug'     				=> 'mailchimp-for-wp',
			'required'              => true,
		),
		array(
			'name'     				=> 'Snazzy Maps',
			'slug'     				=> 'snazzy-maps',
			'required'              => true,
		),
		array (
			'name'              => 'Booked',
			'slug'              => 'booked',
			'source'            => esc_url('http://webdesign-finder.com/remote-demo-content/common-plugins-original/booked.zip'),
			'required'          => false,
		),

		array(
			'name'     				=> 'AccessPress Social Counter',
			'slug'     				=> 'accesspress-social-counter',
			'required'              => true
		),
		array(
			'name'     				=> 'Envato Market',
			'slug'     				=> 'envato-market',
			// remote source:
			'source'                => 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required.

		),
	);

	// Change this to your theme text domain, used for internationalising strings
	$theme_text_domain = 'beautyagency';

	$config = array(
		'domain'       		=> $theme_text_domain,         	// Text domain - likely want to be the same as your theme.
		'default_path' 		=> '',                         	// Default absolute path to pre-packaged plugins
		'menu'         		=> 'install-required-plugins', 	// Menu slug
		'has_notices'      	=> true,                       	// Show admin notices or not
		'is_automatic'    	=> true,					   	// Automatically activate plugins after installation or not
		'message' 			=> '',							// Message to output right before the plugins table
		'strings'      		=> array(
			'page_title'                       			=> esc_html__( 'Install Required Plugins', 'beautyagency' ),
			'menu_title'                       			=> esc_html__( 'Install Plugins', 'beautyagency' ),
			'installing'                       			=> esc_html__( 'Installing Plugin: %s', 'beautyagency' ), // %1$s = plugin name
			'oops'                             			=> esc_html__( 'Something went wrong with the plugin API.', 'beautyagency' ),
			'notice_can_install_required'     			=> _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'beautyagency' ), // %1$s = plugin name(s)
			'notice_can_install_recommended'			=> _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'beautyagency' ), // %1$s = plugin name(s)
			'notice_cannot_install'  					=> _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'beautyagency' ), // %1$s = plugin name(s)
			'notice_can_activate_required'    			=> _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'beautyagency' ), // %1$s = plugin name(s)
			'notice_can_activate_recommended'			=> _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'beautyagency' ), // %1$s = plugin name(s)
			'notice_cannot_activate' 					=> _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'beautyagency' ), // %1$s = plugin name(s)
			'notice_ask_to_update' 						=> _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'beautyagency' ), // %1$s = plugin name(s)
			'notice_cannot_update' 						=> _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'beautyagency' ), // %1$s = plugin name(s)
			'install_link' 					  			=> _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'beautyagency' ),
			'activate_link' 				  			=> _n_noop( 'Activate installed plugin', 'Activate installed plugins', 'beautyagency' ),
			'return'                           			=> esc_html__( 'Return to Required Plugins Installer', 'beautyagency' ),
			'plugin_activated'                 			=> esc_html__( 'Plugin activated successfully.', 'beautyagency' ),
			'complete' 									=> esc_html__( 'All plugins installed and activated successfully. %s', 'beautyagency' ), // %1$s = dashboard link
			'nag_type'									=> 'updated' // Determines admin notice type - can only be 'updated' or 'error'
		)
	);

	tgmpa($plugins, $config);
}