<?php
if ( ! function_exists( 'beautyagency_set_post_likes' ) ) :
	/**
	 * Likes incrementor
	 *
	 * @param int $postID ID of the post.
	 *
	 * @return bool No success if cookies are disabled
	 */
	function beautyagency_set_post_likes( $postID ) {
		if ( empty( $_COOKIE["$postID"] ) ) {

			$count_key = 'beautyagency_post_likes_count';
			$count     = get_post_meta( $postID, $count_key, true );
			if ( $count == '' ) {
				$count = 0;
				delete_post_meta( $postID, $count_key );
				add_post_meta( $postID, $count_key, '1' );
			} else {
				$count ++;
				update_post_meta( $postID, $count_key, $count );
			}
			setcookie( "$postID", "voted", strtotime( '+1 day' ), COOKIEPATH, COOKIE_DOMAIN, false ); // 86400 = 1 day
			return true;
		}

		return false;
	}
endif;

if ( ! function_exists( 'beautyagency_get_post_likes' ) ) :
	/**
	 * Get likes value
	 *
	 * @param int $postID ID of the post.
	 */
	function beautyagency_get_post_likes( $postID ) {
		$count_key = 'beautyagency_post_likes_count';
		$count     = get_post_meta( $postID, $count_key, true );
		if ( $count == '' ) {
			delete_post_meta( $postID, $count_key );
			add_post_meta( $postID, $count_key, '0' );

			return '0';
		}

		return $count;
	}
endif;

if ( ! function_exists( 'beautyagency_post_likes_scripts' ) ) :
// Add the JS
	function beautyagency_post_likes_scripts() {
		wp_enqueue_script( 'beautyagency-post-likes', esc_url(get_template_directory_uri()) . '/inc/mods/mod-post-likes/mod-post-likes.js', array( 'jquery' ), '1.0.0', true );
		wp_localize_script( 'beautyagency-post-likes', 'MyAjax', array(
			// URL to wp-admin/admin-ajax.php to process the request
			'ajaxurl'  => admin_url( 'admin-ajax.php' ),
			// generate a nonce with a unique ID "myajax-post-comment-nonce"
			// so that you can check it later when an AJAX request is sent
			'security' => wp_create_nonce( 'increment-post-likes' )//,
			//'post_id' => get_the_ID()
		) );
	}
endif;
add_action( 'wp_enqueue_scripts', 'beautyagency_post_likes_scripts' );

if ( ! function_exists( 'beautyagency_inc_post_like_callback' ) ) :
// The function that handles the AJAX request
	function beautyagency_inc_post_like_callback() {
		check_ajax_referer( 'increment-post-likes', 'security' );
		$pID = intval( $_POST['pID'] );
		beautyagency_set_post_likes( $pID );
		echo beautyagency_get_post_likes( $pID );

		die(); // this is required to return a proper result
	}
endif;
add_action( 'wp_ajax_add_like', 'beautyagency_inc_post_like_callback' );
add_action( 'wp_ajax_nopriv_add_like', 'beautyagency_inc_post_like_callback' );

if ( ! function_exists( 'beautyagency_post_like_button' ) ) :
	/**
	 * Print like button
	 */
	function beautyagency_post_like_button( $postID ) {
		$output = '';
		if ( empty( $_COOKIE["$postID"] ) ) {
			$output = '<span data-id="' . $postID . '"><a href="#" title="' . esc_attr__('like me', 'beautyagency') . '" class="like_button"><i class="fa fa-heart-o"></i></a></span>';
		} else {
			$output = '<i class="fa fa-heart"></i>';
		}
		echo apply_filters( 'beautyagency_like_button', $output );
	}
endif;
add_action( 'beautyagency_post_meta', 'beautyagency_post_like_button', 10, 1 );

if ( ! function_exists( 'beautyagency_post_like_count' ) ) :
	/**
	 * Print like counter value
	 */
	function beautyagency_post_like_count( $postID ) {
		echo apply_filters( 'beautyagency_like_count', '<span class="votes_count_' . $postID . '">' . beautyagency_get_post_likes( $postID ) . '</span>' );
	}
endif;
add_action( 'beautyagency_post_meta', 'beautyagency_post_like_count', 20, 1 );