<?php
/**
 * Theme meta boxes
 */

if ( ! function_exists( 'beautyagency_custom_metabox_admin_scripts' ) ) :
	function beautyagency_custom_metabox_admin_scripts() {
		// Load matabox admin stylesheet.
		wp_enqueue_style( 'beautyagency-custom-metabox-admin-scripts', esc_url(get_template_directory_uri()) . '/inc/mods/metabox/metabox.css' );
	}
endif;
add_action( 'admin_print_styles', 'beautyagency_custom_metabox_admin_scripts' );


/**
 * Show / Hide Sidebar
 */

/**
 * Display the metabox
 */

if ( ! function_exists( 'beautyagency_show_hide_sidebar_custom_metabox' ) ):
	function beautyagency_show_hide_sidebar_custom_metabox() {
		global $post;
		$showhidesidebar = get_post_meta( $post->ID, 'show_hide_sidebar', true ); ?>

		<label for="show_hide_sidebar">Show/Hide Sidebar</label>
		<input type="checkbox" id="show_hide_sidebar" name="show_hide_sidebar"
		       value="true" <?php echo ! empty( $showhidesidebar ) ? 'checked="checked"' : ''; ?> />

		<?php
	}
endif;

/**
 * Process the custom metabox fields
 */

if ( ! function_exists( 'beautyagency_save_custom_show_hide_sidebar' ) ):
	// Add action hooks. Without these we are lost
	add_action( 'save_post', 'beautyagency_save_custom_show_hide_sidebar' );
	function beautyagency_save_custom_show_hide_sidebar( $post_id ) {
		global $post;

		if ( ! empty ( $post ) ) {
			if ( ! empty( $_POST['show_hide_sidebar'] ) ) {
				update_post_meta( $post->ID, 'show_hide_sidebar', $_POST['show_hide_sidebar'] );
			} else {
				update_post_meta( $post->ID, 'show_hide_sidebar', '' );
			}
		}
	}
endif;

/**
 * Add meta box
 */

if ( ! function_exists( 'beautyagency_show_hide_sidebar_add_custom_metabox' ) ):
	// Add action hooks. Without these we are lost
	add_action( 'admin_init', 'beautyagency_show_hide_sidebar_add_custom_metabox' );
	function beautyagency_show_hide_sidebar_add_custom_metabox() {
		add_meta_box( 'beautyagency_show-hide-sidebar-custom-metabox', esc_html__( 'Show / Hide Sidebar', 'beautyagency' ), 'beautyagency_show_hide_sidebar_custom_metabox', 'page', 'side', 'low' );
	}
endif;

/**
 * Get and return the values for the show / hide sidebar
 */

if ( ! function_exists( 'beautyagency_is_page_show_sidebar' ) ):
	function beautyagency_is_page_show_sidebar( $id = null ) {
		if ( $id == null ) {
			global $post;
			$id = $post->ID;
		}
		$showhidesidebar = get_post_meta( $id, 'show_hide_sidebar', true );

		if ( ! empty( $showhidesidebar ) ) {
			return true;
		} else {
			return false;
		}
	}
endif;

/**
 * Add body class
 */
if ( ! function_exists( 'beautyagency_page_sidebar_none' ) ):
	function beautyagency_page_sidebar_none( $classes ) {
		$showhidesidebar = get_post_meta( get_the_ID(), 'show_hide_sidebar', true );
		if ( empty( $showhidesidebar ) ) {
			$classes[] = 'page-sidebar-none';
		}

		return $classes;
	}
endif;
add_filter( 'body_class', 'beautyagency_page_sidebar_none' );
