<?php

require get_template_directory() . '/inc/main_class.php';

if ( ! function_exists( 'beautyagency_set' ) ) :
function beautyagency_set( $var, $key, $def = '' )
{

    if( is_object( $var ) && isset( $var->$key ) ) return $var->$key;
    elseif( is_array( $var ) && isset( $var[$key] ) ) return $var[$key];
    elseif( $def ) return $def;
    else return false;
}
endif;

if ( ! function_exists( 'printr' ) ) :
function printr($data)
{
    echo '<pre>'; print_r($data);exit;
}
endif;

if ( ! function_exists( '_font_awesome' ) ) :
function _font_awesome( $index )
{
	$array = array_values($GLOBALS['_font_awesome']);
	if( $font = beautyagency_set($array, $index )) return $font;
	else return false;
}
endif;

if ( ! function_exists( '_load_class' ) ) :
function _load_class($class, $directory = 'inc', $global = true, $prefix = 'BEAUTYAGENCY_')
{
    $obj = &$GLOBALS['_beautyagency_base'];
    $obj = is_object( $obj ) ? $obj : new stdClass;

    $name = FALSE;

    // Is the request a class extension?  If so we load it too
    $path = get_template_directory().'/'.$directory.'/'.$class.'.php';
    if( file_exists($path) )
    {
        $name = $prefix.ucwords( $class );

        if (class_exists($name) === FALSE)	require $path;
    }

    // Did we find the class?
    if ($name === FALSE) exit('Unable to locate the specified class: '.$class.'.php');

    if( $global ) $GLOBALS['_beautyagency_base']->$class = new $name();
    else new $name();
}
endif;

require get_template_directory() . '/inc/functions.php';
_load_class( 'bootstrap_walker', 'inc', false );

if( is_admin() )
/** Plugin Activation */
require get_template_directory().DIRECTORY_SEPARATOR.'inc'.DIRECTORY_SEPARATOR.'tgm-plugin-activation'.DIRECTORY_SEPARATOR.'plugins.php';
