<?php
if ( ! function_exists( 'beautyagency_is_current_header' ) ) :
	function beautyagency_is_current_header( $current_page_header, $headers_array ) {
		if ( ! empty ( $GLOBALS['wp_customize'] ) ) {
			global $wp_customize;
			$post_values = $wp_customize->unsanitized_post_values();
			if ( ! empty( $post_values['main_menu_style'] ) ) {
				$current_page_header = $post_values['main_menu_style'];
			}
		}

		return $current_page_header && array_key_exists( $current_page_header, $headers_array );
	}
endif;

if ( ! function_exists( 'beautyagency_header_logo_big' ) ) :
	function beautyagency_header_logo_big( $logo_url ) {
		if ( ! empty ( $GLOBALS['wp_customize'] ) ) {
			global $wp_customize;
			$post_values = $wp_customize->unsanitized_post_values();
			if ( isset( $post_values['header_logo_big'] ) ) {
				$logo_url = $post_values['header_logo_big'];
			}
		}

		return esc_url( $logo_url );
	}
endif;
add_filter( 'beautyagency_header_logo_big', 'beautyagency_header_logo_big' );

if ( ! function_exists( 'beautyagency_logo_site_name' ) ) :
	function beautyagency_logo_site_name( $site_name, $is_site_name = true ) {
		if ( ! empty ( $GLOBALS['wp_customize'] ) ) {
			global $wp_customize;
			$post_values = $wp_customize->unsanitized_post_values();
			if ( isset( $post_values['blogname'] ) && $is_site_name ) {
				$site_name = $post_values['blogname'];
			}
			if ( isset( $post_values['blogdescription'] ) && $is_site_name ) {
				$site_name = $post_values['blogdescription'];
			}
		}

		return $site_name;
	}
endif;
add_filter( 'beautyagency_logo_site_name', 'beautyagency_logo_site_name' );

if ( ! function_exists( 'beautyagency_get_header_styles' ) ) :
	/**
	 * Forming a Header Array for Customizer
	 *
	 * Creates the array to fill selects in metabox and theme options.
	 *
	 * @param    bool    is_metabox
	 *
	 * @return    array
	 */
	function beautyagency_get_header_styles( $is_metabox = false ) {
		$headers_array1 = apply_filters( 'beautyagency_headers_array1', false );
		$headers_array2 = apply_filters( 'beautyagency_headers_array2', false );
		$headers_array3 = apply_filters( 'beautyagency_headers_array3', false );
		$headers_array4 = apply_filters( 'beautyagency_headers_array4', false );
		$headers_list   = array(
			'header1' => 'Default Header',
		);

		for ( $i = 1; $i <= 4; $i ++ ) {
			if ( is_array( ${'headers_array' . $i} ) ) {
				$headers_list += ${'headers_array' . $i};
			}
		}

		if ( $is_metabox ) {
			array_unshift( $headers_list, array( 'value' => 'default', 'label' => 'Default Header' ) );
		}

		return $headers_list;
	}
endif;

if ( ! function_exists( 'beautyagency_print_header' ) ) :
	/**
	 * Form function call to print header depending on settings
	 *
	 * Calls function to print out selected header
	 *
	 * @param    string    header_id
	 * @param   array   theme_options
	 */
	function beautyagency_print_header( $header_id, $theme_options ) {

		if ( empty( $header_id ) || $header_id == 'default' ) {
			$header_id = beautyagency_set( $theme_options, 'default_header_style' );
		}

		$header_func = 'beautyagency_' . $header_id;

		if ( function_exists( $header_func ) ) {
			$header_func( $theme_options );
		} else {
			beautyagency_header1( $theme_options );
		}
	}
endif;

if ( ! function_exists( 'beautyagency_header1' ) ) :
	/**
	 *
	 * Add as many header styles as you need. Don't forget to add them to array in beautyagency_get_header_styles
	 *
	 */

	function beautyagency_header1( $theme_options ) {
		?>
		<div class="header-wrapper header_style1">
			<div class="header__top">
				<div id="top-bar" class="top-bar">
					<?php // Show Top Email
					$top_email = beautyagency_get_customizer_option( 'top_email' );
					if ( $top_email != '' ): ?>
						<div class="top-bar-left">
							<?php echo wp_kses($top_email, beautyagency_kses_init()); ?>
						</div>
					<?php endif; ?>

					<?php if ( $theme_options['hide_social_icons'] == '' ) { ?>
						<div class="top-bar-center hidden-xs">
							<?php
							if ( has_nav_menu( 'social' ) ) {
								wp_nav_menu(
									array(
										'menu_class'     => 'social-navigation',
										'container'      => false,
										/* classes for container */
										'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
										'link_before'    => '<span class="screen-reader-text">',
										'link_after'     => '</span>',
										'theme_location' => 'social',
										/* we have two menus here we use our header menu as social navigation */
										'depth'          => 0
										/* in depth of 3 we'r using dropdown menu */
									)
								);
							}
							?>
						</div>
					<?php } ?>
					<div class="top-bar-right">
						<div class="login-button">
							<?php beautyagency_login_popup(); ?>
						</div>
						<!-- // -->
						<?php if ( $theme_options['hide_menu_search'] == '' ) { ?>
							<span class="header-button header-button__search"><i class="rt-icon icon-search2"></i></span>
							<div class="search-box">
								<form class="search-box__form" method="get"
								      action="<?php echo esc_url( home_url( '/' ) ); ?>" role="search">
									<label class="search-box__label" for="search-box__input">Enter search words and
										press enter</label>
									<input type="search" name="s" id="search-box__input" class="search-box__input"
									       placeholder="<?php esc_attr_e( 'Type search keyword here and press enter...', 'beautyagency' ); ?>"/>
								</form>
							</div>
						<?php } ?>
						<!-- // -->
					</div>
				</div>
			</div>
			<div class="header-sticky">
				<div class="header__primary">
					<!-- Header Logo-->
					<div class="header__logo">
						<!-- Logo -->
						<?php
						$logo_class = 'logo ';
						if ( get_theme_mod( 'header_use_logo' ) ) {
							$logo_class .= 'logo-use-image';
						}
						?>
						<div class="<?php echo esc_attr( $logo_class ); ?>">
							<?php if ( get_theme_mod( 'header_use_logo' ) ) { ?>
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
									<img alt="Logo" class="logo logo_big"
									     src="<?php echo apply_filters( 'beautyagency_header_logo_big', $theme_options['header_logo_big'] ); ?>"/>
								</a>
							<?php } else { ?>
								<div class="text-logo">
									<div class="blogname">
										<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php
											$site_name = apply_filters( "beautyagency_logo_site_name", get_bloginfo( 'name', 'beautyagency' ) );
											if ( ! empty( $site_name ) ) {
												echo beautyagency_logo_highlight( esc_attr( $site_name ) );
											} ?>
										</a>
									</div>
									<div class="blogdescr">
										<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php
											$site_description = apply_filters( "beautyagency_logo_site_name", get_bloginfo( 'description', 'beautyagency' ) );
											if ( ! empty( $site_description ) ) {
												echo esc_attr( $site_description );
											} ?>
										</a>
									</div>
								</div>
							<?php } ?>
						</div><!-- .logo-->
					</div><!-- .header__logo -->

					<!-- Header Menu -->
					<div class="header__menu">
						<!-- Menu Strip -->
						<div class="menu-strip">
							<nav class="main-nav"><?php
								if ( has_nav_menu( 'primary' ) ) {
									wp_nav_menu(
										array(
											'container'      => false,
											/* classes for container */
											'items_wrap'     => '<ul id="main-nav" class="%2$s">%3$s</ul>',
											'theme_location' => 'primary',
											/* we have two menus here we use our header menu as primery navigation */
											'depth'          => 0
											/* in depth of 3 we'r using dropdown menu */
										)
									);
								} elseif ( wp_get_nav_menu_object( "Main menu" ) ) {
									wp_nav_menu(
										array(
											'container'  => false, /* classes for container */
											'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
											'menu'       => 'Main menu',
											'depth'      => 0 /* in depth of 3 we'r using dropdown menu */
										)
									);
								} else { ?>
									<div class="create-menu">You don't have a menu. Please create one
										<strong><a
												href="<?php echo esc_url( home_url( '/' ) ) ?>wp-admin/nav-menus.php">HERE</a></strong>
									</div>
									<?php
								} ?>
							</nav>
						</div><!-- .menu-strip -->
						<span class="nav-button"></span>
					</div><!-- .header__menu -->

					<?php // Show text after main menu
					$top_nav_text = beautyagency_get_customizer_option( 'top_nav_text' );
					if ( $top_nav_text != '' ): ?>
						<div class="top-nav-text">
							<?php echo wp_kses($top_nav_text, beautyagency_kses_init()); ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<?php
	}
endif;

if ( ! function_exists( 'beautyagency_header2' ) ) :
	/**
	 *
	 * Add as many header styles as you need. Don't forget to add them to array in beautyagency_get_header_styles
	 *
	 */

	function beautyagency_header2( $theme_options ) {
		?>
		<div class="header-wrapper header_style2">
			<div class="header-top-outer">
				<div class="header-sticky">
					<div class="header__top">
						<!-- Header Logo-->
						<div class="header__logo">
							<!-- Logo -->
							<?php
							$logo_class = 'logo ';
							if ( beautyagency_get_customizer_option( 'header_use_logo' ) ) {
								$logo_class .= 'logo-use-image';
							}
							?>
							<div class="<?php echo esc_attr( $logo_class ); ?>">
								<?php if ( beautyagency_get_customizer_option( 'header_use_logo' ) ) { ?>
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
										<img alt="Logo" class="logo logo_big"
										     src="<?php echo apply_filters( 'beautyagency_header_logo_big', $theme_options['header_logo_big'] ); ?>"/>
									</a>
								<?php } else { ?>
									<div class="text-logo">
										<div class="blogname">
											<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php
												$site_name = apply_filters( "beautyagency_logo_site_name", get_bloginfo( 'name', 'beautyagency' ) );
												if ( ! empty( $site_name ) ) {
													echo beautyagency_logo_highlight( esc_attr( $site_name ) );
												} ?>
											</a>
										</div>
										<div class="blogdescr">
											<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php
												$site_description = apply_filters( "beautyagency_logo_site_name", get_bloginfo( 'description', 'beautyagency' ) );
												if ( ! empty( $site_description ) ) {
													echo esc_attr( $site_description );
												} ?>
											</a>
										</div>
									</div>
								<?php } ?>
							</div><!-- .logo-->
						</div><!-- .header__logo -->

						<!-- Header Menu -->
						<div class="header__menu">
							<!-- Menu Strip -->
							<div class="menu-strip">
								<nav class="main-nav"><?php
									if ( has_nav_menu( 'primary' ) ) {
										wp_nav_menu(
											array(
												'container'      => false,
												/* classes for container */
												'items_wrap'     => '<ul id="main-nav" class="%2$s">%3$s</ul>',
												'theme_location' => 'primary',
												/* we have two menus here we use our header menu as primery navigation */
												'depth'          => 0
												/* in depth of 3 we'r using dropdown menu */
											)
										);
									} elseif ( wp_get_nav_menu_object( "Main menu" ) ) {
										wp_nav_menu(
											array(
												'container'  => false, /* classes for container */
												'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
												'menu'       => 'Main menu',
												'depth'      => 0 /* in depth of 3 we'r using dropdown menu */
											)
										);
									} else { ?>
										<div class="create-menu">You don't have a menu. Please create one <strong><a
													href="<?php echo esc_url( home_url( '/' ) ) ?>wp-admin/nav-menus.php">HERE</a></strong>
										</div>
										<?php
									} ?>
								</nav>
							</div><!-- .menu-strip -->
							<span class="nav-button"></span>
						</div><!-- .header__menu -->

						<?php // Show text after main menu
						$top_nav_text = beautyagency_get_customizer_option( 'top_nav_text', true );
						if ( $top_nav_text != '' ): ?>
							<div class="top-nav-text">
								<?php echo wp_kses($top_nav_text, beautyagency_kses_init()); ?>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
			<div class="top-bar hidden-xs">
				<?php // Show Top Email
				$top_email = beautyagency_get_customizer_option( 'top_email', true );
				if ( $top_email != '' ): ?>
					<div class="top-bar-left ">
						<?php echo wp_kses($top_email, beautyagency_kses_init()); ?>
					</div>
				<?php endif; ?>

				<?php if ( $theme_options['hide_social_icons'] == '' ) { ?>
					<div class="top-bar-center">
						<?php
						// Unyson Breadcrumbs
						if ( function_exists( 'fw_ext_breadcrumbs' ) ) {
							fw_ext_breadcrumbs();
						} else {
							echo '<ul class="breadcrumbs">' . beautyagency_get_the_breadcrumb() . '</ul>';
						}
						?>
					</div>
				<?php } ?>
				<div class="top-bar-right">
					<div class="login-button">
						<?php beautyagency_login_popup(); ?>
					</div>
					<!-- // -->
					<?php if ( $theme_options['hide_menu_search'] == '' ) { ?>
						<span class="header-button header-button__search"><i class="rt-icon icon-search2"></i></span>
						<div class="search-box">
							<form class="search-box__form" method="get"
							      action="<?php echo esc_url( home_url( '/' ) ); ?>" role="search">
								<label class="search-box__label" for="search-box__input">Enter search words and
									press enter</label>
								<input type="search" name="s" id="search-box__input" class="search-box__input"
								       placeholder="<?php esc_attr_e( 'Type search keyword here and press enter...', 'beautyagency' ); ?>"/>
							</form>
						</div>
					<?php } ?>
					<!-- // -->

					<div class="header-overlay"></div>
				</div>
			</div>
		</div>
		<?php
	}
endif;