<?php
if ( ! function_exists( 'beautyagency_include_file' ) ) :
function beautyagency_include_file( $path, $args )
{
    if( file_exists( get_template_directory().DIRECTORY_SEPARATOR.$path ) )
        include( get_template_directory().DIRECTORY_SEPARATOR.$path );
}
endif;

if ( ! function_exists( '_BEAUTYAGENCY_Params' ) ) :
function _BEAUTYAGENCY_Params()
{
    return $GLOBALS['_beautyagency_base'];
}
endif;


if( !function_exists( 'beautyagency_slug' ) ) :
    function beautyagency_slug( $string )
    {
        $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.
        return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
    }
endif;

if ( ! function_exists( 'beautyagency_get_sidebars' ) ) :
function beautyagency_get_sidebars($multi = false)
{
    global $wp_registered_sidebars;

    $sidebars = !($wp_registered_sidebars) ? get_option('wp_registered_sidebars') : $wp_registered_sidebars;

    if( $multi ) $data[] = array('value'=>'', 'label' => 'No Sidebar');
    else $data = array('' => esc_html__('No Sidebar', 'beautyagency'));
    foreach( (array)$sidebars as $sidebar)
    {
        if( $multi ) $data[] = array( 'value'=> beautyagency_set($sidebar, 'id'), 'label' => beautyagency_set( $sidebar, 'name') );
        else $data[beautyagency_set($sidebar, 'id')] = beautyagency_set($sidebar, 'name');
    }

    return $data;
}
endif;

if ( ! function_exists('character_limiter')) :
    function character_limiter($str, $n = 500, $end_char = '&#8230;', $allowed_tags = false)
    {
        if($allowed_tags) $str = strip_tags($str, $allowed_tags);
        if (strlen($str) < $n)	return $str;
        $str = preg_replace("/\s+/", ' ', str_replace(array("\r\n", "\r", "\n"), ' ', $str));

        if (strlen($str) <= $n) return $str;

        $out = "";
        foreach (explode(' ', trim($str)) as $val)
        {
            $out .= $val.' ';

            if (strlen($out) >= $n)
            {
                $out = trim($out);
                return ( strlen($out ) == strlen($str)) ? $out : $out.$end_char;
            }
        }
    }
endif;

if ( ! function_exists( 'beautyagency_get_the_breadcrumb' ) ) :
function beautyagency_get_the_breadcrumb() {
    global $wp_query;
    $queried_object = get_queried_object();

    $breadcrumb = '';
    $delimiter = ' / ';
    $before = '<li>';
    $after = '</li>';

    if ( ! is_home() ) {
        $breadcrumb .= '<li><a href="'.esc_url( home_url( '/' ) ).'">'.esc_html__('Home', 'beautyagency').'</a></li>';

        /** If category or single post */
        if ( is_category() ) {
            $cat_obj = $wp_query->get_queried_object();
            $this_category = get_category( $cat_obj->term_id );

            if ( $this_category->parent != 0 ) {
                $parent_category = get_category( $this_category->parent );
                $breadcrumb .= get_category_parents($parent_category, TRUE, $delimiter );
            }

            $breadcrumb .= '<li><a href="'.esc_url(get_category_link(get_query_var('cat'))).'">'.single_cat_title('', FALSE).'</a></li>';
        }
        elseif ( is_tax() ) {
            $breadcrumb .= '<li><a href="'.esc_url(get_term_link($queried_object)).'">'.$queried_object->name.'</a></li>';
        }
        elseif ( is_page() ) { /** If WP pages */
            global $post;
            if ( $post->post_parent ) {
                $anc = get_post_ancestors($post->ID);
                foreach($anc as $ancestor) {
                    $breadcrumb .= '<li><a href="'.esc_url(get_permalink($ancestor)).'">'.get_the_title($ancestor).'</a></li>';
                }
                $breadcrumb .= '<li><span>'.get_the_title($post->ID).'</span></li>';

            }else $breadcrumb .= '<li><span>'.get_the_title().'</span></li>';
        }
        elseif ( is_singular() ) {
            if ( $category = wp_get_object_terms(get_the_ID(), array('category')) ) {
                if ( !is_wp_error($category) ) {
                    $breadcrumb .= '<li><a href="'.esc_url(get_term_link(beautyagency_set($category, '0'))).'">'
                        .beautyagency_set( beautyagency_set($category, '0'), 'name').'</a></li>';
                    $breadcrumb .= '<li><span>'.get_the_title().'</span></li>';
                }
            }
            else {
                $breadcrumb .= '<li><span>'.get_the_title().'</span></li>';
            }
        }
        elseif(is_tag()) $breadcrumb .= '<li><a href="'.esc_url(get_term_link($queried_object)).'">'.single_tag_title('', FALSE).'</a></li>'; /**If tag template*/
        elseif(is_day()) $breadcrumb .= '<li><a href="#">'.esc_html__('Archive for ', 'beautyagency').get_the_time('F jS, Y').'</a></li>'; /** If daily Archives */
        elseif(is_month()) $breadcrumb .= '<li><a href="' .esc_url(get_month_link(get_the_time('Y'), get_the_time('m'))) .'">'.esc_html__('Archive for ', 'beautyagency').get_the_time('F, Y').'</a></li>'; /** If montly Archives */
        elseif(is_year()) $breadcrumb .= '<li><a href="'.esc_url(get_year_link(get_the_time('Y'))).'">'.esc_html__('Archive for ', 'beautyagency').get_the_time('Y').'</a></li>'; /** If year Archives */
        elseif(is_author()) $breadcrumb .= '<li><a href="'. esc_url( get_author_posts_url( get_the_author_meta( "ID" ) ) ) .'">'.esc_html__('Archive for ', 'beautyagency').get_the_author().'</a></li>'; /** If author Archives */
        elseif(is_search()) $breadcrumb .= '<li><span>'.esc_html__('Search Results for ', 'beautyagency').get_search_query().'</span></li>'; /** if search template */
        elseif(is_404()) $breadcrumb .= '<li><span>'.esc_html__('404', 'beautyagency').'</span></li>'; /** if search template */
        elseif ( is_post_type_archive('product') ) {

            $shop_page_id = woocommerce_get_page_id( 'shop' );
            if( get_option('page_on_front') !== $shop_page_id  )
            {
                $shop_page    = get_post( $shop_page_id );

                $_name = woocommerce_get_page_id( 'shop' ) ? get_the_title( woocommerce_get_page_id( 'shop' ) ) : '';

                if ( ! $_name ) {
                    $product_post_type = get_post_type_object( 'product' );
                    $_name = $product_post_type->labels->singular_name;
                }

                if ( is_search() ) {
                    $breadcrumb .= $before . '<a href="' . esc_url(get_post_type_archive_link('product'))
                        . '">' . $_name . '</a>' . $delimiter . esc_html__( 'Search results for &ldquo;', 'beautyagency' )
                        . get_search_query() . '&rdquo;' . $after;
                } elseif ( is_paged() ) {
                    $breadcrumb .= $before . '<a href="' . esc_url(get_post_type_archive_link('product')) . '">' . $_name . '</a>' . $after;
                } else {
                    $breadcrumb .= $before . $_name . $after;
                }
            }

        }
        elseif ( is_post_type_archive() ) {
            $breadcrumb .= '<li><span>' . get_the_archive_title() . '</span></li>';
        }
        else { /** Default value */
            $breadcrumb .= '<li><a href="' . esc_url(get_permalink()) . '">' . get_the_title() . '</a></li>';
        }
    }
    elseif ( is_home() ) {
        $breadcrumb .= '<li><a href="'.esc_url( home_url( '/' ) ).'">'.esc_html__('Home', 'beautyagency')
            .'</a></li><li><span>'.esc_html__('Blog', 'beautyagency').'</span></li>';
    }
    return $breadcrumb;
}
endif;

if ( ! function_exists( 'beautyagency_register_user' ) ) :
function beautyagency_register_user( $data )
{
    $user_name = beautyagency_set( $data, 'user_login' );
    $user_email = beautyagency_set( $data, 'user_email' );
    $user_pass = beautyagency_set( $data, 'user_password' );
    $policy = beautyagency_set( $data, 'policy_agreed');

    $user_id = username_exists( $user_name );
    $message = '<div class="alert-error" style="margin-bottom:10px;padding:10px"><h5>'.esc_html__('You must agreed the policy', 'beautyagency').'</h5></div>';;
    if( !$policy ) $message = '';
    if ( !$user_id && email_exists($user_email) == false ) {

        if( $policy ){

            $random_password = ( $user_pass ) ? $user_pass : wp_generate_password( $length=12, $include_standard_special_chars=false );
            $user_id = wp_create_user( $user_name, $random_password, $user_email );
            if ( is_wp_error($user_id) && is_array( $user_id->get_error_messages() ) )
            {
                foreach($user_id->get_error_messages() as $message)	$message .= '<div class="alert-error" style="margin-bottom:10px;padding:10px"><h5>'.$message.'</h5></div>';
            }
            else $message = '<div class="alert-success" style="margin-bottom:10px;padding:10px"><h5>'.esc_html__('Registration Successful - An email is sent', 'beautyagency').'</h5></div>';
        }

    } else {
        $message .= '<div class="alert-error" style="margin-bottom:10px;padding:10px"><h5>'.esc_html__('Username or email already exists.  Password inherited.', 'beautyagency').'</h5></div>';
    }

    return $message;
}
endif;

if ( ! function_exists( 'beautyagency_comments_list' ) ) :
function beautyagency_comments_list($comment, $args, $depth)
{
    $GLOBALS['comment'] = $comment; ?>
    <li>

    <div id="comment-<?php comment_ID();?>" class="comment-box animated out" data-animation="fadeInLeft" data-delay="0">

        <?php /** check if this comment author not have approved comments befor this */
        if($comment->comment_approved == '0' ) : ?>
            <em><?php /** print message below */
	            esc_html_e( 'Your comment is awaiting moderation.', 'beautyagency' ); ?></em>
            <br />
        <?php endif; ?>

        <figure>
            <?php echo get_avatar( $comment, 86 ); ?>
        </figure>

        <div class="text">
            <p class="up"><a href="#"><?php comment_author(); ?></a><span><?php comment_date( get_option( 'date_format' ) );?></span></p>
            <?php comment_text(); ?>
            <?php /** check if thread comments are enable then print a reply link */
            comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
        </div>

    </div>

<?php
}
endif;

/**
 * Comments output.
 */
if ( ! function_exists( 'beautyagency_comment_form_fields' ) ) :
    function beautyagency_comment_form_fields( $fields ) {
        $temp = array();
        $output = array();
        foreach ($fields as $name => $value) {
            if ( 'comment' === $name ) {
                $temp = array($name=> $value);
            } else {
                $output[$name] = $value;
            }
        }
        if (!empty ($temp)){
            $output = $output + $temp;
        }
        return $output;
    }
endif;
add_filter( 'comment_form_fields', 'beautyagency_comment_form_fields', 10);

if ( ! function_exists( 'beautyagency_get_gravatar_url' ) ) :
function beautyagency_get_gravatar_url( $email ) {

    $hash = md5( strtolower( trim ( $email ) ) );
    return 'http://gravatar.com/avatar/' . $hash;
}
endif;

if ( ! function_exists( 'beautyagency_wp_title' ) ) :
function beautyagency_wp_title( $title, $sep ) {
    global $paged, $page;

    if ( is_feed() ) {
        return $title;
    }

    // Add the site description for the home/front page.
    $site_description = get_bloginfo( 'description', 'display' );
    if ( $site_description && ( is_home() || is_front_page() ) ) {
        $title = "$title $sep $site_description";
    }

    // Add a page number if necessary.
    if ( $paged >= 2 || $page >= 2 ) {
        $title = "$title $sep " . sprintf( esc_html__( 'Page %s', 'beautyagency' ), max( $paged, $page ) );
    }

    return $title;
}
endif;
add_filter( 'wp_title', 'beautyagency_wp_title', 10, 2 );

if ( ! function_exists( 'beautyagency_plural_text' ) ) :
function beautyagency_plural_text( $amount, $singular, $plural ) {
    if ( $amount == 1 )
        return $amount.' '.$singular;
    else
        return $amount.' '.$plural;
}
endif;
add_filter( 'beautyagency_plural_text', 'beautyagency_plural_text', 10, 3 );

if ( ! function_exists( 'beautyagency_is_frontpage' ) ) :
    function beautyagency_is_frontpage() {
        $is_frontpage = ! empty( $_GET['frontpage'] ) ? true : false;
        if ( is_front_page() ) {
            $is_frontpage = true;
        }

        return $is_frontpage;
    }
endif;


// Logo highlight
if (!function_exists('beautyagency_logo_highlight')) {
    function beautyagency_logo_highlight($str) {
        $has_pattern = preg_match('/([:])\w+/', $str, $highlight_part);
        if ($has_pattern) {
            return preg_replace('/([:])\w+/', '<span>'.substr( $highlight_part[0], 1 ).'</span>', $str);
        } else {
            return $str;
        }

    }
}

// Featured Image Caption
function beautyagency_the_post_thumbnail_caption() {
    global $post;

    $thumbnail_id    = get_post_thumbnail_id($post->ID);
    $thumbnail_image = get_posts(array('p' => $thumbnail_id, 'post_type' => 'attachment'));

    if ($thumbnail_image && isset($thumbnail_image[0])) {
        echo wp_kses($thumbnail_image[0]->post_excerpt, beautyagency_kses_init());
    }
}

/**
 * Simply remove anything that looks like an archive title prefix ("Archive:", "Foo:", "Bar:").
 *
 * @param $title
 * @return mixed
 */
if ( ! function_exists( 'beautyagency_filter_remove_prefix_title' ) ) :
function beautyagency_filter_remove_prefix_title($title) {
    return preg_replace('/^\w+: /', '', $title);
}
endif;
add_filter('get_the_archive_title', 'beautyagency_filter_remove_prefix_title');

/**
 * Demo content on remote hosting
 *
 * @param FW_Ext_Backups_Demo[] $demos
 *
 * @return FW_Ext_Backups_Demo[]
 */
if ( ! function_exists( 'beautyagency_filter_theme_fw_ext_backups_demos' ) ) :
	function beautyagency_filter_theme_fw_ext_backups_demos( $demos ) {

		$demo_version_suffix = '-v' . REMOTE_DEMO_VERSION; // '-v1.0.28'

		// this 'demo-id' should be inserted to remote config file
		// result: 'themedomainname-demo-v1.0.28'
		$demo_id = 'beautyagency-demo' . $demo_version_suffix;

		$demos_array = array(
			$demo_id => array(
				'title'        => esc_html__( 'Beautyagency Demo (Blurred)', 'beautyagency' ),
				'screenshot'   => 'http://webdesign-finder.com/remote-demo-content/beautyagency/demo/screenshot.png',
				'preview_link' => 'http://webdesign-finder.com/beautyagency/',

			),
		);

		// You may request this demo id from this theme author to get a colorized demo content. See the author contacts information.
		$secret_demo_id = REMOTE_DEMO_ID;  // as example: '12345678'

		// this 'demo-id' should be inserted to remote config
		// result: 'themedomainname-demo-colorized-12345678-v1.0.28'
		$demo_id   = 'beautyagency-demo-colorized-' . $secret_demo_id . $demo_version_suffix;


		if ( $secret_demo_id ) {
			$demos_array[$demo_id] = array(
				'title'        => esc_html__('Beautyagency Demo (Colorized)', 'beautyagency'),
				'screenshot'   => 'http://webdesign-finder.com/remote-demo-content/beautyagency/demo/screenshot.png',
				'preview_link' => 'http://webdesign-finder.com/beautyagency/',
			);
		}

		// remote demo URL
		$download_url = 'http://webdesign-finder.com/remote-demo-content/beautyagency/';

		foreach ( $demos_array as $id => $data ) {
			$demo = new FW_Ext_Backups_Demo( $id, 'piecemeal', array(
				'url'     => $download_url,
				'file_id' => $id,
			) );
			$demo->set_title( $data['title'] );
			$demo->set_screenshot( $data['screenshot'] );
			$demo->set_preview_link( $data['preview_link'] );

			$demos[ $demo->get_id() ] = $demo;

			unset( $demo );
		}

		return $demos;
	}
endif;
add_filter( 'fw:ext:backups-demo:demos', 'beautyagency_filter_theme_fw_ext_backups_demos' );