<?php
/**
 * BeautyAgency Customizer functionality
 */


if ( ! function_exists( 'beautyagency_get_theme_mod_defaults' ) ) :
	/**
	 * Return default values for uninitialized theme mods.
	 * https://make.wordpress.org/themes/tag/theme-mods-api/
	 */

	function beautyagency_get_theme_mod_defaults() {
		$defaults = array(
			'header_image'          => 'remove-header',
			'header_logo_big'       => esc_url(get_template_directory_uri()) . '/img/logo.png',
			'header_use_logo'       => '',
			'default_thumbnail'     => esc_url(get_template_directory_uri()) . '/img/default_thumbnail.png',
			'dropcaps_style'        => 1,
			'copyright'             => 'Your copyright goes here.',
			'copyright-2'             => 'Your alternative copyright goes here.',
			'top_email'             => '<a href="mailto:admin@admin.com">admin@admin.com</a>',
			'top_nav_text'          => '(800) 543 4625<span>24/7 free calls</span>',
			'single_post_video'     => '',
			'header_counter'        => '',
			'footer_widgets_layout' => '4',
			'footer_counter'        => '',
			'hide_copyright'        => '',
			'blog_page_view'        => 'list',
			'blog_page_sidebar'     => 'sidebar_right',
			'blog_post_visibility'  => 'excerpt',
			'blog_post_author_bio'  => '',
			'facebook'              => '#',
			'twitter'               => '#',
			'linkedin'              => '#',
			'google-plus'           => '#',
			'main_menu_style'       => 'header1',
			'hide_social_icons'     => '',
			'hide_menu_search'      => '',
			'page_title_404'        => 'Oops, page not found!',
			'page_message_404'      => 'Nothing found. Sorry.',
			'page_image_404'        => esc_url(get_template_directory_uri()) . '/img/404.png',
			'hide_homepage_link'    => '',

			'hide_models_parameters_globally' => false,
		);

		return apply_filters( 'beautyagency_theme_mod_defaults', $defaults );
	}
endif;

if ( ! function_exists( 'beautyagency_get_theme_mods' ) ) :
	function beautyagency_get_theme_mods() {

		return wp_parse_args(
			get_theme_mods(),
			beautyagency_get_theme_mod_defaults()
		);

	}
endif;

if ( ! function_exists( 'beautyagency_custom_customizer' ) ) :
	/**
	 * Adds the individual sections, settings, and controls to the theme customizer
	 */
	function beautyagency_custom_customizer( $wp_customize ) {

		/**
		 * Adds textarea support to the theme customizer
		 */
		class WP_Customize_Textarea_Control extends WP_Customize_Control {
			public $type = 'textarea';

			public function render_content() {
				?>
				<label>
					<span class="customize-control-title"><?php echo esc_attr( strip_tags( $this->label ) ); ?></span>
					<textarea rows="3"
					          style="width:100%;" <?php $this->link(); ?>><?php echo esc_textarea( $this->value() ); ?></textarea>
				</label>
				<?php
			}
		}

		/**
		 * Class to create a custom layout control
		 */
		class  WP_Customize_Layout_Picker_Control extends WP_Customize_Control {
			/**
			 * Render the content on the theme customizer page
			 */
			public function render_content() {
				$finalImageDirectory = esc_url(get_template_directory_uri()) . '/img/';
				?>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="sidebar_none"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>1col.png" alt="Full Width"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="sidebar_left"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>2cl.png" alt="Left Sidebar"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="sidebar_right"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>2cr.png" alt="Right Sidebar"/></label>
				<?php
			}
		}

		/**
		 * Class to create a custom layout control
		 */
		class  WP_Customize_Footer_Widgets_Layout_Picker_Control extends WP_Customize_Control {
			/**
			 * Render the content on the theme customizer page
			 */
			public function render_content() {
				$finalImageDirectory = esc_url(get_template_directory_uri()) . '/img/';
				?>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="none"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>fwnone.png" alt="None"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="1"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>fw1cl.png" alt="1 Column"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="2"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>fw2cl.png" alt="2 Columns"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="3"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>fw3cl.png" alt="3 Columns"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="4"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>fw4cl.png" alt="4 Columns"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="12"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>fw12cl.png" alt="1/2 Columns"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="21"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>fw21cl.png" alt="2/1 Columns"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="112"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>fw112cl.png" alt="1/1/2 Columns"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="121"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>fw121cl.png" alt="1/2/1 Columns"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="211"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>fw211cl.png" alt="2/1/1 Columns"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="13"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>fw13cl.png" alt="1/3 Columns"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="31"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>fw31cl.png" alt="3/1 Columns"/></label>
				<?php
			}
		}

		/**
		 * Class to create a dropcaps select control
		 */
		class  WP_Customize_Dropcaps_Control extends WP_Customize_Control {
			/**
			 * Render the content on the theme customizer page
			 */
			public function render_content() {
				$finalImageDirectory = esc_url(get_template_directory_uri()) . '/img/';
				?>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr($this->id); ?>"
				              name="_customize-radio-<?php echo esc_attr($this->id); ?>" id="<?php echo esc_attr($this->id); ?>" value="1"/><img
						src="<?php echo esc_attr($finalImageDirectory); ?>nodropcaps.png" alt="None"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr($this->id); ?>"
				              name="_customize-radio-<?php echo esc_attr($this->id); ?>" id="<?php echo esc_attr($this->id); ?>" value="2"/><img
						src="<?php echo esc_attr($finalImageDirectory); ?>dropcaps1.png" alt="Dropcaps 1"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr($this->id); ?>"
				              name="_customize-radio-<?php echo esc_attr($this->id); ?>" id="<?php echo esc_attr($this->id); ?>" value="3"/><img
						src="<?php echo esc_attr($finalImageDirectory); ?>dropcaps2.png" alt="Dropcaps 2"/></label>
				<?php
			}
		}

		/**
		 * Class to create a custom video layout control
		 */
		class  WP_Customize_Video_Layout_Picker_Control extends WP_Customize_Control {
			/**
			 * Render the content on the theme customizer page
			 */
			public function render_content() {
				$finalImageDirectory = esc_url(get_template_directory_uri()) . '/img/';
				?>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="default"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>video-default.png" alt="Default"/></label>
				<label><input type="radio" class="layout-picker-control"
				              data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>"
				              name="_customize-radio-<?php echo esc_attr( $this->id ); ?>"
				              id="<?php echo esc_attr( $this->id ); ?>" value="wide"/><img
						src="<?php echo esc_url( $finalImageDirectory ); ?>video-wide.png" alt="Wide"/></label>
				<?php
			}
		}
	}
endif;
add_action( 'customize_register', 'beautyagency_custom_customizer' );


if ( ! function_exists( 'beautyagency_customize_register' ) ) :
	/**
	 * Add postMessage support for site title and description for the Customizer.
	 *
	 * @param WP_Customize_Manager $wp_customize Customizer object.
	 */
	function beautyagency_customize_register( $wp_customize ) {
		$defaults = beautyagency_get_theme_mod_defaults();

		// Change 'Widgets' panel title to 'Edit Layout'
		$wp_customize->add_panel(
			'widgets', array(
				'priority' => 10,
				'title'    => esc_html__( 'Widgets', 'beautyagency' )
			)
		);

		$wp_customize->add_panel( 'site-settings', array(
			'title'       => esc_html__( 'Site Settings', 'beautyagency' ),
			'description' => esc_html__( '', 'beautyagency' ),
		) );

		$wp_customize->add_panel( 'site-styling', array(
			'title'       => esc_html__( 'Styling', 'beautyagency' ),
			'description' => esc_html__( '', 'beautyagency' ),
		) );

		$wp_customize->add_panel( 'menu-settings', array(
			'title'       => esc_html__( 'Menu Settings', 'beautyagency' ),
			'description' => esc_html__( '', 'beautyagency' ),
		) );

		// Add Advertising Settings section.
		$wp_customize->add_section( 'ads_settings', array(
			'title'       => esc_html__( 'Advertising Settings', 'beautyagency' ),
			'priority'    => 900,
			'description' => esc_html__( '', 'beautyagency' ),
			'panel'       => 'site-settings',
		) );

		// E-mail Top
		$wp_customize->add_setting( 'top_email',
			array(
				'default'           => $defaults['top_email'],
				'sanitize_callback' => 'beautyagency_sanitize_text'
			) );

		$wp_customize->add_control( 'top_email',
			array(
				'type'    => 'text',
				'label'   => esc_html__( 'E-mail Top', 'beautyagency' ),
				'section' => 'ads_settings'
			) );

		// After main menu text
		$wp_customize->add_setting( 'top_nav_text',
			array(
				'default'           => $defaults['top_nav_text'],
				'sanitize_callback' => 'beautyagency_sanitize_text'
			) );

		$wp_customize->add_control( 'top_nav_text',
			array(
				'type'    => 'text',
				'label'   => esc_html__( 'Call Us', 'beautyagency' ),
				'section' => 'ads_settings'
			) );

		// Add Footer section.
		$wp_customize->add_section( 'footer_section', array(
			'title'       => esc_html__( 'Footer & Copyright', 'beautyagency' ),
			'priority'    => 999,
			'description' => esc_html__( '', 'beautyagency' ),
			'panel'       => 'site-settings',
		) );

		$wp_customize->add_setting(
			'footer_widgets_layout',
			array(
				'default'           => $defaults['footer_widgets_layout'],
				'sanitize_callback' => 'beautyagency_sanitize_footer_widgets_layout',
			) );

		$wp_customize->add_control( new WP_Customize_Footer_Widgets_Layout_Picker_Control( $wp_customize, 'footer_widgets_layout',
			array(
				'label'   => esc_html__( 'Footer Widgets Layout', 'beautyagency' ),
				'section' => 'footer_section',
			)
		) );

		$wp_customize->add_setting( 'copyright',
			array(
				'default'           => $defaults['copyright'],
				'transport'         => 'postMessage',
				'sanitize_callback' => 'beautyagency_sanitize_text'
			) );

		$wp_customize->add_control( new WP_Customize_Textarea_Control( $wp_customize, 'copyright', array(
			'label'    => esc_html__( 'Copyright', 'beautyagency' ),
			'section'  => 'footer_section',
			'settings' => 'copyright',
		) ) );

		$wp_customize->add_setting( 'copyright-2',
			array(
				'default'           => $defaults['copyright-2'],
				'transport'         => 'postMessage',
				'sanitize_callback' => 'beautyagency_sanitize_text'
			) );

		$wp_customize->add_control( new WP_Customize_Textarea_Control( $wp_customize, 'copyright-2', array(
			'label'    => esc_html__( 'Alternative Copyright', 'beautyagency' ),
			'section'  => 'footer_section',
			'settings' => 'copyright-2',
		) ) );

		$wp_customize->add_setting(
			'hide_copyright',
			array(
				'default'           => $defaults['hide_copyright'],
				'transport'         => 'postMessage',
				'sanitize_callback' => 'beautyagency_sanitize_checkbox'
			)
		);

		$wp_customize->add_control(
			'hide_copyright',
			array(
				'type'    => 'checkbox',
				'label'   => esc_html__( 'Hide copyright text', 'beautyagency' ),
				'section' => 'footer_section',
			)
		);

		// Add Counters section.
		$wp_customize->add_section( 'counters_section', array(
			'title'       => esc_html__( 'Header/Footer Counters', 'beautyagency' ),
			'priority'    => 999,
			'description' => esc_html__( '', 'beautyagency' ),
			'panel'       => 'site-settings',
		) );

		$wp_customize->add_setting( 'header_counter',
			array(
				'default'           => $defaults['header_counter'],
				'transport'         => 'postMessage',
				'sanitize_callback' => 'beautyagency_sanitize_counter'
			) );

		$wp_customize->add_control( new WP_Customize_Textarea_Control( $wp_customize, 'header_counter', array(
			'label'    => esc_html__( 'Header Counter', 'beautyagency' ),
			'section'  => 'counters_section',
			'settings' => 'header_counter',
		) ) );

		$wp_customize->add_setting( 'footer_counter',
			array(
				'default'           => $defaults['footer_counter'],
				'transport'         => 'postMessage',
				'sanitize_callback' => 'beautyagency_sanitize_counter'
			) );

		$wp_customize->add_control( new WP_Customize_Textarea_Control( $wp_customize, 'footer_counter', array(
			'label'    => esc_html__( 'Footer Counter', 'beautyagency' ),
			'section'  => 'counters_section',
			'settings' => 'footer_counter',
		) ) );

		// Add an additional description to the title tagline section.
		$wp_customize->get_section( 'title_tagline' )->title       = esc_html__( 'Logo, Site Title & Tagline', 'beautyagency' );
		$wp_customize->get_section( 'title_tagline' )->description = esc_html__( 'If you\'ve chosen to use logo, you will not have the title and tagline displayed and otherwise.', 'beautyagency' );
		$wp_customize->get_section( 'title_tagline' )->panel       = 'site-settings';

		$wp_customize->add_setting(
			'hide_menu_search', array(
				'default'           => $defaults['hide_menu_search'],
				'transport'         => 'postMessage',
				'sanitize_callback' => 'beautyagency_sanitize_checkbox'
			)
		);

		$wp_customize->add_control(
			'hide_menu_search',
			array(
				'type'    => 'checkbox',
				'label'   => esc_html__( 'Hide Menu Search', 'beautyagency' ),
				'section' => 'title_tagline'
			)
		);

		$wp_customize->add_setting(
			'hide_social_icons', array(
				'default'           => $defaults['hide_social_icons'],
				'transport'         => 'postMessage',
				'sanitize_callback' => 'beautyagency_sanitize_checkbox'
			)
		);

		$wp_customize->add_control(
			'hide_social_icons',
			array(
				'type'    => 'checkbox',
				'label'   => esc_html__( 'Hide Social Icons', 'beautyagency' ),
				'section' => 'title_tagline'
			)
		);

		$wp_customize->get_section( 'static_front_page' )->panel = 'site-settings';

		$wp_customize->get_setting( 'blogname' )->transport        = 'postMessage';
		$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';
		$wp_customize->remove_control( 'display_header_text' );

		// Add use logo checkbox setting and control.
		$wp_customize->add_setting( 'header_use_logo', array(
			'default'           => $defaults['header_use_logo'],
			'sanitize_callback' => 'beautyagency_sanitize_checkbox'
		) );

		$wp_customize->add_control( 'header_use_logo', array(
			'label'   => esc_html__( 'Use Logo', 'beautyagency' ),
			'section' => 'title_tagline',
			'type'    => 'checkbox',
		) );

		// Add 'Hide Models Parameters (globally)' checkbox setting and control.
		$wp_customize->add_setting( 'hide_models_parameters_globally', array(
			'default'           => $defaults['hide_models_parameters_globally'],
			'sanitize_callback' => 'beautyagency_sanitize_checkbox'
		) );
		$wp_customize->add_control( 'hide_models_parameters_globally', array(
			'label'   => esc_html__( 'Hide Models Parameters (globally)', 'beautyagency' ),
			'section' => 'title_tagline',
			'type'    => 'checkbox',
		) );

		// Add header big logo setting and control.
		$wp_customize->add_setting( 'header_logo_big', array(
			'default'           => $defaults['header_logo_big'],
			'sanitize_callback' => 'esc_url_raw'
		) );

		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'header_logo_big', array(
			'label'       => esc_html__( 'Header logo', 'beautyagency' ),
			'description' => esc_html__( 'Upload the logo w=400px h=100px', 'beautyagency' ),
			'section'     => 'title_tagline',
		) ) );

		// Clean Wordpress Customize Defaults
		$wp_customize->remove_section( 'colors' );
		$wp_customize->remove_section( 'header_image' );
		$wp_customize->remove_section( 'background_image' );


		// Add Default Thumbnail section.
		$wp_customize->add_section( 'thumbnail_section', array(
			'title'       => esc_html__( 'Default Thumbnail', 'beautyagency' ),
			'priority'    => 999,
			'description' => esc_html__( '', 'beautyagency' ),
			'panel'       => 'site-styling',
		) );

		$wp_customize->add_setting( 'default_thumbnail',
			array(
				'default'           => $defaults['default_thumbnail'],
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_url_raw'
			) );

		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'default_thumbnail', array(
			'label'    => esc_html__( 'Default Thumbnail', 'beautyagency' ),
			'section'  => 'thumbnail_section',
			'settings' => 'default_thumbnail',
		) ) );

		// Add Single Post Settings option.
		$wp_customize->add_section( 'single_post', array(
			'title'       => esc_html__( 'Single Post Settings', 'beautyagency' ),
			'priority'    => 999,
			'description' => esc_html__( '', 'beautyagency' ),
			'panel'       => 'site-styling',
		) );

		$wp_customize->add_setting(
			'single_post_video',
			array(
				'default'           => $defaults['single_post_video'],
				'sanitize_callback' => 'beautyagency_sanitize_single_post_video',
			)
		);

		$wp_customize->add_control( new WP_Customize_Video_Layout_Picker_Control( $wp_customize, 'single_post_video',
			array(
				'label'   => esc_html__( 'Single Post Video', 'beautyagency' ),
				'section' => 'single_post',
			)
		) );

		// Add Dropcaps section.
		$wp_customize->add_section( 'dropcaps', array(
			'title'       => esc_html__( 'Dropcaps', 'beautyagency' ),
			'priority'    => 999,
			'description' => esc_html__( '', 'beautyagency' ),
			'panel'       => 'site-styling',
		) );

		$wp_customize->add_setting(
			'dropcaps_style',
			array(
				'default'           => $defaults['dropcaps_style'],
				'sanitize_callback' => 'beautyagency_sanitize_dropcaps',
			)
		);

		$wp_customize->add_control( new WP_Customize_Dropcaps_Control( $wp_customize, 'dropcaps_style',
			array(
				'label'   => esc_html__( 'Dropcaps Style', 'beautyagency' ),
				'section' => 'dropcaps',
			)
		) );

		// Add Blog Page Settings section.
		$wp_customize->add_section( 'blog_page', array(
			'title'       => esc_html__( 'Blog Page Settings', 'beautyagency' ),
			'priority'    => 900,
			'description' => esc_html__( '', 'beautyagency' ),
		) );

		$wp_customize->add_setting(
			'blog_page_sidebar',
			array(
				'default'           => $defaults['blog_page_sidebar'],
				'sanitize_callback' => 'beautyagency_sanitize_sidebar',
			)
		);

		$wp_customize->add_control( new WP_Customize_Layout_Picker_Control( $wp_customize, 'blog_page_sidebar',
			array(
				'label'   => esc_html__( 'Blog Sidebar', 'beautyagency' ),
				'section' => 'blog_page',
			)
		) );
		if ( ! beautyagency_is_unyson_page_builder_for_post_type() ) {
			$wp_customize->add_setting(
				'blog_post_visibility',
				array(
					'default'           => $defaults['blog_post_visibility'],
					'sanitize_callback' => 'beautyagency_sanitize_post_visibility',
				)
			);

			$wp_customize->add_control(
				'blog_post_visibility',
				array(
					'type'    => 'radio',
					'label'   => esc_html__( 'Blog Post Visibility', 'beautyagency' ),
					'section' => 'blog_page',
					'choices' => array(
						'excerpt' => esc_html__( 'Excerpt (55 words)', 'beautyagency' ),
						'content' => esc_html__( 'Full Content', 'beautyagency' ),
					),
				)
			);
		}

		// Post page author bio (enable/disable)
		$wp_customize->add_setting(
			'blog_post_author_bio',
			array(
				'default'           => $defaults['blog_post_author_bio'],
				'sanitize_callback' => 'beautyagency_sanitize_post_author_bio',
			)
		);

		$wp_customize->add_control(
			'blog_post_author_bio',
			array(
				'type'    => 'radio',
				'label'   => esc_html__( 'Post page author bio', 'beautyagency' ),
				'section' => 'blog_page',
				'choices' => array(
					'author_bio_on'  => esc_html__( 'On', 'beautyagency' ),
					'author_bio_off' => esc_html__( 'Off', 'beautyagency' ),
				),
			)
		);

		// Add 404 Page Settings section.
		$wp_customize->add_section( 'page_404', array(
			'title'       => esc_html__( '404 Page Settings', 'beautyagency' ),
			'priority'    => 900,
			'description' => esc_html__( '', 'beautyagency' ),
		) );

		$wp_customize->add_setting(
			'page_title_404',
			array(
				'default'           => $defaults['page_title_404'],
				'transport'         => 'postMessage',
				'sanitize_callback' => 'beautyagency_sanitize_text'
			)
		);

		$wp_customize->add_control(
			'page_title_404',
			array(
				'type'    => 'text',
				'label'   => esc_html__( 'Title', 'beautyagency' ),
				'section' => 'page_404',
			)
		);

		$wp_customize->add_setting( 'page_message_404',
			array(
				'default'           => $defaults['page_message_404'],
				'transport'         => 'postMessage',
				'sanitize_callback' => 'beautyagency_sanitize_text'
			) );

		$wp_customize->add_control( new WP_Customize_Textarea_Control( $wp_customize, 'page_message_404', array(
			'label'    => esc_html__( 'Page Message', 'beautyagency' ),
			'section'  => 'page_404',
			'settings' => 'page_message_404',
		) ) );

		$wp_customize->add_setting( 'page_image_404', array(
			'default'           => $defaults['page_image_404'],
			'sanitize_callback' => 'esc_url_raw'
		) );

		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'page_image_404', array(
			'label'       => esc_html__( '404 Image', 'beautyagency' ),
			'description' => esc_html__( '', 'beautyagency' ),
			'section'     => 'page_404',
		) ) );

		$wp_customize->add_setting(
			'hide_homepage_link', array(
				'default'           => $defaults['hide_homepage_link'],
				'transport'         => 'postMessage',
				'sanitize_callback' => 'beautyagency_sanitize_checkbox'
			)
		);

		$wp_customize->add_control(
			'hide_homepage_link',
			array(
				'type'    => 'checkbox',
				'label'   => esc_html__( 'Hide Homepage Link', 'beautyagency' ),
				'section' => 'page_404',
			)
		);
	}
endif;
add_action( 'customize_register', 'beautyagency_customize_register', 11 );

if ( ! function_exists( 'beautyagency_social_media_array' ) ) :
	function beautyagency_social_media_array() {

		// store social site names in array
		$social_sites = array( 'facebook', 'twitter', 'linkedin', 'google-plus' );

		return $social_sites;
	}
endif;
add_action( 'customize_register', 'beautyagency_social_sites_customizer', 12 );

if ( ! function_exists( 'beautyagency_social_sites_customizer' ) ) :
	function beautyagency_social_sites_customizer( $wp_customize ) {
		$wp_customize->add_section( 'social_settings', array(
			'title'    => 'Share Post Socials',
			'priority' => 835,
		) );

		$priority = 5;

		$social_sites = beautyagency_social_media_array();

		foreach ( $social_sites as $social_site ) {

			$priority = $priority + 5;

			$wp_customize->add_setting( "$social_site", array(
				'type'              => 'theme_mod',
				'capability'        => 'edit_theme_options',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'beautyagency_sanitize_checkbox'
			) );

			$wp_customize->add_control( $social_site, array(
				'label'    => "$social_site",
				'section'  => 'social_settings',
				'type'     => 'checkbox',
				'priority' => $priority,
			) );

		}
	}
endif;


if ( ! function_exists( 'beautyagency_sanitize_checkbox' ) ) :
	/**
	 * Sanitization callback for checkboxes.
	 */
	function beautyagency_sanitize_checkbox( $value ) {
		if ( $value == 1 ) {
			return 1;
		} else {
			return '';
		}
	}
endif; // beautyagency_sanitize_checkbox

if ( ! function_exists( 'beautyagency_sanitize_text' ) ) :
	/**
	 * Sanitization callback for text.
	 *
	 * @param string $value text.
	 *
	 * @return string with allowed html tags only.
	 */
	function beautyagency_sanitize_text( $value ) {

		return wp_kses_post( $value );

	}
endif; // beautyagency_sanitize_text.

if ( ! function_exists( 'beautyagency_sanitize_counter' ) ) :
	/**
	 * Sanitization callback for counters.
	 *
	 * @param string $value html.
	 *
	 * @return string with html tags.
	 */
	function beautyagency_sanitize_counter( $value ) {

		return $value;

	}
endif; // beautyagency_sanitize_counter.

if ( ! function_exists( 'beautyagency_sanitize_single_post_video' ) ) :
	/**
	 * Sanitization callback for single post video position.
	 *
	 * @param string $value sidebar position.
	 *
	 * @return string with sidebar position.
	 */
	function beautyagency_sanitize_single_post_video( $value ) {
		$valid = array(
			'default' => 'Default',
			'wide'    => 'Wide',
		);

		if ( array_key_exists( $value, $valid ) ) {
			return $value;
		} else {
			return 'default';
		}
	}

endif; // beautyagency_sanitize_single_post_video.


if ( ! function_exists( 'beautyagency_sanitize_sidebar' ) ) :
	/**
	 * Sanitization callback for sidebar position.
	 *
	 * @param string $value sidebar position.
	 *
	 * @return string with sidebar position.
	 */
	function beautyagency_sanitize_sidebar( $value ) {
		$valid = array(
			'sidebar_left'  => 'Left',
			'sidebar_right' => 'Right',
			'sidebar_none'  => 'None',
		);

		if ( array_key_exists( $value, $valid ) ) {
			return $value;
		} else {
			return 'sidebar_right';
		}
	}

endif; // beautyagency_sanitize_sidebar.

if ( ! function_exists( 'beautyagency_sanitize_dropcaps' ) ) :
	/**
	 * Sanitization callback for dropcaps.
	 *
	 * @param string $value dropcaps style.
	 *
	 * @return string with dropcaps style.
	 */
	function beautyagency_sanitize_dropcaps( $value ) {
		$valid = array(
			1 => 'None',
			2 => 'Dropcaps 1',
			3 => 'Dropcaps 2'
		);

		if ( array_key_exists( $value, $valid ) ) {
			return $value;
		} else {
			return 1;
		}
	}

endif; // beautyagency_sanitize_dropcaps.

if ( ! function_exists( 'beautyagency_sanitize_footer_widgets_layout' ) ) :
	/**
	 * Sanitization callback for footer widgets layout.
	 *
	 * @param string $value widgets layout.
	 *
	 * @return string with widgets layout.
	 */
	function beautyagency_sanitize_footer_widgets_layout( $value ) {
		$valid = array(
			'none' => 'None',
			'1'    => '1-column',
			'2'    => '2-column',
			'3'    => '3-column',
			'4'    => '4-column',
			'12'   => '12-column',
			'21'   => '21-column',
			'112'  => '112-column',
			'121'  => '121-column',
			'211'  => '211-column',
			'13'   => '13-column',
			'31'   => '31-column'
		);

		if ( array_key_exists( $value, $valid ) ) {
			return $value;
		} else {
			return '4';
		}
	}

endif; // beautyagency_sanitize_posts_layout.

if ( ! function_exists( 'beautyagency_sanitize_post_visibility' ) ) :
	/**
	 * Sanitization callback for post visibility.
	 *
	 * @param string $value post visibility.
	 *
	 * @return string with post visibility.
	 */
	function beautyagency_sanitize_post_visibility( $value ) {
		$valid = array(
			'excerpt' => 'Excerpt (55 words)',
			'content' => 'Full Content',
		);

		if ( array_key_exists( $value, $valid ) ) {
			return $value;
		} else {
			return 'excerpt';
		}
	}

endif; // beautyagency_sanitize_post_visibility.


if ( ! function_exists( 'beautyagency_sanitize_post_author_bio' ) ) :
	/**
	 * Sanitization callback for post author bio.
	 */
	function beautyagency_sanitize_post_author_bio( $value ) {
		$valid = array(
			'author_bio_on'  => 'On',
			'author_bio_off' => 'Off',
		);

		if ( array_key_exists( $value, $valid ) ) {
			return $value;
		} else {
			return 'author_bio_on';
		}
	}

endif; // beautyagency_sanitize_post_author_bio.


if ( ! function_exists( 'beautyagency_customize_control_js' ) ) :
	/**
	 * Binds JS listener to make Customizer color_scheme control.
	 */
	function beautyagency_customize_control_js() {
		wp_enqueue_style( 'admin-customize', esc_url(get_template_directory_uri()) . '/css/admin-customize.css' );
	}
endif;
add_action( 'customize_controls_enqueue_scripts', 'beautyagency_customize_control_js' );

if ( ! function_exists( 'beautyagency_customize_preview_js' ) ) :
	/**
	 * Binds JS handlers to make the Customizer preview reload changes asynchronously.
	 */
	function beautyagency_customize_preview_js() {
		wp_enqueue_script( 'beautyagency-customize-preview', esc_url(get_template_directory_uri()) . '/js/customize-preview.js', array( 'customize-preview' ), '20141216', true );
	}
endif;
add_action( 'customize_preview_init', 'beautyagency_customize_preview_js' );


if ( ! function_exists( 'beautyagency_sidebar_class' ) ) :
	/**
	 * CSS Class for blog pages content positioning.
	 *
	 * @param string $doc_part which container.
	 *
	 * @return string $value container class.
	 */
	function beautyagency_sidebar_class( $doc_part ) {
		$theme_options = beautyagency_get_theme_mods();
		if ( ! empty( $_GET["sidebar_position"] ) ) {
			$query_value = esc_attr( $_GET["sidebar_position"] );
		}
		if ( isset( $query_value ) && in_array( $query_value, array(
				"sidebar_left",
				"sidebar_right",
				"sidebar_none"
			) )
		) {
			$blog_page_sidebar = $query_value;
		} else {
			$blog_page_sidebar = $theme_options['blog_page_sidebar'];
		}

		if ( ! empty ( $GLOBALS['wp_customize'] ) ) {
			global $wp_customize;
			$post_values = $wp_customize->unsanitized_post_values();
			if ( ! empty( $post_values['blog_page_sidebar'] ) ) {
				$blog_page_sidebar = $post_values['blog_page_sidebar'];
			}
		}

		$value = "";

		if ( $doc_part == "container" ) {
			switch ( $blog_page_sidebar ) {
				case "sidebar_left":
					$value = "sidebar_left";
					break;
				case "sidebar_right":
					$value = "sidebar_right";
					break;
				case "sidebar_none":
					$value = "sidebar_none";
					break;
				default:
					break;
			}
		}

		if ( ( beautyagency_check_use_unyson() || is_page() ) && ! beautyagency_is_page_show_sidebar() ) {
			if ( $doc_part == "content" ) {
				switch ( $blog_page_sidebar ) {
					case "sidebar_left":
						$value = "col-xs-12 site__content full_width_content";
						break;
					case "sidebar_right":
						$value = "col-xs-12 site__content full_width_content";
						break;
					case "sidebar_none":
						$value = "col-xs-12 site__content full_width_content";
						break;
					default:
						break;
				}
			}
		} else {
			if ( $doc_part == "content" ) {
				switch ( $blog_page_sidebar ) {
					case "sidebar_left":
						$value = "col-md-8 col-md-push-4 col-sm-12 site__content";
						break;
					case "sidebar_right":
						$value = "col-md-8 col-sm-12 site__content";
						break;
					case "sidebar_none":
						$value = "col-xs-12 site__content";
						break;
					default:
						break;
				}
				if ( function_exists('ccm_is_single_profile') && ccm_is_single_profile() && ccm_is_profile() ) {
					$value = "col-xs-12 site__content";
				}
			}

			if ( $doc_part == "sidebar" ) {
				switch ( $blog_page_sidebar ) {
					case "sidebar_left":
						$value = "col-md-4 col-md-pull-8 col-sm-12 sidebar-visible sidebar_left widget-width__side site__sidebar";
						break;
					case "sidebar_right":
						$value = "col-md-4 col-sm-12 sidebar-visible sidebar_right widget-width__side site__sidebar";
						break;
					default:
						break;
				}
			}
		}

		return esc_attr( $value );
	}
endif; // beautyagency_sidebar_class

if ( ! function_exists( 'beautyagency_sidebar_visible' ) ) :
	/**
	 * Check if sidebar should be displayed.
	 *
	 * @return bool $value.
	 */
	function beautyagency_sidebar_visible() {

		$blog_page_sidebar = beautyagency_get_customizer_option( 'blog_page_sidebar' );

		if ( $blog_page_sidebar == "sidebar_none" ) {
			return false;
		}

		return true;
	}
endif; // beautyagency_sidebar_visible

if ( ! function_exists( 'beautyagency_is_blog_view_excerpt' ) ) :
	function beautyagency_is_blog_view_excerpt() {
		if ( ! beautyagency_is_unyson_page_builder_for_post_type() ) {
			$theme_options = beautyagency_get_theme_mods();

			if ( ! empty ( $GLOBALS['wp_customize'] ) ) {
				global $wp_customize;
				$post_values = $wp_customize->unsanitized_post_values();
				if ( ! empty( $post_values['blog_post_visibility'] ) ) {
					if ( $post_values['blog_post_visibility'] == 'excerpt' ) {
						return true;
					} else {
						return false;
					}
				} elseif ( ! empty( $theme_options['blog_post_visibility'] ) && $theme_options['blog_post_visibility'] == 'excerpt' ) {
					return true;
				}
			} elseif ( ! empty( $theme_options['blog_post_visibility'] ) && $theme_options['blog_post_visibility'] == 'excerpt' ) {
				return true;
			}

			return false;
		}
	}
endif;

if ( ! function_exists( 'beautyagency_header_counter' ) ) :
	function beautyagency_header_counter() {
		echo beautyagency_get_customizer_option( 'header_counter' );
	}
endif; // beautyagency_header_counter
add_action( 'wp_head', 'beautyagency_header_counter', 9999 );

if ( ! function_exists( 'beautyagency_footer_counter' ) ) :
	function beautyagency_footer_counter() {
		echo beautyagency_get_customizer_option( 'footer_counter' );
	}
endif; // beautyagency_footer_counter
add_action( 'wp_footer', 'beautyagency_footer_counter', 9999 );

if ( ! function_exists( 'beautyagency_get_customizer_option' ) ) :
	function beautyagency_get_customizer_option( $option_name ) {
		if ( ! $option_name ) {
			return 'no_option';
		}

		$theme_options = beautyagency_get_theme_mods();
		$option_value  = $theme_options[ $option_name ];

		if ( ! empty ( $GLOBALS['wp_customize'] ) ) {
			global $wp_customize;
			$post_values = $wp_customize->unsanitized_post_values();
			if ( ! empty( $post_values[ $option_name ] ) || ( isset( $post_values[ $option_name ] ) && $post_values[ $option_name ] === '' ) ) {
				$option_value = $post_values[ $option_name ];
			}
		}

		return $option_value;
	}
endif; // beautyagency_get_customizer_option

if ( ! function_exists( 'beautyagency_is_unyson_page_builder_for_post_type' ) ) :
	function beautyagency_is_unyson_page_builder_for_post_type( $post_type = 'post' ) {
		$use_posts_builder = false;
		if ( defined( 'FW' ) && fw_ext( 'page-builder' ) ) {
			$builder_options = fw_ext( 'page-builder' )->get_db_settings_option();
			if ( isset( $builder_options['post_types'][ $post_type ] ) ) {
				$use_posts_builder = $builder_options['post_types'][ $post_type ];
			}
		}

		return $use_posts_builder;
	}
endif; // beautyagency_is_unyson_page_builder_for_post_type