<?php
/**
 * Custom Header functionality for BeautyAgency
 */

if ( ! function_exists( 'beautyagency_custom_header_setup' ) ) :
	/**
	 * Set up the WordPress core custom header feature.
	 *
	 * @uses beautyagency_header_style()
	 */
	function beautyagency_custom_header_setup() {

		/**
		 * Filter BeautyAgency custom-header support arguments.
		 *
		 * @param array $args {
		 *     An array of custom-header support arguments.
		 *
		 * @type string $default_text_color Default color of the header text.
		 * @type int $width Width in pixels of the custom header image. Default 954.
		 * @type int $height Height in pixels of the custom header image. Default 1300.
		 * @type string $wp -head-callback       Callback function used to styles the header image and text
		 *                                          displayed on the blog.
		 * }
		 */
		add_theme_support( 'custom-header', apply_filters( 'beautyagency_custom_header_args', array(
			'width'            => 2600,
			'height'           => 238,
			'wp-head-callback' => 'beautyagency_header_style',
		) ) );
	}
endif;
add_action( 'after_setup_theme', 'beautyagency_custom_header_setup' );


if ( ! function_exists( 'beautyagency_header_style' ) ) :
	/**
	 * Styles the header image and text displayed on the blog.
	 *
	 * @see beautyagency_custom_header_setup()
	 */
	function beautyagency_header_style() {
		$header_image = get_header_image();

		// If no custom options for text are set, let's bail.
		if ( empty( $header_image ) && display_header_text() ) {
			return;
		}

		// If we get this far, we have custom styles. Let's do this.
		?>
		<style type="text/css" id="beautyagency-header-css">
			<?php
				// Has a Custom Header been added?
				if ( ! empty( $header_image ) ) :
			?>
			div.logo-bar {
				background: url(<?php header_image(); ?>) no-repeat 50% 50%;
				-webkit-background-size: cover;
				-moz-background-size: cover;
				-o-background-size: cover;
				background-size: cover;
			}

			<?php endif; ?>
		</style>
		<?php
	}
endif; // beautyagency_header_style