<?php
/**
 * BeautyAgency back compat functionality
 *
 * Prevents BeautyAgency from running on WordPress versions prior to 4.1,
 * since this theme is not meant to be backward compatible beyond that and
 * relies on many newer functions and markup changes introduced in 4.1.
 */

if ( ! function_exists( 'beautyagency_switch_theme' ) ) :
/**
 * Prevent switching to BeautyAgency on old versions of WordPress.
 *
 * Switches to the default theme.
 */
function beautyagency_switch_theme() {
	switch_theme( WP_DEFAULT_THEME, WP_DEFAULT_THEME );
	unset( $_GET['activated'] );
	add_action( 'admin_notices', 'beautyagency_upgrade_notice' );
}
endif;
add_action( 'after_switch_theme', 'beautyagency_switch_theme' );

if ( ! function_exists( 'beautyagency_upgrade_notice' ) ) :
/**
 * Add message for unsuccessful theme switch.
 *
 * Prints an update nag after an unsuccessful attempt to switch to
 * BeautyAgency on WordPress versions prior to 4.1.
 */
function beautyagency_upgrade_notice() {
	$message = sprintf( esc_html__( 'BeautyAgency requires at least WordPress version 4.1. You are running version %s. Please upgrade and try again.', 'beautyagency' ), $GLOBALS['wp_version'] );
	printf( '<div class="error"><p>%s</p></div>', $message );
}
endif;

if ( ! function_exists( 'beautyagency_customize' ) ) :
/**
 * Prevent the Customizer from being loaded on WordPress versions prior to 4.1.
 */
function beautyagency_customize() {
	wp_die( sprintf( esc_html__( 'BeautyAgency requires at least WordPress version 4.1. You are running version %s. Please upgrade and try again.', 'beautyagency' ), $GLOBALS['wp_version'] ), '', array(
		'back_link' => true,
	) );
}
endif;
add_action( 'load-customize.php', 'beautyagency_customize' );

if ( ! function_exists( 'beautyagency_preview' ) ) :
/**
 * Prevent the Theme Preview from being loaded on WordPress versions prior to 4.1.
 */
function beautyagency_preview() {
	if ( isset( $_GET['preview'] ) ) {
		wp_die( sprintf( esc_html__( 'BeautyAgency requires at least WordPress version 4.1. You are running version %s. Please upgrade and try again.', 'beautyagency' ), $GLOBALS['wp_version'] ) );
	}
}
endif;
add_action( 'template_redirect', 'beautyagency_preview' );