<?php
/**
 * The template for displaying image attachments
 */

get_header( 'page' ); ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main">

		<div class="container-fluid post-container">
			<div class="row site__row">
				<div class=" site__content">

					<?php
					// Start the loop.
					while ( have_posts() ) : the_post();
						?>

						<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

							<nav id="image-navigation" class="navigation image-navigation">
								<div class="nav-links">
									<div
										class="nav-previous"><?php previous_image_link( false, esc_html__( 'Previous Image', 'beautyagency' ) ); ?></div>
									<div
										class="nav-next"><?php next_image_link( false, esc_html__( 'Next Image', 'beautyagency' ) ); ?></div>
								</div><!-- .nav-links -->
							</nav><!-- .image-navigation -->

							<header class="entry-header">
								<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
							</header><!-- .entry-header -->

							<div class="entry-content">

								<div class="entry-attachment">
									<?php
									/**
									 * Filter the default image attachment size.
									 *
									 * @param string $image_size Image size. Default 'large'.
									 */
									$image_size = apply_filters( 'beautyagency_attachment_size', 'large' );

									echo wp_get_attachment_image( get_the_ID(), $image_size );
									?>

									<?php if ( has_excerpt() ) : ?>
										<div class="entry-caption">
											<?php the_excerpt(); ?>
										</div><!-- .entry-caption -->
									<?php endif; ?>

								</div><!-- .entry-attachment -->

								<?php
								the_content();
								wp_link_pages( array(
									'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'beautyagency' ) . '</span>',
									'after'       => '</div>',
									'link_before' => '<span>',
									'link_after'  => '</span>',
									'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'beautyagency' ) . ' </span>%',
									'separator'   => '<span class="screen-reader-text">, </span>',
								) );
								?>
							</div><!-- .entry-content -->

							<?php if ( is_user_logged_in() ) { ?>
							<footer class="entry-footer">
								<div class="clearboth">&nbsp;</div>
								<?php edit_post_link( esc_html__( 'Edit', 'beautyagency' ), '<span class="edit-link">', '</span>' ); ?>
							</footer>
							<?php } ?><!-- .entry-footer -->

						</article><!-- #post-## -->

						<?php
						// If comments are open or we have at least one comment, load up the comment template
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;

						// Previous/next post navigation.
						the_post_navigation( array(
							'prev_text' => wp_kses( _x( '<span class="meta-nav">Published in</span><span class="post-title">%title</span>', 'Parent post link', 'beautyagency' ), beautyagency_kses_init() ),
						) );

						// End the loop.
					endwhile;
					?>

				</div>
			</div>
		</div>

	</main><!-- .site-main -->
</div><!-- .content-area -->

<?php get_footer(); ?>
