<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 */

$theme_options = beautyagency_get_theme_mods();
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php echo esc_html( get_bloginfo( 'charset', 'display' ) ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="<?php echo esc_url( 'http://gmpg.org/xfn/11' ); ?>">
	<link rel="pingback" href="<?php echo esc_url( get_bloginfo( 'pingback_url', 'display' ) ); ?>">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<!-- PRELOADER -->
<div id="preloader">
	<div id="loader"></div>
</div>
<!-- /PRELOADER -->
<div class="search-box-overlay"></div>
<?php
$page_header = get_theme_mod( 'main_menu_style', 'header1' );
beautyagency_print_header( $page_header, $theme_options );
if ( is_front_page()) {
	do_action( 'beautyagency_after_header' );
}
?>
<?php
$check_use_unyson = null;
if ( beautyagency_check_use_unyson() == true ) {
	$check_use_unyson = 'page-builder';
}
?>
<div id="page" class="hfeed site <?php echo esc_attr( $check_use_unyson ); ?>">
	<a class="skip-link screen-reader-text"
	   href="#content"><?php esc_html_e( 'Skip to content', 'beautyagency' ); ?></a>

	<div id="content" class="site-content">
<?php
if ( is_front_page() && ! is_home() || beautyagency_check_use_unyson() ) {
	echo '';
} else {
	do_action( 'beautyagency_before_content' );
}
?>