<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 */

$theme_options = beautyagency_get_theme_mods();

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php echo esc_html( get_bloginfo( 'charset', 'display' ) ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="<?php echo esc_url( 'http://gmpg.org/xfn/11' ); ?>">
	<link rel="pingback" href="<?php echo esc_url( get_bloginfo( 'pingback_url', 'display' ) ); ?>">

	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<!-- PRELOADER -->
<div id="preloader">
	<div id="loader"></div>
</div>
<!-- /PRELOADER -->
<div class="search-box-overlay"></div>
<?php
$page_header = get_theme_mod( 'main_menu_style', 'header2' );
beautyagency_print_header( $page_header, $theme_options );
if ( is_home() ) {
	do_action( 'beautyagency_after_header' );
}
?>
<!-- Unyson Checking -->
<?php
$check_use_unyson = false;
if ( beautyagency_check_use_unyson() == true ) {
	$check_use_unyson = 'page-builder';
}
?>
<?php // Post Wide Video
$theme_options  = beautyagency_get_theme_mods();
$video_position = $theme_options['single_post_video'];

if ( ! empty ( $GLOBALS['wp_customize'] ) ) {
	global $wp_customize;
	$post_values = $wp_customize->unsanitized_post_values();
	if ( ! empty( $post_values['single_post_video'] ) ) {
		$video_position = $post_values['single_post_video'];
	}
}

$media = beautyagency_parse_media( get_post_field( 'post_content', get_the_ID() ) );
if ( empty ( $media ) ) {
	//
} else {
	// Post video.
	echo '<div class="post__media_wide">';
	echo '<div class="container">';
	if ( is_single() && ( $video_position == 'wide' ) && get_post_format() == 'video' ) {
		echo beautyagency_parse_media( get_post_field( 'post_content', get_the_ID() ) );
	}
	echo '</div><!-- /class="container" -->';
	echo '</div>';
}
?>

<div id="page" class="hfeed site <?php echo esc_attr( $check_use_unyson ); ?>">
	<a class="skip-link screen-reader-text"
	   href="#content"><?php esc_html_e( 'Skip to content', 'beautyagency' ); ?></a>

	<div id="content" class="site-content">
<?php
if ( beautyagency_check_use_unyson() && ! beautyagency_is_page_show_sidebar() || (function_exists('ccm_is_profile_archive') && ( ccm_is_category() || ccm_is_profile_archive() )) || beautyagency_check_use_unyson_portfolio() && ! is_single() ) {
	echo '';
} else {
	do_action( 'beautyagency_before_content' );
}
?>