<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'title'    => array(
		'type'  => 'text',
		'label' => esc_html__( 'Heading Title', 'beautyagency' ),
		'desc'  => esc_html__( 'Write the heading title content', 'beautyagency' ),
	),
	'heading' => array(
		'type'    => 'select',
		'label'   => esc_html__('Heading Size', 'beautyagency'),
		'choices' => array(
            'h1' => 'H1',
            'h2' => 'H2',
            'h3' => 'H3',
            'h4' => 'H4',
            'h5' => 'H5',
            'h6' => 'H6',
            'p' => 'p',
            'special1' => 'Special title 1',
            'special2' => 'Special title 2',
        )
	),
    'font_weight' => array(
        'type'  => 'select',
        'label' => esc_html__( 'Font Weight', 'beautyagency' ),
        'choices' => array(
	        '100' => 'Thin',
	        '300' => 'Light',
	        '400' => 'Normal',
	        '600' => 'Semi Bold',
	        '900' => 'Heavy',
        )
    ),
    'text_color' => array(
        'label' => esc_html__('Title Text Color', 'beautyagency'),
        'desc'  => esc_html__('Please select the text color', 'beautyagency'),
	    'value' => '#ffffff',
        'type'  => 'color-picker',
    ),
	'subtitle' => array(
		'type'  => 'text',
		'label' => esc_html__( 'Heading Subtitle', 'beautyagency' ),
		'desc'  => esc_html__( 'Write the heading subtitle content', 'beautyagency' ),
	),
	'subtitle_style' => array(
		'type'  => 'typography',
		'value' => array(
			'family' => 'Roboto',
			'size'   => 20,
			'style'  => '300',
			'color'  => '#c0c0c0'
		),
		'components' => array(
			'family' => true,
			'size'   => true,
			'line-height' => true,
			'color'  => true
		),
		'label' => esc_html__('Subtitle typography', 'beautyagency'),
		'desc'  => esc_html__('Set subtitle styling (Works with: H1, H2, H3, H4, H5, H6, p)', 'beautyagency'),
	),
	'centered' => array(
		'type'    => 'switch',
		'label'   => esc_html__('Centered', 'beautyagency'),
	)
);
