<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'image'            => array(
		'type'  => 'upload',
		'label' => esc_html__( 'Choose Image', 'beautyagency' ),
		'desc'  => esc_html__( 'Either upload a new, or choose an existing image from your media library', 'beautyagency' )
	),
	'caption'   => array(
		'type'  => 'text',
		'label' => esc_html__( 'Image Caption', 'beautyagency' ),
		'desc'  => esc_html__( 'Description of the image, maybe author info.', 'beautyagency' )
	),
	'size'             => array(
		'type'    => 'group',
		'options' => array(
			'width'  => array(
				'type'  => 'text',
				'label' => esc_html__( 'Width', 'beautyagency' ),
				'desc'  => esc_html__( 'Set image width', 'beautyagency' ),
				'value' => 300
			),
			'height' => array(
				'type'  => 'text',
				'label' => esc_html__( 'Height', 'beautyagency' ),
				'desc'  => esc_html__( 'Set image height', 'beautyagency' ),
				'value' => 200
			)
		)
	),
	'image-link-group' => array(
		'type'    => 'group',
		'options' => array(
			'link'   => array(
				'type'  => 'text',
				'label' => esc_html__( 'Image Link', 'beautyagency' ),
				'desc'  => esc_html__( 'Where should your image link to?', 'beautyagency' )
			),
			'target' => array(
				'type'         => 'switch',
				'label'        => esc_html__( 'Open Link in New Window', 'beautyagency' ),
				'desc'         => esc_html__( 'Select here if you want to open the linked page in a new window', 'beautyagency' ),
				'right-choice' => array(
					'value' => '_blank',
					'label' => esc_html__( 'Yes', 'beautyagency' ),
				),
				'left-choice'  => array(
					'value' => '_self',
					'label' => esc_html__( 'No', 'beautyagency' ),
				),
			),
		)
	)
);