<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$map_shortcode = fw_ext('shortcodes')->get_shortcode('map');
$options = array(
	'data_provider' => array(
		'type'  => 'multi-picker',
		'label' => false,
		'desc'  => false,
		'picker' => array(
			'population_method' => array(
				'label'   => __('Population Method', 'beautyagency'),
				'desc'    => __( 'Select map population method (Ex: events, custom)', 'beautyagency' ),
				'type'    => 'select',
				'choices' => $map_shortcode->_get_picker_dropdown_choices(),
			)
		),
		'choices' => $map_shortcode->_get_picker_choices(),
		'show_borders' => false,
	),
	'gmap-key' => array_merge(
		array(
			'label' => __( 'Goolge Maps API Key', 'beautyagency' ),
			'desc' => sprintf(
				__( 'Create an application in %sGoogle Console%s and add the Key here.', 'beautyagency' ),
				'<a href="https://console.developers.google.com/flows/enableapi?apiid=places_backend,maps_backend,geocoding_backend,directions_backend,distance_matrix_backend,elevation_backend&keyType=CLIENT_SIDE&reusekey=true">',
				'</a>'
			),
		),
		version_compare(fw()->manifest->get_version(), '2.5.7', '>=')
		? array(
			'type' => 'gmap-key',
		)
		: array(
			'type' => 'text',
			'fw-storage' => array(
				'type'      => 'wp-option',
				'wp_option' => 'fw-option-types:gmap-key',
			),
		)
	),
	'map_type' => array(
		'type'  => 'select',
		'label' => __('Map Type', 'beautyagency'),
		'desc'  => __('Select map type', 'beautyagency'),
		'choices' => array(
			'roadmap'   => __('Roadmap', 'beautyagency'),
			'terrain' => __('Terrain', 'beautyagency'),
			'satellite' => __('Satellite', 'beautyagency'),
			'hybrid'    => __('Hybrid', 'beautyagency')
		)
	),
	'map_pin'         => array(
		'label' => __( 'Map Pin', 'beautyagency' ),
		'desc'  => __( 'Upload a pin for your location(s) (64x64)', 'beautyagency' ),
		'type'  => 'upload',
	),
	'map_height' => array(
		'label' => __('Map Height', 'beautyagency'),
		'desc'  => __('Set map height (Ex: 300)', 'beautyagency'),
		'type'  => 'text'
	),
	'disable_scrolling' => array(
		'type'  => 'switch',
		'value' => false,
		'label' => __('Disable zoom on scroll', 'beautyagency'),
		'desc'  => __('Prevent the map from zooming when scrolling until clicking on the map', 'beautyagency'),
		'left-choice' => array(
			'value' => false,
			'label' => __('Yes', 'beautyagency'),
		),
		'right-choice' => array(
			'value' => true,
			'label' => __('No', 'beautyagency'),
		),
	),
);