<?php
get_header( 'page' );
global $wp_query;
$ext_portfolio_instance = fw()->extensions->get( 'portfolio' );
$ext_portfolio_settings = $ext_portfolio_instance->get_settings();

$taxonomy   = $ext_portfolio_settings['taxonomy_name'];
$term       = get_term_by( 'slug', get_query_var( 'term' ), $taxonomy );
$term_id    = ( ! empty( $term->term_id ) ) ? $term->term_id : 0;
$categories = fw_ext_portfolio_get_listing_categories( $term_id );

$portfolio_layout = fw_get_db_customizer_option( 'portfolio_layout_section' );

$listing_classes = fw_ext_portfolio_get_sort_classes( $wp_query->posts, $categories );
$loop_data       = array(
	'settings'        => $ext_portfolio_instance->get_settings(),
	'categories'      => $categories,
	'image_sizes'     => $ext_portfolio_instance->get_image_sizes(),
	'listing_classes' => $listing_classes
);
set_query_var( 'fw_portfolio_loop_data', $loop_data );
?>
	<div id="primary" class="content-area <?php
	if ( $portfolio_layout == 'portfolio_regular' ) {
		echo 'portfolio-regular container';
	} elseif ( $portfolio_layout == 'portfolio_fullwidth' ) {
		echo 'portfolio-fullwidth';
	} elseif ( $portfolio_layout == 'portfolio_extended' ) {
		echo 'portfolio-extended container';
	}
	?>">
		<div class="entry-header-wrapper container-fluid">
			<header class="entry-header">
				<div class="entry-title-wrap">
					<?php

					// Page Title
					if ( ! empty( $term ) ) {
						echo '<h2 class="entry-title">' . $term->name . '</h2>';
					} else {
						echo ' ';
					}

					?>
				</div>
				<div class="entry-title-wrap">
					<?php // portfolio categories ?>
					<?php if ( ! empty( $categories ) ) : ?>
						<div class="wrapp-categories-portfolio">
							<ul id="categories-portfolio" class="portfolio-categories">
								<li class="filter categories-item" data-filter=".category_all">
									<a href='#'><?php esc_attr_e( 'All', 'beautyagency' ); ?></a>
								</li>
								<?php foreach ( $categories as $category ) : ?>
									<span class="separator">/</span>
									<li class="filter categories-item"
									    data-filter=".category_<?php echo esc_attr($category->term_id); ?>">
										<a href='#'><?php echo esc_attr($category->name); ?></a>
									</li>
								<?php endforeach; ?>
							</ul>
						</div>
					<?php endif ?>
				</div>

				<?php
				// Unyson Breadcrumbs
				if ( function_exists( 'fw_ext_breadcrumbs' ) ) {
					fw_ext_breadcrumbs();
				}

				// Unyson Feedback
				if ( function_exists( 'fw_ext_feedback' ) ) {
					fw_ext_feedback();
				}

				?>
			</header><!-- .entry-header -->
		</div><!-- .entry-header-wrapper.container-fluid -->
		<main id="main" class="site-main">

			<div class="post-container snone">
				<div class="row">
					<div class="col-sm-12">

						<article id="post-<?php the_ID(); ?>" <?php post_class( 'portfolio-listing' ); ?>>

							<section class="portfolio" id="Container">
								<?php if ( have_posts() ) : ?>
									<ul id="portfolio-list" class="portfolio-list">
										<?php
										while ( have_posts() ) : the_post();
											include( fw()->extensions->get( 'portfolio' )->locate_view_path( 'loop-item' ) );
										endwhile;
										?>
										<li class="clear"></li>
									</ul>
								<?php else : ?>
									<?php get_template_part( 'content', 'none' ); ?>
								<?php endif; ?>
								<div class="clear"></div>
							</section>

						</article><!-- #post-## -->

					</div>
					<?php
					unset( $ext_portfolio_instance );
					unset( $ext_portfolio_settings );
					set_query_var( 'fw_portfolio_loop_data', '' );
					?>

				</div>
			</div>
		</main><!-- .site-main -->
	</div><!-- .content-area -->
<?php get_footer(); ?>