<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
} ?>
<?php if ( function_exists( 'ccm_register_post_types' ) ) : ?>
	<?php if ( isset( $data['slides'] ) ): ?>
		<?php

		$unique_id            = 'main-slider-' . fw_unique_increment();
		$slider_overlay_color = '';
		if ( ! empty( $data['settings'] ) && ! empty( $data['settings']['extra'] ) ) :
			$slider_overlay_color = ! empty( $data['settings']['extra']['slider_overlay_color'] ) ? $data['settings']['extra']['slider_overlay_color'] : 'rgba(13,13,13, 0.4)';
		endif;

		?>

		<div class="models-profile-slider">
			<ul class="<?php echo esc_attr($unique_id); ?>">
				<?php foreach ( $data['slides'] as $slide ): ?>
					<li>
						<?php
						//Get Slide Heading
						if ( ! empty( $slide['title'] ) ) {
							$slide_title = '<h2 class="h1">' . $slide['title'] . '</h2>';
						} else {
							$slide_title = '';
						}

						//Get Slide Image
						$get_slider_image_id = fw_get_db_post_option( $slide['extra']['post_id'], 'models_slider_image' );
						if ( ! empty( $get_slider_image_id ) ) {
							$slider_img_url = wp_get_attachment_image_src( $get_slider_image_id['attachment_id'], '', true );
						} else {
							$slider_img_url = '';
						}
						//Get Slide Category
						$slide_cat_id   = wp_get_post_terms( $slide['extra']['post_id'], 'models_category', '' );
						$slide_cat_name = $slide_cat_id[0]->name;

						//Get Model Parameters
						$height = ccm_get_profile_meta( $slide['extra']['post_id'], 'height' );
						$bust   = ccm_get_profile_meta( $slide['extra']['post_id'], 'bust' );
						$waist  = ccm_get_profile_meta( $slide['extra']['post_id'], 'waist' );
						$hips   = ccm_get_profile_meta( $slide['extra']['post_id'], 'hips' );
						$shoe   = ccm_get_profile_meta( $slide['extra']['post_id'], 'shoe' );
						$eyes   = ccm_get_profile_meta( $slide['extra']['post_id'], 'eyes' );


						// Model Parameters
						if ( ! empty( $height ) ) {
							$output = '<div class="model-height">';
							$output .= '<span>' . esc_html__( 'Height', 'beautyagency' ) . '</span><br/>' . $height;
							$output .= '</div>';
						}

						if ( ! empty( $bust ) ) {
							$output .= '<div class="model-bust">';
							$output .= '<span>' . esc_html__( 'Bust', 'beautyagency' ) . '</span><br/>' . $bust;
							$output .= '</div>';
						}

						if ( ! empty( $waist ) ) {
							$output .= '<div class="model-waist">';
							$output .= '<span>' . esc_html__( 'Waist', 'beautyagency' ) . '</span><br/>' . $waist;
							$output .= '</div>';
						}

						if ( ! empty( $hips ) ) {
							$output .= '<div class="model-hips">';
							$output .= '<span>' . esc_html__( 'Hips', 'beautyagency' ) . '</span><br/>' . $hips;
							$output .= '</div>';
						}

						if ( ! empty( $shoe ) ) {
							$output .= '<div class="model-shoe">';
							$output .= '<span>' . esc_html__( 'Shoe', 'beautyagency' ) . '</span><br/>' . $shoe;
							$output .= '</div>';
						}
						if ( ! empty( $eyes ) ) {
							$output .= '<div class="model-eyes">';
							$output .= '<span>' . esc_html__( 'Eyes', 'beautyagency' ) . '</span><br/>' . $eyes;
							$output .= '</div>';
						}

						?>
						<div style="background-color: <?php echo esc_attr( $slider_overlay_color ); ?>"
						     class="overlay"></div>
						<div class="slider-img-block" style="background-image: url(<?php echo esc_url($slider_img_url[0]); ?>);">
							<div class="row">
								<div class="container-fluid">
									<div class="col-md-6 inner-wrap">
										<div class="slide-inner">
											<?php if ( ! empty( $slide_cat_name ) ) : ?>
												<div class="fw-cat-row">
													<?php echo wp_kses( $slide_cat_name, beautyagency_kses_init() ); ?>
												</div>
											<?php endif; ?>
											<?php if ( ! empty( $slide_title ) ) : ?>
												<div class="fw-heading-row">
													<?php echo wp_kses( $slide_title, beautyagency_kses_init() ); ?>
												</div>
											<?php endif; ?>
											<?php
                                            // Output Models Parameters
                                            if ( ! beautyagency_get_customizer_option('hide_models_parameters_globally') ) {
	                                            echo '<div class="models-slider-parameters-block">' . $output . '</div>';
                                            }
                                            ?>

											<a href="<?php echo get_the_permalink( $slide['extra']['post_id'] ); ?>"><span
													class="show-profile">Read More</span></a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>
	<?php endif; ?>
<?php endif; ?>