<?php
/**
 * The template for displaying archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each one. For example, tag.php (Tag archives),
 * category.php (Category archives), author.php (Author archives), etc.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 */
get_header('page');?>

<div id="primary" class="content-area">
	<main id="main" class="site-main">
		<?php if ( have_posts() ) : ?>
		<div class="post-container <?php echo beautyagency_sidebar_class( "container" ); ?>">
			<div class="row site__row">
				<div class="<?php echo beautyagency_sidebar_class( "content" ); ?>">
					<?php

					// check post number
					$i = 0;
					if ( is_front_page() && is_home() ) {
						do_action( 'beautyagency_before_loop' );
					}

					// Start the Loop.
					while ( have_posts() ) : the_post();
						echo '<div class="post__wrap post__wrap--';
						if ( has_post_thumbnail() ) {
							echo 'with-media';
						} else {
							echo 'without-media';
						}
						echo '">';

						/*
						 * Include the Post-Format-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
						 */
						$thumbnail_args = array(
							'background' => true,
							'print'=>false
						);

						if ( empty( $media ) ) {
							// Post thumbnail.
							echo '<div class="post__media" style="'.beautyagency_post_thumbnail($thumbnail_args).'"></div>';
						} else {
							// Post video.
							echo beautyagency_parse_media(get_the_content());
						}
						echo '<div class="post-inner">';
						echo '<div class="post-content">';
						// Post Headers
						do_action( "beautyagency_after_thumbnail" );
						if( beautyagency_is_blog_view_excerpt() && !is_single() ){
							if(empty($media)) {
								echo "<p>".beautyagency_truncate_words( strip_tags( get_the_content() ), apply_filters( 'excerpt_length', false ) )."</p>";
							} else {
								echo "<p>".beautyagency_truncate_words( strip_tags( beautyagency_remove_first_line_media( get_the_content() ) ), apply_filters( 'excerpt_length', false ) )."</p>";
							}
							//echo apply_filters( 'excerpt_more', false ); //read more
						} else {
							/* translators: %s: Name of current post */
							the_content( sprintf(
								esc_html__( 'START READING %s', 'beautyagency' ),
								the_title( '<span class="screen-reader-text">', '</span>', false )
							) );

							wp_link_pages( array(
								'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'beautyagency' ) . '</span>',
								'after'       => '</div>',
								'link_before' => '<span>',
								'link_after'  => '</span>',
								'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'beautyagency' ) . ' </span>%',
								'separator'   => '<span class="screen-reader-text">, </span>',
							) );}
						echo '</div>';
						echo '<div class="post-meta">';
						$options = fw_get_db_post_option($post->ID, fw()->extensions->get( 'events' )->get_event_option_id());
						foreach($options['event_children'] as $key => $row) {
							if ( !empty( $row['event_date_range']['from'] ) ) {
								$date           = $row['event_date_range']['from'];
								$timestamp      = strtotime( $date );
								$formatted_date = date( 'F d, Y', $timestamp );
								echo '<i class="fa fa-calendar" aria-hidden="true"></i><span class="event-date">' . $formatted_date . '</span>';
							}
						}
						if ( !empty( $options['event_location']['venue'] ) ) {
							echo '<i class="fa fa-globe" aria-hidden="true"></i>';
							echo wp_kses($options['event_location']['venue'].', ', beautyagency_kses_init());
						}
						if ( !empty( $options['event_location']['city'] ) ) {
							echo wp_kses($options['event_location']['city'].' ', beautyagency_kses_init());
						}
						echo '</div></div>';
						$i++;
						echo '</div>';

						// End the loop.
					endwhile;

					// Previous/next page navigation.
					the_posts_pagination( array(
						'prev_text'          => '<i class="fa fa-angle-left" aria-hidden="true"></i>',
						'next_text'          => '<i class="fa fa-angle-right" aria-hidden="true"></i>',
						'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'beautyagency' ) . ' </span>',
					) );

					// If no content, include the "No posts found" template.
					else :
						get_template_part( 'partials/content', 'none' );
					endif;
					?>
				</div>
				<?php if(beautyagency_sidebar_visible()) : ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>
			</div>
		</div>
	</main><!-- .site-main -->
</div><!-- .content-area -->

<?php get_footer(); ?>
