<?php
/**
 * The template for displaying all single posts and attachments
 */

$theme_options = beautyagency_get_theme_mods();

global $post;
$options = fw_get_db_post_option( $post->ID, fw()->extensions->get( 'events' )->get_event_option_id() );

get_header( 'page' ); ?>

	<div id="primary" class="content-area event-single-page">
		<main id="main" class="site-main">
			<?php
			// Start the loop.
			while ( have_posts() ) :
			the_post();
			// Post Headers
			do_action( "beautyagency_after_thumbnail" );
			?>
			<div class="event-meta">
				<?php foreach ( $options['event_children'] as $key => $row ) {
					if ( ! empty( $row['event_date_range']['from'] ) ) {
						$date           = $row['event_date_range']['from'];
						$timestamp      = strtotime( $date );
						$formatted_date = date( 'F d, Y', $timestamp );
						echo esc_html__( 'On ', 'beautyagency' ) . $formatted_date . ' ';
						echo esc_html__( 'In ', 'beautyagency' );
					}
				}
				if ( ! empty( $options['event_location']['venue'] ) ) {
					echo wp_kses($options['event_location']['venue'] . ', ', beautyagency_kses_init());
				}
				if ( ! empty( $options['event_location']['city'] ) ) {
					echo wp_kses($options['event_location']['city'] . ' ', beautyagency_kses_init());
				}
				?>
			</div>
			<div class="post-container <?php echo beautyagency_sidebar_class( "container" ); ?>">
				<div class="row site__row">
					<div class="<?php echo beautyagency_sidebar_class( "content" ); ?>">
						<div class="post__inner">
							<?php
							if ( empty( $media ) && is_single() ) {
								// Post thumbnail.
								echo '<div class="post__media">';
								beautyagency_post_thumbnail();
								echo '</div>';
							} else {
								// Post video.
								echo beautyagency_parse_media( get_the_content() );
							}
							?>
							<div class="post-content">
								<?php
								/*
								 * Include the post format-specific template for the content. If you want to
								 * use this in a child theme, then include a file called called content-___.php
								 * (where ___ is the post format) and that will be used instead.
								 */
								if ( beautyagency_is_blog_view_excerpt() && ! is_single() ) {
									if ( empty( $media ) ) {
										echo "<p>" . beautyagency_truncate_words( strip_tags( get_the_content() ), apply_filters( 'beautyagency_excerpt_length', false ) ) . "</p>";
									} else {
										echo "<p>" . beautyagency_truncate_words( strip_tags( beautyagency_remove_first_line_media( get_the_content() ) ), apply_filters( 'beautyagency_excerpt_length', false ) ) . "</p>";
									}
								} else {
									/* translators: %s: Name of current post */
									the_content( sprintf(
										esc_html__( 'START READING %s', 'beautyagency' ),
										the_title( '<span class="screen-reader-text">', '</span>', false )
									) );

									wp_link_pages( array(
										'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'beautyagency' ) . '</span>',
										'after'       => '</div>',
										'link_before' => '<span>',
										'link_after'  => '</span>',
										'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'beautyagency' ) . ' </span>%',
										'separator'   => '<span class="screen-reader-text">, </span>',
									) );
								}

								// Post Controls
								if ( is_single() ) :
									beautyagency_post_controls();
								endif;

								// End the loop.
								endwhile;
								?>
								<?php if ( is_user_logged_in() ) { ?>
								<footer class="entry-footer">
									<div class="clearboth">&nbsp;</div>
									<?php edit_post_link( esc_html__( 'Edit', 'beautyagency' ), '<span class="edit-link">', '</span>' ); ?>
								</footer>
								<?php } ?><!-- .entry-footer -->
							</div> <!-- .post-content -->
							<?php
							// If comments are open or we have at least one comment, load up the comment template.
							if ( comments_open() || get_comments_number() ) :
								comments_template();
							endif;
							?>
						</div> <!-- .post__inner -->
					</div>
					<?php if ( beautyagency_sidebar_visible() ) : ?>
						<?php get_sidebar(); ?>
					<?php endif; ?>
				</div>
			</div>

		</main><!-- .site-main -->
	</div><!-- .content-area -->

<?php get_footer(); ?>