<?php
/**
 * The template for displaying comments
 *
 * The area of the page that contains both current comments
 * and the comment form.
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}

?>

<div id="comments" class="comments-area">
	<h2 class="comments-title">
		<?php
		printf( esc_html( _nx( '1 Comment', '%1$s Comments', get_comments_number(), 'comments title', 'beautyagency' ) ), number_format_i18n( get_comments_number() ) );
		?>
	</h2>

	<div class="comment-form-wrap row-fluid"><?php
		$commenter     = wp_get_current_commenter();
		$req           = get_option( 'require_name_email' );
		$aria_req      = ( $req ? " aria-required='true'" : '' );
		$required_text = "";

		$fields        = array(
			'author' =>
				'<div class="comment-form-author col-sm-6">' .
				'<input id="author" name="author" type="text" placeholder="' . esc_attr( 'Name' ) . ( $req ? '*' : '' ) . '" value="' . esc_attr( $commenter['comment_author'] ) .
				'" size="30"' . $aria_req . ' /></div>',

			'email' =>
				'<div class="comment-form-email col-sm-6">' .
				'<input id="email" name="email" type="text" placeholder="' . esc_attr( 'E-mail' ) . ( $req ? '*' : '' ) . '" value="' . esc_attr( $commenter['comment_author_email'] ) .
				'" size="30"' . $aria_req . ' /></div>',
		);
		$message_class = '';
		if ( is_user_logged_in() ) {
			$message_class = ' user_logged_in';
		}
		$args = array(
			'id_form'            => 'commentform',
			'id_submit'          => 'submit',
			'class_submit'       => 'submit',
			'name_submit'        => 'submit',
			'title_reply_before' => '<div id="reply-title" class="comment-reply-title">',
			'title_reply_after'  => '</div>',
			'title_reply'        => esc_html__( '', 'beautyagency' ),
			'title_reply_to'     => esc_html__( 'Leave a Reply to %s', 'beautyagency' ),
			'cancel_reply_link'  => esc_html__( 'Clear', 'beautyagency' ),
			'label_submit'       => esc_html__( 'Send', 'beautyagency' ),
			'format'             => 'xhtml',

			'comment_field' =>
				'<div class="comment-form-textarea"><textarea id="comment" name="comment" cols="45" rows="7" aria-required="true" placeholder="' . esc_html__( 'Comment', 'beautyagency' ) . '" >' .
				'</textarea></div>',

			'must_log_in' => '<p class="must-log-in">' .
			                 sprintf(
				                 wp_kses( __( 'You must be <a href="%s">logged in</a> to post a comment.', 'beautyagency' ), beautyagency_kses_init(), $allowed_html_array = array(
					                 'a' => array( // on allow a tags
						                 'href' => array() // and those anchors can only have href attribute
					                 )
				                 ) ),
				                 esc_url(wp_login_url( apply_filters( 'the_permalink', get_permalink() ) ))
			                 ) . '</p>',

			'logged_in_as' => '<p class="logged-in-as">' .
			                  sprintf(
				                  wp_kses( __( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>', 'beautyagency' ), beautyagency_kses_init(), $allowed_html_array = array(
					                  'a' => array( // on allow a tags
						                  'href' => array() // and those anchors can only have href attribute
					                  )
				                  ) ),
				                  esc_url(admin_url( 'profile.php' )),
				                  $user_identity,
				                  esc_url(wp_logout_url( apply_filters( 'the_permalink', get_permalink() ) ))
			                  ) . '</p>',

			'comment_notes_before' => '',

			'comment_notes_after' => '',

			'fields' => apply_filters( 'beautyagency_comment_form_default_fields', $fields ),
		);

		comment_form( $args );
		?></div>

	<?php if ( have_comments() ) : ?>

		<div class="comment-list-wrap">
			<?php beautyagency_comment_nav(); ?>
			<ol class="comment-list">
				<?php
				wp_list_comments( array(
					'style'       => 'ol',
					'short_ping'  => true,
					'avatar_size' => 160,
					//'per_page'    => 1,
					'callback'    => 'beautyagency_comment_callback',
				) );
				?>
			</ol><!-- .comment-list -->

			<nav class="navigation pagination">
				<?php paginate_comments_links( array(
					'prev_text' => esc_html__( 'PREV', 'beautyagency' ),
					'next_text' => esc_html__( 'NEXT', 'beautyagency' )
				) ); ?>
			</nav>
		</div>

	<?php endif; // have_comments() ?>

	<?php
	// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
		?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'beautyagency' ); ?></p>
	<?php endif; ?>
</div><!-- .comments-area -->