<?php
/**
 * The template for displaying Author bios
 */
?>

<div class="author-info">
	<div class="author-avatar">
		<?php
		/**
		 * Filter the author bio avatar size.
		 *
		 * @param int $size The avatar height and width size in pixels.
		 */
		$author_bio_avatar_size = apply_filters( 'beautyagency_author_bio_avatar_size', 170 );

		echo get_avatar( get_the_author_meta( 'user_email' ), $author_bio_avatar_size );
		?>
	</div><!-- .author-avatar -->

	<div class="author-content">

		<div class="author-description">
			<h3 class="author-title">
				<a class="author-link"
				   href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
					<?php echo esc_attr( get_the_author() ); ?>
				</a>
			</h3>
			<a class="author-user-url" href="<?php echo esc_url( get_the_author_meta( 'user_url' ) ); ?>" rel="author">
				<?php
				$author_user_url = esc_url( get_the_author_meta( 'user_url' ) );
				echo str_replace( 'http://', '', $author_user_url ); ?>
			</a>

			<p class="author-bio"><?php the_author_meta( 'description' ); ?>
			</p><!-- .author-bio -->
			<?php // Author social icons

			// Retrieve a custom field value /twitter/facebook/instagram/gplus
			$twitter   = get_the_author_meta( 'twitter' );
			$facebook  = get_the_author_meta( 'facebook' );
			$instagram = get_the_author_meta( 'instagram' );
			$gplus     = get_the_author_meta( 'gplus' );

			if ( $twitter !== '' || $facebook !== '' || $instagram !== '' || $gplus !== '' ) {
				echo '<ul class="author-meta-block">';
				if ( $facebook !== '' ) {
					echo '<li><a href="' . esc_url( $facebook ) . '"><i class="fa fa-facebook"></i></a></li>';
				}
				if ( $twitter !== '' ) {
					echo '<li><a href="' . esc_url( $twitter ) . '"><i class="fa fa-twitter"></i></a></li>';
				}
				if ( $instagram !== '' ) {
					echo '<li><a href="' . esc_url( $instagram ) . '"><i class="fa fa-instagram"></i></a></li>';
				}
				if ( $gplus !== '' ) {
					echo '<li><a href="' . esc_url( $gplus ) . '"><i class="fa fa-plus"></i></a></li>';
				}
				echo '</ul>';
			}
			?>

		</div><!-- .author-description -->
	</div><!-- .audio-content -->
</div><!-- .author-info -->
