<?php
/**
 * The template for displaying archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each one. For example, tag.php (Tag archives),
 * category.php (Category archives), author.php (Author archives), etc.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 */

get_header( 'page' ); ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main">
		<?php if ( have_posts() ) : ?>
		<div class="post-container <?php echo beautyagency_sidebar_class( "container" ); ?>">
			<div class="row site__row">
				<div class="<?php echo beautyagency_sidebar_class( "content" ); ?>">
					<?php

					// check post number
					$i = 0;
					if ( is_front_page() && is_home() ) {
						do_action( 'beautyagency_before_loop' );
					}

					// Start the Loop.
					while ( have_posts() ) : the_post();

						$post_size = ( $i % 3 ) == 0 ? "big" : "small";
						echo '<div class="post__wrap post__wrap--';
						echo esc_attr( $post_size );
						if ( has_post_thumbnail() ) {
							echo ' with-media';
						} else {
							echo ' without-media';
						}
						echo '">';

						/*
						 * Include the Post-Format-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
						 */
						get_template_part( 'partials/content', get_post_format() );

						$i ++;
						echo '</div>';

						// End the loop.
					endwhile;

					// Previous/next page navigation.
					the_posts_pagination( array(
						'prev_text'          => '<i class="fa fa-angle-left" aria-hidden="true"></i>',
						'next_text'          => '<i class="fa fa-angle-right" aria-hidden="true"></i>',
						'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'beautyagency' ) . ' </span>',
					) );

					// If no content, include the "No posts found" template.
					else :
						get_template_part( 'partials/content', 'none' );

					endif;
					?>
				</div>
				<?php if ( beautyagency_sidebar_visible() ) : ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>
			</div>
		</div>
	</main><!-- .site-main -->
</div><!-- .content-area -->

<?php get_footer(); ?>
