<?php
/**
 * The template for displaying 404 pages (not found)
 */

get_header( 'page' );

$theme_options = beautyagency_get_theme_mods();
?>

<div id="primary" class="content-area">
	<main id="main" class="site-main">

		<div class="container-fluid post-container">
			<div class="row site__row">
				<div class=" 404-site-content">

					<article class="hentry">
						<div class="entry-content">
							<section class="error-404 not-found">

								<?php // Page 404 image
								if ( $theme_options['page_image_404'] != '' ): ?>
									<img class="error-image"
									     src="<?php echo esc_url( $theme_options['page_image_404'] ); ?>" alt="<?php esc_attr_e('error', 'beautyagency'); ?>">
								<?php endif; ?>

								<?php // Page 404 title
								if ( $theme_options['page_title_404'] != '' ): ?>
									<h1 class="page_title_404 page-title"><?php echo esc_attr( $theme_options['page_title_404'] ); ?></h1>
								<?php elseif ( $theme_options['page_title_404'] == ' ' ): ?>
								<?php else: ?>
									<h1 class="page_title_404 page-title"><?php esc_html_e( 'Oops, page not found!', 'beautyagency' ); ?></h1>
								<?php endif; ?>

								<?php // Page Message
								if ( $theme_options['page_message_404'] != '' ): ?>
									<p class="page_message_404"><?php echo esc_attr( $theme_options['page_message_404'] ); ?></p>
									<p class="search_404_label"><?php esc_html_e( 'You can search what interested:', 'beautyagency' ); ?></p>
									<?php get_search_form(); ?>
								<?php elseif ( $theme_options['page_message_404'] == ' ' ): ?>
									<p class="search_404_label"><?php esc_html_e( 'You can search what interested:', 'beautyagency' ); ?></p>
									<?php get_search_form(); ?>
								<?php else: ?>
									<p class="page_message_404"><?php esc_html_e( 'The page you are looking for does not exist; it may have been moved, or removed altogether. You might want to try the search function. Alternatively, return to the front page.', 'beautyagency' ); ?></p>
									<p class="search_404_label"><?php esc_html_e( 'You can search what interested:', 'beautyagency' ); ?></p>
									<?php get_search_form(); ?>
								<?php endif; ?>

								<?php // Link to homepage
								if ( $theme_options['hide_homepage_link'] == '' ): ?>
									<p class="homepage_link_or"><?php esc_html_e('Or','beautyagency') ?></p>
									<p class="homepage_link"><a
											href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php if ( ! is_rtl() ) { ?><?php } ?>
											<span><?php esc_html_e( 'Go to Home', 'beautyagency' ); ?></span><?php if ( is_rtl() ) { ?><?php } ?>
										</a></p>
								<?php endif; ?>

							</section><!-- .error-404 -->
					</article><!-- #post-## -->

				</div>
			</div>
		</div>

	</main><!-- .site-main -->
</div><!-- .content-area -->

<?php get_footer(); ?>
