<?php
/**
 * Plugin rewrite functions.
 *
 * @package    CustomContentModels
 * @subpackage Includes
 * @author     Justin Tadlock <justin@justintadlock.com>
 * @copyright  Copyright (c) 2013-2015, Justin Tadlock
 * @license    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */

# Add custom rewrite rules.
add_action( 'init', 'ccm_rewrite_rules', 5 );

/**
 * Adds custom rewrite rules for the plugin.
 *
 * @since  1.0.0
 * @access public
 * @return void
 */
function ccm_rewrite_rules() {

	$profile_type = ccm_get_profile_post_type();
	$author_slug  = ccm_get_author_rewrite_slug();

	// Where to place the rewrite rules.  If no rewrite base, put them at the bottom.
	$after = ccm_get_author_rewrite_base() ? 'top' : 'bottom';

	add_rewrite_rule( $author_slug . '/([^/]+)/page/?([0-9]{1,})/?$', 'index.php?post_type=' . $profile_type . '&author_name=$matches[1]&paged=$matches[2]', $after );
	add_rewrite_rule( $author_slug . '/([^/]+)/?$',                   'index.php?post_type=' . $profile_type . '&author_name=$matches[1]',                   $after );
}

/**
 * Returns the profile rewrite slug used for single profiles.
 *
 * @since  1.0.0
 * @access public
 * @return string
 */
function ccm_get_profile_rewrite_slug() {
	$models_base = ccm_get_models_rewrite_base();
	$profile_base   = ccm_get_profile_rewrite_base();

	$slug = $profile_base ? trailingslashit( $models_base ) . $profile_base : $models_base;

	return apply_filters( 'ccm_get_profile_rewrite_slug', $slug );
}

/**
 * Returns the category rewrite slug used for category archives.
 *
 * @since  1.0.0
 * @access public
 * @return string
 */
function ccm_get_category_rewrite_slug() {
	$models_base = ccm_get_models_rewrite_base();
	$category_base  = ccm_get_category_rewrite_base();

	$slug = $category_base ? trailingslashit( $models_base ) . $category_base : $models_base;

	return apply_filters( 'ccm_get_category_rewrite_slug', $slug );
}

/**
 * Returns the tag rewrite slug used for tag archives.
 *
 * @since  1.0.0
 * @access public
 * @return string
 */
function ccm_get_tag_rewrite_slug() {
	$models_base = ccm_get_models_rewrite_base();
	$tag_base       = ccm_get_tag_rewrite_base();

	$slug = $tag_base ? trailingslashit( $models_base ) . $tag_base : $models_base;

	return apply_filters( 'ccm_get_tag_rewrite_slug', $slug );
}

/**
 * Returns the author rewrite slug used for author archives.
 *
 * @since  1.0.0
 * @access public
 * @return string
 */
function ccm_get_author_rewrite_slug() {
	$models_base = ccm_get_models_rewrite_base();
	$author_base  = ccm_get_author_rewrite_base();

	$slug = $author_base ? trailingslashit( $models_base ) . $author_base : $models_base;

	return apply_filters( 'ccm_get_author_rewrite_slug', $slug );
}
