<?php
/**
 * Plugin functions related to the profile post type.
 *
 * @package    CustomContentModels
 * @subpackage Includes
 * @author     Justin Tadlock <justin@justintadlock.com>
 * @copyright  Copyright (c) 2013-2015, Justin Tadlock
 * @license    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */

/**
 * Adds a profile to the list of sticky profiles.
 *
 * @since  1.0.0
 * @access public
 * @param  int    $profile_id
 * @return bool
 */
function ccm_add_sticky_profile( $profile_id ) {
	$profile_id = ccm_get_profile_id( $profile_id );

	if ( ! ccm_is_profile_sticky( $profile_id ) )
		return update_option( 'ccm_sticky_profiles', array_unique( array_merge( ccm_get_sticky_profiles(), array( $profile_id ) ) ) );

	return false;
}

/**
 * Removes a profile from the list of sticky profiles.
 *
 * @since  1.0.0
 * @access public
 * @param  int    $profile_id
 * @return bool
 */
function ccm_remove_sticky_profile( $profile_id ) {
	$profile_id = ccm_get_profile_id( $profile_id );

	if ( ccm_is_profile_sticky( $profile_id ) ) {
		$stickies = ccm_get_sticky_profiles();
		$key      = array_search( $profile_id, $stickies );

		if ( isset( $stickies[ $key ] ) ) {
			unset( $stickies[ $key ] );
			return update_option( 'ccm_sticky_profiles', array_unique( $stickies ) );
		}
	}

	return false;
}

/**
 * Returns an array of sticky profiles.
 *
 * @since  1.0.0
 * @access public
 * @return array
 */
function ccm_get_sticky_profiles() {
	return apply_filters( 'ccm_get_sticky_profiles', get_option( 'ccm_sticky_profiles', array() ) );
}


if ( ! function_exists( 'ccm_models_scripts' ) ) :
    function ccm_models_scripts() {
	    // Load prettyPhoto stylesheet.
	    wp_enqueue_style( 'prettyPhoto', plugins_url( '../css/prettyPhoto.css', __FILE__ ) );
	    // Load prettyPhoto javascript.
	    wp_enqueue_script( 'prettyPhoto', plugins_url( '../js/jquery.prettyPhoto.js', __FILE__ ) );

	    // Load plugin stylesheet.
	    wp_enqueue_style( 'ccm-models', plugins_url( '../css/models.css', __FILE__ ) );

	    // Load plugin javascript.
	    wp_enqueue_script( 'ccm-models-js', plugins_url( '../js/models.js', __FILE__ ), array ( 'prettyPhoto' ) );


//	    wp_enqueue_script( 'oildrop-theme-js', get_template_directory_uri() . '/js/theme.js', array ( 'jquery' ), "all", true );
    }
endif;
add_action( 'wp_enqueue_scripts', 'ccm_models_scripts' );