<?php
/**
 * Plugin options functions.
 *
 * @package    CustomContentModels
 * @subpackage Includes
 * @author     Justin Tadlock <justin@justintadlock.com>
 * @copyright  Copyright (c) 2013-2015, Justin Tadlock
 * @license    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */

/**
 * Returns the models title.
 *
 * @since  1.0.0
 * @access public
 * @return string
 */
function ccm_get_models_title() {
	return apply_filters( 'ccm_get_models_title', ccm_get_setting( 'models_title' ) );
}

/**
 * Returns the models description.
 *
 * @since  1.0.0
 * @access public
 * @return string
 */
function ccm_get_models_description() {
	return apply_filters( 'ccm_get_models_description', ccm_get_setting( 'models_description' ) );
}

/**
 * Returns the models title.
 *
 * @since  1.0.0
 * @access public
 * @return string
 */
function ccm_get_models_per_page() {
	return apply_filters( 'ccm_get_models_per_page', ccm_get_setting( 'models_per_page' ) );
}

/**
 * Returns the models layout.
 *
 * @since  1.0.0
 * @access public
 * @return string
 */
function ccm_get_models_layout() {
	return apply_filters( 'ccm_get_models_layout', ccm_get_setting( 'models_layout' ) );
}

/**
 * Returns the models rewrite base. Used for the profile archive and as a prefix for taxonomy,
 * author, and any other slugs.
 *
 * @since  1.0.0
 * @access public
 * @return string
 */
function ccm_get_models_rewrite_base() {
	return apply_filters( 'ccm_get_models_rewrite_base', ccm_get_setting( 'models_rewrite_base' ) );
}

/**
 * Returns the profile rewrite base. Used for single profiles.
 *
 * @since  1.0.0
 * @access public
 * @return string
 */
function ccm_get_profile_rewrite_base() {
	return apply_filters( 'ccm_get_profile_rewrite_base', ccm_get_setting( 'profile_rewrite_base' ) );
}

/**
 * Returns the category rewrite base. Used for category archives.
 *
 * @since  1.0.0
 * @access public
 * @return string
 */
function ccm_get_category_rewrite_base() {
	return apply_filters( 'ccm_get_category_rewrite_base', ccm_get_setting( 'category_rewrite_base' ) );
}

/**
 * Returns the tag rewrite base. Used for tag archives.
 *
 * @since  1.0.0
 * @access public
 * @return string
 */
function ccm_get_tag_rewrite_base() {
	return apply_filters( 'ccm_get_tag_rewrite_base', ccm_get_setting( 'tag_rewrite_base' ) );
}

/**
 * Returns the author rewrite base. Used for author archives.
 *
 * @since  1.0.0
 * @access public
 * @return string
 */
function ccm_get_author_rewrite_base() {
	return apply_filters( 'ccm_get_author_rewrite_base', ccm_get_setting( 'author_rewrite_base' ) );
}

/**
 * Returns the default category term ID.
 *
 * @since  1.0.0
 * @access public
 * @return int
 */
function ccm_get_default_category() {
	return apply_filters( 'ccm_get_default_category', 0 );
}

/**
 * Returns the default tag term ID.
 *
 * @since  1.0.0
 * @access public
 * @return int
 */
function ccm_get_default_tag() {
	return apply_filters( 'ccm_get_default_tag', 0 );
}

/**
 * Returns a plugin setting.
 *
 * @since  1.0.0
 * @access public
 * @param  string  $setting
 * @return mixed
 */
function ccm_get_setting( $setting ) {

	$defaults = ccm_get_default_settings();
	$settings = wp_parse_args( get_option( 'ccm_settings', $defaults ), $defaults );

	return isset( $settings[ $setting ] ) ? $settings[ $setting ] : false;
}

/**
 * Returns the default settings for the plugin.
 *
 * @since  0.1.0
 * @access public
 * @return array
 */
function ccm_get_default_settings() {

	$settings = array(
		'models_title'        => __( 'Models', 'custom-content-models' ),
		'models_description'  => '',
		'models_per_page'  => 20,
		'models_layout'  => 'style_1',
		'models_rewrite_base' => 'models',
		'profile_rewrite_base'   => 'profiles',
		'category_rewrite_base'  => 'categories',
		'tag_rewrite_base'       => 'tags',
		'author_rewrite_base'    => 'authors'
	);

	return $settings;
}
